/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.contextmenu;

import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import org.jdownloader.controlling.contextmenu.CustomizableSelectionAppAction;
import org.jdownloader.controlling.contextmenu.TableContext;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;

public abstract class CustomizableTableContextAppAction<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
extends CustomizableSelectionAppAction<PackageType, ChildrenType> {
    protected TableContext tableContext;

    public CustomizableTableContextAppAction(boolean empty, boolean selection) {
        this.initTableContext(empty, selection);
    }

    public CustomizableTableContextAppAction() {
    }

    protected void initTableContext(boolean empty, boolean selection) {
        this.tableContext = new TableContext(empty, selection);
        this.addContextSetup(0, this.tableContext);
    }

    protected void removeTableContext() {
        this.removeContextSetup(this.tableContext);
    }

    @Override
    protected void requestUpdateSelection(final Object requestor) {
        final PackageControllerTable.SelectionType selectionType = this.getSelectionType();
        this.getSelection(new PackageControllerTable.EDTSelectionInfoCallback<PackageType, ChildrenType>(){

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public void onSelectionInfo(SelectionInfo<PackageType, ChildrenType> selectionInfo) {
                CustomizableTableContextAppAction.this.onRequestUpdateSelection(requestor, selectionType, selectionInfo);
            }
        }, selectionType);
    }

    @Override
    protected void onRequestUpdateSelection(Object requestor, PackageControllerTable.SelectionType selectionType, SelectionInfo<PackageType, ChildrenType> selectionInfo) {
        boolean hasSelectoin = SelectionInfo.isNotEmpty(selectionInfo);
        if (this.tableContext != null) {
            if (hasSelectoin) {
                if (this.tableContext.isItemVisibleForSelections()) {
                    this.setVisible(true);
                    this.setEnabled(true);
                } else {
                    this.setVisible(false);
                    this.setEnabled(false);
                }
            } else if (this.tableContext.isItemVisibleForEmptySelection()) {
                this.setVisible(true);
                this.setEnabled(true);
            } else {
                this.setVisible(false);
                this.setEnabled(false);
            }
        } else if (!hasSelectoin) {
            this.setVisible(false);
            this.setEnabled(false);
        } else if (hasSelectoin) {
            this.setVisible(true);
            this.setEnabled(true);
        }
    }

    public TableContext getTableContext() {
        return this.tableContext;
    }
}

