/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.contextmenu;

import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import javax.swing.JMenu;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.StringUtils;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.contextmenu.ActionData;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.gui.ExtMenuImpl;
import org.jdownloader.controlling.contextmenu.gui.MenuBuilder;

public class MenuContainer
extends MenuItemData {
    public MenuContainer() {
        this.setType(null);
    }

    public void add(Class<? extends AppAction> class1) {
        this.add(new ActionData(class1));
    }

    public void add(ActionData actionData) {
        this.add(new MenuItemData(actionData));
    }

    @Override
    public MenuItemData.Type getType() {
        return MenuItemData.Type.CONTAINER;
    }

    public MenuContainer(String name, String iconKey) {
        this.setType(null);
        this.setName(name);
        this.setIconKey(iconKey);
    }

    @Override
    public JMenu createItem(MenuBuilder menuBuilder) {
        ExtMenuImpl subMenu = new ExtMenuImpl(this.getName());
        if (StringUtils.isNotEmpty((String)this._getDescription())) {
            subMenu.getAccessibleContext().setAccessibleDescription(this._getDescription());
        }
        if (StringUtils.isNotEmpty((String)this.getMnemonic())) {
            try {
                Field f = KeyEvent.class.getField("VK_" + Character.toUpperCase(this.getMnemonic().charAt(0)));
                int m = (Integer)f.get(null);
                subMenu.setMnemonic(m);
            }
            catch (Exception e) {
                throw new WTFException((Throwable)e);
            }
        }
        if (this.getIconKey() != null) {
            subMenu.setIcon(MenuItemData.getIcon(this.getIconKey(), 18));
        }
        return subMenu;
    }
}

