/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.contextmenu.gui;

import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.jdownloader.controlling.contextmenu.gui.ExtMenuInterface;

public class ExtMenuImpl
extends JMenu
implements ExtMenuInterface {
    protected final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "enabled") {
                ExtMenuImpl.this.refreshEnabledState(Boolean.TRUE.equals(evt.getNewValue()));
            }
            if ("visible" == evt.getPropertyName()) {
                ExtMenuImpl.this.refreshJSeparatorVisibility();
            }
        }
    };
    protected final ContainerListener containerListener = new ContainerListener(){

        @Override
        public void componentRemoved(ContainerEvent e) {
            Component child = e.getChild();
            child.removePropertyChangeListener(ExtMenuImpl.this.propertyChangeListener);
            if (ExtMenuImpl.this.isEnabled()) {
                ExtMenuImpl.this.refreshEnabledState(false);
            }
            ExtMenuImpl.this.refreshJSeparatorVisibility();
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component child = e.getChild();
            child.addPropertyChangeListener(ExtMenuImpl.this.propertyChangeListener);
            if (!ExtMenuImpl.this.isEnabled() && child.isEnabled()) {
                ExtMenuImpl.this.refreshEnabledState(true);
            }
            if (ExtMenuImpl.this.touchesJSeparator(child)) {
                ExtMenuImpl.this.refreshJSeparatorVisibility();
            }
        }
    };
    private static final long serialVersionUID = 1L;

    public ExtMenuImpl(String name) {
        super(name);
        this.setEnabled(false);
    }

    protected boolean touchesJSeparator(Component com) {
        if (com instanceof JSeparator) {
            return true;
        }
        JPopupMenu popup = this.getPopupMenu();
        if (popup == null) {
            return false;
        }
        int index = popup.getComponentIndex(com);
        if (index == -1) {
            return false;
        }
        Component before = this.getMenuComponent(Math.max(0, index - 1));
        if (before instanceof JSeparator) {
            return true;
        }
        Component after = this.getMenuComponent(Math.min(popup.getComponentCount() - 1, index + 2));
        return after instanceof JSeparator;
    }

    protected void refreshEnabledState(boolean enabled) {
        if (enabled) {
            this.setEnabled(true);
        } else {
            boolean isEnabled = false;
            for (Component elem : this.getMenuComponents()) {
                if (!elem.isEnabled()) continue;
                isEnabled = true;
                break;
            }
            this.setEnabled(isEnabled);
        }
    }

    protected void refreshJSeparatorVisibility() {
        Component lastVisibleElem = null;
        boolean lastVisible = false;
        boolean revalidate = false;
        for (Component elem : this.getMenuComponents()) {
            boolean isElemVisible = elem.isVisible();
            if (elem instanceof JSeparator) {
                if (lastVisibleElem instanceof JSeparator) {
                    elem.setVisible(false);
                    revalidate |= isElemVisible;
                    lastVisible = false;
                } else {
                    elem.setVisible(lastVisible);
                    revalidate |= isElemVisible != lastVisible;
                }
            } else {
                lastVisible = isElemVisible;
            }
            if (!lastVisible) continue;
            lastVisibleElem = elem;
        }
        if (revalidate) {
            this.revalidate();
        }
    }

    @Override
    protected JMenu.WinListener createWinListener(JPopupMenu p) {
        p.addContainerListener(this.containerListener);
        return super.createWinListener(p);
    }

    @Override
    public void cleanup() {
        while (this.getMenuComponentCount() > 0 && this.getMenuComponent(this.getMenuComponentCount() - 1) instanceof JSeparator) {
            this.remove(this.getMenuComponentCount() - 1);
        }
        if (this.getMenuComponentCount() == 0) {
            this.setEnabled(false);
        }
    }
}

