/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.contextmenu.gui;

import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.contextmenu.gui.ExtMenuInterface;

public class ExtPopupMenu
extends JPopupMenu
implements ExtMenuInterface {
    protected final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "enabled") {
                ExtPopupMenu.this.refreshEnabledState(Boolean.TRUE.equals(evt.getNewValue()));
            }
            if ("visible" == evt.getPropertyName()) {
                ExtPopupMenu.this.refreshJSeparatorVisibility();
            }
        }
    };
    protected final ContainerListener containerListener = new ContainerListener(){

        @Override
        public void componentRemoved(ContainerEvent e) {
            Component child = e.getChild();
            child.removePropertyChangeListener(ExtPopupMenu.this.propertyChangeListener);
            if (ExtPopupMenu.this.isEnabled()) {
                ExtPopupMenu.this.refreshEnabledState(false);
            }
            ExtPopupMenu.this.refreshJSeparatorVisibility();
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component child = e.getChild();
            child.addPropertyChangeListener(ExtPopupMenu.this.propertyChangeListener);
            if (!ExtPopupMenu.this.isEnabled() && child.isEnabled()) {
                ExtPopupMenu.this.refreshEnabledState(true);
            }
            if (ExtPopupMenu.this.touchesJSeparator(child)) {
                ExtPopupMenu.this.refreshJSeparatorVisibility();
            }
        }
    };

    protected boolean touchesJSeparator(Component com) {
        if (com instanceof JSeparator) {
            return true;
        }
        int index = this.getComponentIndex(com);
        if (index == -1) {
            return false;
        }
        Component before = this.getComponent(Math.max(0, index - 1));
        if (before instanceof JSeparator) {
            return true;
        }
        Component after = this.getComponent(Math.min(this.getComponentCount() - 1, index + 1));
        return after instanceof JSeparator;
    }

    public ExtPopupMenu() {
        this.addContainerListener(this.containerListener);
        this.setEnabled(false);
    }

    protected void refreshEnabledState(boolean enabled) {
        if (enabled) {
            this.setEnabled(true);
        } else {
            boolean isEnabled = false;
            for (Component elem : this.getComponents()) {
                if (!elem.isEnabled()) continue;
                isEnabled = true;
                break;
            }
            this.setEnabled(isEnabled);
        }
    }

    protected void refreshJSeparatorVisibility() {
        Component lastVisibleElem = null;
        boolean lastVisible = false;
        boolean revalidate = false;
        for (Component elem : this.getComponents()) {
            boolean isElemVisible = elem.isVisible();
            if (elem instanceof JSeparator) {
                if (lastVisibleElem instanceof JSeparator) {
                    elem.setVisible(false);
                    revalidate |= isElemVisible;
                    lastVisible = false;
                } else {
                    elem.setVisible(lastVisible);
                    revalidate |= isElemVisible != lastVisible;
                }
            } else {
                lastVisible = isElemVisible;
            }
            if (!lastVisible) continue;
            lastVisibleElem = elem;
        }
        if (revalidate) {
            this.revalidate();
        }
    }

    @Override
    protected JMenuItem createActionComponent(Action a) {
        JMenuItem ret = ((AppAction)((Object)a)).isToggle() ? new JCheckBoxMenuItem(a) : super.createActionComponent(a);
        if (a instanceof AppAction) {
            ((AppAction)((Object)a)).addVisibilityPropertyChangeListener(ret);
        }
        return ret;
    }

    @Override
    public void cleanup() {
        while (this.getComponentCount() > 0 && this.getComponent(this.getComponentCount() - 1) instanceof JSeparator) {
            this.remove(this.getComponentCount() - 1);
        }
        if (this.getComponentCount() == 0) {
            this.setEnabled(false);
        }
    }
}

