/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.contextmenu.gui;

import java.util.ArrayList;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdownloader.controlling.contextmenu.MenuContainerRoot;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.gui.MenuManagerTree;

public class ManagerTreeModel
extends DefaultTreeModel
implements TreeModel {
    private MenuContainerRoot data;
    private MenuManagerTree tree;

    public ManagerTreeModel() {
        super(null, false);
    }

    public void set(MenuContainerRoot menuContainerRoot) {
        MenuContainerRoot data;
        this.data = data = menuContainerRoot.clone();
        this.fireTreeStructureChanged(this, new Object[]{data}, null, null);
    }

    @Override
    public Object getRoot() {
        return this.data;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((MenuItemData)parent).getItems().get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((MenuItemData)parent).getItems() == null ? 0 : ((MenuItemData)parent).getItems().size();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((MenuItemData)node).getType() != MenuItemData.Type.CONTAINER;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((MenuItemData)parent).getItems().indexOf(child);
    }

    public void moveTo(TreePath obj, MenuItemData parent, int childIndex) {
        MenuItemData itemToMove = (MenuItemData)obj.getLastPathComponent();
        MenuItemData oldParent = (MenuItemData)obj.getPathComponent(obj.getPathCount() - 2);
        if (childIndex < 0) {
            oldParent.getItems().remove(itemToMove);
            parent.getItems().add(itemToMove);
        } else {
            ArrayList<MenuItemData> a = new ArrayList<MenuItemData>(parent.getItems().subList(0, childIndex));
            ArrayList<MenuItemData> b = new ArrayList<MenuItemData>(parent.getItems().subList(childIndex, parent.getItems().size()));
            if (!a.remove(itemToMove)) {
                b.remove(itemToMove);
            }
            ArrayList<MenuItemData> newlist = new ArrayList<MenuItemData>();
            newlist.addAll(a);
            newlist.add(itemToMove);
            newlist.addAll(b);
            parent.setItems(newlist);
            if (oldParent != parent) {
                oldParent.getItems().remove(itemToMove);
            }
        }
        this.fireTreeStructureChanged(this, new Object[]{this.data}, null, null);
    }

    public void remove(TreePath treePath) {
        if (treePath != null) {
            MenuItemData parent = (MenuItemData)treePath.getPathComponent(treePath.getPathCount() - 2);
            parent.getItems().remove(treePath.getLastPathComponent());
            this.fireTreeStructureChanged(this, new Object[]{this.data}, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreePath addAction(TreePath treePath, MenuItemData menuItemData) {
        block4: {
            block5: {
                TreePath treePath2;
                try {
                    menuItemData._setValidated(true);
                    if (treePath == null || treePath.getLastPathComponent() == this.data) break block4;
                    if (((MenuItemData)treePath.getLastPathComponent()).getType() != MenuItemData.Type.CONTAINER) break block5;
                    ((MenuItemData)treePath.getLastPathComponent()).getItems().add(menuItemData);
                    treePath2 = treePath.pathByAddingChild(menuItemData);
                }
                catch (Throwable throwable) {
                    this.fireTreeStructureChanged(this, new Object[]{this.data}, null, null);
                    throw throwable;
                }
                this.fireTreeStructureChanged(this, new Object[]{this.data}, null, null);
                return treePath2;
            }
            MenuItemData parent = (MenuItemData)treePath.getPathComponent(treePath.getPathCount() - 2);
            int index = parent.getItems().indexOf(treePath.getLastPathComponent());
            parent.getItems().add(index + 1, menuItemData);
            TreePath treePath3 = treePath.getParentPath().pathByAddingChild(menuItemData);
            this.fireTreeStructureChanged(this, new Object[]{this.data}, null, null);
            return treePath3;
        }
        this.data.getItems().add(menuItemData);
        TreePath treePath4 = new TreePath(new Object[]{this.data, menuItemData});
        this.fireTreeStructureChanged(this, new Object[]{this.data}, null, null);
        return treePath4;
    }

    @Override
    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        this.data.validateFull();
        if (this.tree != null) {
            TreePath[] paths = this.tree.getSelectionPaths();
            super.fireTreeStructureChanged(source, path, childIndices, children);
            if (paths != null) {
                this.tree.setSelectionPaths(paths);
            }
            this.tree.expandAll();
        }
    }

    public void fireUpdate() {
        this.fireTreeStructureChanged(this, new Object[]{this.data}, null, null);
    }

    public void setTree(MenuManagerTree extTree) {
        this.tree = extTree;
    }
}

