/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.contextmenu.gui;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.appwork.swing.action.BasicAction;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.contextmenu.ContextMenuManager;
import org.jdownloader.controlling.contextmenu.MenuContainer;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.SeparatorData;
import org.jdownloader.controlling.contextmenu.gui.AfterLayerUpdateInterface;
import org.jdownloader.controlling.contextmenu.gui.ExtMenuInterface;
import org.jdownloader.extensions.ExtensionNotLoadedException;

public class MenuBuilder {
    protected final JComponent root;
    protected final MenuContainer menuData;
    protected final LogSource logger;
    protected final HashMap<JComponent, HashSet<Integer>> mnemonics;
    protected boolean hideOnClick = true;
    protected final AtomicBoolean isCanceled = new AtomicBoolean(false);

    public boolean isHideOnClick() {
        return this.hideOnClick;
    }

    public AtomicBoolean getCancelled() {
        return this.isCanceled;
    }

    public MenuBuilder setHideOnClick(boolean hideOnClick) {
        this.hideOnClick = hideOnClick;
        return this;
    }

    public MenuBuilder(ContextMenuManager<?, ?> menuManager, JComponent root, MenuContainer md) {
        this.root = root;
        if (root instanceof JPopupMenu) {
            ((JPopupMenu)root).addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    MenuBuilder.this.isCanceled.set(true);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    MenuBuilder.this.isCanceled.set(true);
                }
            });
        }
        this.menuData = md;
        this.logger = menuManager.getLogger();
        this.mnemonics = new HashMap();
    }

    protected void registerMnemonic(JComponent root, int mnem) {
        HashSet<Integer> set = this.mnemonics.get(root);
        if (set == null) {
            set = new HashSet();
            this.mnemonics.put(root, set);
        }
        set.add(mnem);
    }

    public void applyMnemonic(JComponent root, AbstractButton submenu) {
        int mnem = submenu.getMnemonic();
        if (mnem == 0 && submenu.getText() != null) {
            for (int i = 0; i < submenu.getText().length(); ++i) {
                mnem = BasicAction.charToMnemonic((char)submenu.getText().charAt(i));
                if (mnem <= 0 || this.isMnemonicUsed(root, mnem)) continue;
                submenu.setMnemonic(mnem);
                break;
            }
        }
        this.registerMnemonic(root, mnem);
    }

    protected boolean isMnemonicUsed(JComponent root, int mnem) {
        HashSet<Integer> set = this.mnemonics.get(root);
        if (set == null) {
            return false;
        }
        return set.contains(mnem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void createLayer(JComponent root, MenuContainer md) {
        if (root == null) {
            return;
        }
        counter = 0;
lbl4:
        // 7 sources

        for (MenuItemData i : md.getItems()) {
            try {
                inst = i;
                if (inst._getValidateException() != null) continue;
                count = root.getComponentCount();
                if (root instanceof JMenu) {
                    count = ((JMenu)root).getMenuComponentCount() + root.getComponentCount();
                }
                if (count == 0 && inst instanceof SeparatorData) continue;
                switch (3.$SwitchMap$org$jdownloader$controlling$contextmenu$MenuItemData$Type[inst.getType().ordinal()]) {
                    case 1: {
                        this.addAction(root, inst, counter, md.getItems().size());
                        ** break;
                    }
                    case 2: {
                        this.addContainer(root, inst, counter, md.getItems().size());
                        ** break;
                    }
                    default: {
                        throw new Exception("Unsupported Type:" + (Object)inst.getType());
                    }
                }
            }
            catch (Throwable e) {
                this.logger.warning("Could Not Build MenuItem: " + i);
                this.logger.log(e);
            }
            finally {
                ++counter;
            }
        }
        if (root instanceof ExtMenuInterface) {
            ((ExtMenuInterface)root).cleanup();
        }
        for (Component c : root.getComponents()) {
            if (!(c instanceof AfterLayerUpdateInterface)) continue;
            ((AfterLayerUpdateInterface)c).onAfterLayerDone(root, md);
        }
    }

    protected void addContainer(JComponent root, MenuItemData inst, int index, int size) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, ExtensionNotLoadedException {
        JMenu submenu = (JMenu)inst.addTo(root, this);
        if (submenu != null) {
            this.createLayer(submenu, (MenuContainer)inst);
            if (submenu.getMenuComponentCount() == 0) {
                root.remove(submenu);
            }
        }
    }

    protected void addAction(JComponent root, MenuItemData inst, int index, int size) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, ExtensionNotLoadedException {
        inst.addTo(root, this);
    }

    public void run() {
        new EDTRunner(){

            protected void runInEDT() {
                MenuBuilder.this.createLayer(MenuBuilder.this.root, MenuBuilder.this.menuData);
            }
        };
    }
}

