/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.domainrules;

import java.util.regex.Pattern;
import jd.plugins.Account;
import org.jdownloader.controlling.domainrules.DomainRule;

public class CompiledDomainRule {
    private final DomainRule rule;
    private final Pattern domainPattern;
    private final Pattern accountPattern;
    private final Pattern filenamePattern;
    private final Pattern pluginPattern;

    public CompiledDomainRule(DomainRule dr) {
        this.domainPattern = dr.getDomainPattern() == null ? null : Pattern.compile(dr.getDomainPattern(), 32);
        this.accountPattern = dr.getAccountPattern() == null ? null : Pattern.compile(dr.getAccountPattern(), 32);
        this.pluginPattern = dr.getPluginPattern() == null ? null : Pattern.compile(dr.getPluginPattern(), 32);
        this.filenamePattern = dr.getFilenamePattern() == null ? null : Pattern.compile(dr.getFilenamePattern(), 32);
        this.rule = dr;
    }

    public boolean matches(Account account, String domain, String plugin, String filename) {
        if (this.accountPattern != null && !this.accountPattern.matcher(account == null ? "" : account.getUser()).matches()) {
            return false;
        }
        if (this.filenamePattern != null && !this.filenamePattern.matcher(filename == null ? "" : filename).matches()) {
            return false;
        }
        if (this.domainPattern != null && !this.domainPattern.matcher(domain == null ? "" : domain).matches()) {
            return false;
        }
        return this.pluginPattern == null || this.pluginPattern.matcher(plugin == null ? "" : plugin).matches();
    }

    public DomainRule getDomainRule() {
        return this.rule;
    }

    public Integer getMaxChunks() {
        return this.rule.getMaxChunks();
    }

    public int getMaxSimultanDownloads() {
        return this.rule.getMaxSimultanDownloads();
    }

    public boolean isAllowToExceedTheGlobalLimit() {
        return this.rule.isAllowToExceedTheGlobalLimit();
    }
}

