/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.domainrules;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import jd.plugins.Account;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.uio.ExceptionDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.swing.dialog.ExceptionDialog;
import org.jdownloader.controlling.domainrules.CompiledDomainRule;
import org.jdownloader.controlling.domainrules.DomainRule;
import org.jdownloader.controlling.domainrules.DomainRuleSet;
import org.jdownloader.controlling.domainrules.event.DomainRuleControllerEvent;
import org.jdownloader.controlling.domainrules.event.DomainRuleControllerEventSender;
import org.jdownloader.controlling.domainrules.event.DomainRuleControllerListener;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class DomainRuleController
implements GenericConfigEventListener<Object> {
    private static final DomainRuleController INSTANCE = new DomainRuleController();
    private List<CompiledDomainRule> rules;
    private final DomainRuleControllerEventSender eventSender = new DomainRuleControllerEventSender();
    private int maxSimultaneousDownloads;

    public static DomainRuleController getInstance() {
        return INSTANCE;
    }

    private DomainRuleController() {
        CFG_GENERAL.DOMAIN_RULES.getEventSender().addListener((EventListener)((Object)this));
        this.update();
    }

    public DomainRuleControllerEventSender getEventSender() {
        return this.eventSender;
    }

    public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
        this.update();
    }

    private void update() {
        ArrayList<DomainRule> rules = CFG_GENERAL.CFG.getDomainRules();
        ArrayList<CompiledDomainRule> newList = new ArrayList<CompiledDomainRule>();
        int maxDownloads = 0;
        if (rules != null) {
            for (DomainRule dr : rules) {
                if (dr == null || !dr.isEnabled()) continue;
                try {
                    newList.add(new CompiledDomainRule(dr));
                    if (!dr.isAllowToExceedTheGlobalLimit()) continue;
                    maxDownloads = Math.max(maxDownloads, dr.getMaxSimultanDownloads());
                }
                catch (Throwable e) {
                    UIOManager.I().show(ExceptionDialogInterface.class, (UserIODefinition)new ExceptionDialog(16, _GUI.T.lit_error_occured(), e.getMessage() + "\r\n" + JSonStorage.toString((Object)dr), e, _GUI.T.lit_close(), null));
                }
            }
        }
        this.rules = newList;
        this.maxSimultaneousDownloads = maxDownloads;
        this.eventSender.fireEvent((DefaultEvent)new DomainRuleControllerEvent(){

            @Override
            public void sendTo(DomainRuleControllerListener listener) {
                listener.onDomainRulesUpdated();
            }
        });
    }

    @Deprecated
    public int getMaxSimultanDownloads() {
        return this.getMaxSimultaneousDownloads();
    }

    public int getMaxSimultaneousDownloads() {
        return this.maxSimultaneousDownloads;
    }

    public DomainRuleSet createRuleSet(Account account, String downloadDomain, String pluginDomain, String name) {
        DomainRuleSet set = new DomainRuleSet();
        for (CompiledDomainRule rule : this.rules) {
            if (!rule.matches(account, downloadDomain, pluginDomain, name)) continue;
            set.add(rule);
        }
        return set;
    }
}

