/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.ffmpeg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jd.http.Browser;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.controlling.ffmpeg.AbstractFFmpegBinary;
import org.jdownloader.controlling.ffmpeg.FFMpegException;
import org.jdownloader.controlling.ffmpeg.FFMpegProgress;
import org.jdownloader.settings.GeneralSettings;

public abstract class FFmpeg
extends AbstractFFmpegBinary {
    private static final Object LOCK = new Object();

    public FFmpeg(Browser br) {
        super(br);
        String path = this.config.getBinaryPath();
        this.setPath(path);
    }

    public FFmpeg() {
        this(null);
    }

    @Override
    public boolean isCompatible() {
        String sha256;
        if (CrossSystem.isWindows() && !CrossSystem.getOS().isMinimum(CrossSystem.OperatingSystem.WINDOWS_7) && (StringUtils.equalsIgnoreCase((String)"4d41c2db307db1e6639915aa480b363546ada1990d2fd143680a3673483f3a72", (String)(sha256 = Hash.getFileHash((File)new File(this.getFullPath()), (String)"SHA-256"))) || StringUtils.equalsIgnoreCase((String)"a26f910d561aa3a6a8e2ce70b5dba79e0639fb93eb77b3c2bf1c915901ecbe3e", (String)sha256))) {
            this.getLogger().severe("ffmpeg binary(" + this.getFullPath() + ") requires minimum Windows 7!");
            return false;
        }
        return super.isCompatible();
    }

    public void moveFile(File dest, File source) throws IOException {
        if (!source.isFile()) {
            throw new FileNotFoundException("source:" + source.getAbsolutePath());
        }
        if (!dest.delete() && dest.exists()) {
            throw new IOException("cannot delete dest:" + dest.getAbsolutePath());
        }
        IO.copyFile((File)source, (File)dest);
    }

    public boolean muxToMkv(FFMpegProgress progress, String out, String videoIn, String audioIn) throws InterruptedException, IOException, FFMpegException {
        return this.mux(progress, out, videoIn, audioIn, this.config.getMuxToMkvCommand());
    }

    public boolean muxToMp4(FFMpegProgress progress, String out, String videoIn, String audioIn) throws InterruptedException, IOException, FFMpegException {
        return this.mux(progress, out, videoIn, audioIn, this.config.getMuxToMp4Command());
    }

    public boolean generateM4a(FFMpegProgress progress, String out, String audioIn) throws IOException, InterruptedException, FFMpegException {
        return this.demux(progress, out, audioIn, this.config.getDash2M4aCommand());
    }

    public boolean generateAac(FFMpegProgress progress, String out, String audioIn) throws InterruptedException, IOException, FFMpegException {
        return this.demux(progress, out, audioIn, this.config.getDash2AacCommand());
    }

    public boolean demuxAAC(FFMpegProgress progress, String out, String audioIn) throws InterruptedException, IOException, FFMpegException {
        return this.demux(progress, out, audioIn, this.config.getDemux2AacCommand());
    }

    public boolean demuxMp3(FFMpegProgress progress, String out, String audioIn) throws InterruptedException, IOException, FFMpegException {
        return this.demux(progress, out, audioIn, this.config.getDemux2Mp3Command());
    }

    protected void throwFFMpegException(FFMpegException e) throws FFMpegException {
        if (e != null) {
            switch (e.getError()) {
                case DISK_FULL: 
                case TOO_OLD: 
                case INCOMPATIBLE: {
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean demux(FFMpegProgress progress, String out, String audioIn, String[] demuxCommand) throws InterruptedException, IOException, FFMpegException {
        LogInterface logger = this.getLogger();
        Object object = LOCK;
        synchronized (object) {
            logger.info("Demux:Input=" + audioIn + "|Output=" + out);
            if (StringUtils.equals((String)out, (String)audioIn)) {
                throw new FFMpegException("demux failed because input file equals output file!");
            }
            long lastModifiedAudio = new File(audioIn).lastModified();
            File outFile = new File(out);
            String stdOut = null;
            try {
                stdOut = this.runCommand(progress, this.fillCommand(out, null, audioIn, null, demuxCommand));
            }
            catch (FFMpegException e) {
                this.throwFFMpegException(e);
                if (FFMpegException.ERROR.PATH_LENGTH.equals((Object)e.getError())) {
                    File tmpAudioIn = new File(outFile.getParent(), "ffmpeg_audio_in_" + UniqueAlltimeID.create());
                    File tmpOut = new File(outFile.getParent(), "ffmpeg_out" + UniqueAlltimeID.create());
                    logger.info("Try special char workaround!");
                    logger.info("Replace In:'" + audioIn + "' with '" + tmpAudioIn + "'");
                    logger.info("Replace Out'" + out + "' with '" + tmpOut + "'");
                    boolean okayFlag = false;
                    try {
                        IO.copyFile((File)new File(audioIn), (File)tmpAudioIn);
                        stdOut = this.runCommand(progress, this.fillCommand(tmpOut.getAbsolutePath(), null, tmpAudioIn.getAbsolutePath(), null, demuxCommand));
                        this.moveFile(tmpOut, outFile);
                        okayFlag = true;
                    }
                    finally {
                        this.deleteFile(tmpAudioIn);
                        if (!okayFlag) {
                            this.deleteFile(tmpOut);
                        }
                    }
                }
                throw e;
            }
            if (stdOut != null && outFile.isFile()) {
                try {
                    if (lastModifiedAudio > 0L && ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isUseOriginalLastModified()) {
                        outFile.setLastModified(lastModifiedAudio);
                    }
                }
                catch (Throwable e) {
                    logger.log(e);
                }
                return true;
            }
            return false;
        }
    }

    protected void deleteFile(File file) {
        if (!file.delete() && file.exists()) {
            file.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean mux(FFMpegProgress progress, String out, String videoIn, String audioIn, String[] muxCommand) throws InterruptedException, IOException, FFMpegException {
        LogInterface logger = this.getLogger();
        Object object = LOCK;
        synchronized (object) {
            logger.info("Mux:Video=" + videoIn + "|Audio=" + audioIn + "|Output=" + out);
            if (StringUtils.equals((String)out, (String)videoIn) || StringUtils.equals((String)out, (String)audioIn)) {
                throw new FFMpegException("demux failed because input file equals output file!");
            }
            long lastModifiedVideo = new File(videoIn).lastModified();
            long lastModifiedAudio = new File(audioIn).lastModified();
            File outFile = new File(out);
            String stdOut = null;
            try {
                stdOut = this.runCommand(progress, this.fillCommand(out, videoIn, audioIn, null, muxCommand));
            }
            catch (FFMpegException e) {
                this.throwFFMpegException(e);
                if (FFMpegException.ERROR.PATH_LENGTH.equals((Object)e.getError())) {
                    File tmpAudioIn = new File(outFile.getParent(), "ffmpeg_audio_in_" + UniqueAlltimeID.create());
                    File tmpVideoIn = new File(outFile.getParent(), "ffmpeg_video_in_" + UniqueAlltimeID.create());
                    File tmpOut = new File(outFile.getParent(), "ffmpeg_out" + UniqueAlltimeID.create());
                    logger.info("Try special char workaround!");
                    logger.info("Replace In:'" + audioIn + "' with '" + tmpAudioIn + "'");
                    logger.info("Replace In:'" + videoIn + "' with '" + tmpVideoIn + "'");
                    logger.info("Replace Out'" + out + "' with '" + tmpOut + "'");
                    boolean okayFlag = false;
                    try {
                        IO.copyFile((File)new File(videoIn), (File)tmpVideoIn);
                        IO.copyFile((File)new File(audioIn), (File)tmpAudioIn);
                        stdOut = this.runCommand(progress, this.fillCommand(tmpOut.getAbsolutePath(), tmpVideoIn.getAbsolutePath(), tmpAudioIn.getAbsolutePath(), null, muxCommand));
                        this.moveFile(tmpOut, outFile);
                        okayFlag = true;
                    }
                    finally {
                        this.deleteFile(tmpAudioIn);
                        this.deleteFile(tmpVideoIn);
                        if (!okayFlag) {
                            this.deleteFile(tmpOut);
                        }
                    }
                }
                throw e;
            }
            if (stdOut != null && outFile.isFile()) {
                try {
                    long lastModified = Math.max(lastModifiedAudio, lastModifiedVideo);
                    if (lastModified > 0L && ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isUseOriginalLastModified()) {
                        outFile.setLastModified(lastModified);
                    }
                }
                catch (Throwable e) {
                    logger.log(e);
                }
                return true;
            }
            return false;
        }
    }

    public boolean demuxM4a(FFMpegProgress progress, String out, String audioIn) throws InterruptedException, IOException, FFMpegException {
        return this.demux(progress, out, audioIn, this.config.getDemux2M4aCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> demuxAudio(FFMpegProgress progress, String out, String audioIn) throws IOException, InterruptedException, FFMpegException {
        LogInterface logger = this.getLogger();
        Object object = LOCK;
        synchronized (object) {
            long lastModifiedAudio = new File(audioIn).lastModified();
            ArrayList<File> ret = null;
            ArrayList<String> infoCommand = this.fillCommand(out, null, audioIn, null, "-i", "%audio");
            try {
                String string = this.runCommand(null, infoCommand);
            }
            catch (FFMpegException e) {
                this.throwFFMpegException(e);
                String[][] audioStreams = new Regex(e.getStdErr(), "Stream \\#0\\:(\\d+)[^\\:]*\\: Audio\\: ([\\w\\d]+)").getMatches();
                int i = 0;
                ret = new ArrayList<File>();
                for (String[] audioStream : audioStreams) {
                    File f;
                    String command;
                    String tempout;
                    block18: {
                        HashMap<String, String[]> map = new HashMap<String, String[]>();
                        map.put("%map", new String[]{"-map", "0:" + audioStream[0]});
                        audioStream[1] = this.codecToContainer(audioStream[1]);
                        tempout = out + "." + ++i + "." + audioStream[1];
                        command = null;
                        try {
                            command = this.runCommand(progress, this.fillCommand(tempout, null, audioIn, map, this.config.getDemuxGenericCommand()));
                        }
                        catch (FFMpegException e1) {
                            this.throwFFMpegException(e1);
                            if (FFMpegException.ERROR.PATH_LENGTH.equals((Object)e.getError())) {
                                File outFile = new File(tempout);
                                File tmpAudioIn = new File(outFile.getParent(), "ffmpeg_audio_in_" + UniqueAlltimeID.create());
                                File tmpOut = new File(outFile.getParent(), "ffmpeg_out" + UniqueAlltimeID.create());
                                boolean okayFlag = false;
                                try {
                                    IO.copyFile((File)new File(audioIn), (File)tmpAudioIn);
                                    command = this.runCommand(progress, this.fillCommand(tmpOut.getAbsolutePath(), null, tmpAudioIn.getAbsolutePath(), map, this.config.getDemuxGenericCommand()));
                                    this.moveFile(tmpOut, outFile);
                                    okayFlag = true;
                                    break block18;
                                }
                                finally {
                                    this.deleteFile(tmpAudioIn);
                                    if (!okayFlag) {
                                        this.deleteFile(tmpOut);
                                    }
                                }
                            }
                            throw e;
                        }
                    }
                    if (command == null) continue;
                    if (i > 1) {
                        f = new File(tempout);
                        ret.add(f);
                        try {
                            if (!((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isUseOriginalLastModified()) continue;
                            f.setLastModified(lastModifiedAudio);
                        }
                        catch (Throwable e1) {
                            logger.log(e1);
                        }
                        continue;
                    }
                    f = new File(out + "." + audioStream[1]);
                    ret.add(f);
                    new File(tempout).renameTo(f);
                    try {
                        if (!((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isUseOriginalLastModified()) continue;
                        f.setLastModified(lastModifiedAudio);
                    }
                    catch (Throwable e1) {
                        logger.log(e1);
                    }
                }
            }
            return ret;
        }
    }

    private String codecToContainer(String codec) {
        if ("aac".equals(codec)) {
            return "m4a";
        }
        return codec;
    }

    public boolean muxToWebm(FFMpegProgress progress, String out, String videoIn, String audioIn) throws InterruptedException, IOException, FFMpegException {
        return this.mux(progress, out, videoIn, audioIn, this.config.getMuxToWebmCommand());
    }

    public boolean generateOpusAudio(FFMpegProgress progress, String out, String audioIn) throws IOException, InterruptedException, FFMpegException {
        return this.demux(progress, out, audioIn, this.config.getDash2OpusAudioCommand());
    }

    public boolean generateOggAudio(FFMpegProgress progress, String out, String audioIn) throws IOException, InterruptedException, FFMpegException {
        return this.demux(progress, out, audioIn, this.config.getDash2OggAudioCommand());
    }

    public boolean generateMkvAudio(FFMpegProgress progress, String out, String audioIn) throws IOException, InterruptedException, FFMpegException {
        return this.demux(progress, out, audioIn, this.config.getDash2MkvAudioCommand());
    }
}

