/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.ffmpeg;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FFmpegMetaData {
    private final Map<KEY, String> values = new LinkedHashMap<KEY, String>();
    private final List<MetaDataEntry> entries = new ArrayList<MetaDataEntry>();

    public String getValue(KEY key) {
        return this.values.get((Object)key);
    }

    public String setYear(Calendar year) {
        if (year != null) {
            return this.setValue(KEY.DATE, String.valueOf(year.get(1)));
        }
        return this.setValue(KEY.DATE, null);
    }

    public String getYear() {
        return this.getValue(KEY.DATE);
    }

    public boolean isEmpty() {
        return this.values.size() == 0 && this.entries.size() == 0;
    }

    public String setComment(String comment) {
        return this.setValue(KEY.COMMENT, comment);
    }

    public String getComment() {
        return this.getValue(KEY.COMMENT);
    }

    public String setArtist(String artist) {
        return this.setValue(KEY.ARTIST, artist);
    }

    public String getArtist() {
        return this.getValue(KEY.ARTIST);
    }

    public String setTitle(String title) {
        return this.setValue(KEY.TITLE, title);
    }

    public String getTitle() {
        return this.getValue(KEY.TITLE);
    }

    public void addEntry(MetaDataEntry entry) {
        if (entry != null && entry.size() > 0) {
            this.entries.add(entry);
        }
    }

    protected String setValue(KEY key, String value) {
        if (value == null) {
            return this.removeKey(key);
        }
        return this.values.put(key, value);
    }

    protected String removeKey(KEY key) {
        return this.values.remove((Object)key);
    }

    private String toEscapedString(Object value) {
        if (value == null) {
            return "";
        }
        String ret = value.toString();
        ret = ret.replace("\n", "\r").replaceAll("(=|;|#|\r)", "\\\\$0").replaceAll("(\\\\[^=;#\r]{1})", "\\\\$0");
        return ret;
    }

    public String getFFmpegMetaData() {
        StringBuilder ret = new StringBuilder();
        ret.append(";FFMETADATA1\n");
        for (KEY key : KEY.values()) {
            String value = this.getValue(key);
            if (value == null) continue;
            ret.append(key.getKey());
            ret.append("=");
            ret.append(this.toEscapedString(value));
            ret.append("\n");
        }
        for (MetaDataEntry metaDataEntry : this.entries) {
            String type = metaDataEntry.getType();
            if (type == null || metaDataEntry.size() <= 0) continue;
            ret.append("[" + type + "]");
            ret.append("\n");
            for (Map.Entry entry : metaDataEntry.entrySet()) {
                ret.append((String)entry.getKey());
                ret.append("=");
                ret.append(this.toEscapedString(entry.getValue()));
                ret.append("\n");
            }
        }
        return ret.toString();
    }

    public String toString() {
        return this.getFFmpegMetaData();
    }

    public static class MetaDataEntry
    extends LinkedHashMap<String, Object> {
        private final String type;

        public MetaDataEntry(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    public static enum KEY {
        TITLE("title"),
        ARTIST("artist"),
        ALBUM("album"),
        COMMENT("comment"),
        DATE("date");

        private final String key;

        private KEY(String key) {
            this.key = key;
        }

        public final String getKey() {
            return this.key;
        }
    }
}

