/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.filter;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.controlling.linkcollector.LinkOrigin;
import jd.controlling.linkcrawler.CrawledLink;
import jd.gui.swing.jdgui.views.settings.panels.linkgrabberfilter.editdialog.OriginFilter;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;

public class CompiledOriginFilter
extends OriginFilter
implements Storable {
    private OriginFilter originFilter;
    private HashSet<LinkOrigin> originsSet;
    private boolean checkMyJDCNL = false;
    private final Pattern dummyCNL = Pattern.compile("(?i)^https?://dummycnl\\.jdownloader\\.org/.+");

    @StorableAllowPrivateAccessModifier
    private CompiledOriginFilter() {
    }

    public CompiledOriginFilter(OriginFilter originFilter) {
        this.originFilter = originFilter;
        this.originsSet = new HashSet();
        for (LinkOrigin lo : originFilter.getOrigins()) {
            this.originsSet.add(lo);
        }
        this.checkMyJDCNL = this.originsSet.contains((Object)LinkOrigin.CNL) && !this.originsSet.contains((Object)LinkOrigin.MYJD);
    }

    public boolean matches(LinkOrigin source, CrawledLink link) {
        if (LinkOrigin.MYJD.equals((Object)source) && this.checkMyJDCNL) {
            Matcher matcher = this.dummyCNL.matcher("");
            for (CrawledLink current = link.getOriginLink(); current != null; current = current.getSourceLink()) {
                String url = current.getURL();
                if (url == null || !matcher.reset(url).matches()) continue;
                source = LinkOrigin.CNL;
                break;
            }
        }
        switch (this.originFilter.getMatchType()) {
            case IS: {
                return this.originsSet.contains((Object)source);
            }
            case ISNOT: {
                return !this.originsSet.contains((Object)source);
            }
        }
        return false;
    }
}

