/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.filter;

import org.appwork.storage.Storable;
import org.appwork.utils.formatter.SizeFormatter;
import org.jdownloader.controlling.filter.Filter;
import org.jdownloader.gui.translate._GUI;

public class FilesizeFilter
extends Filter
implements Storable {
    private long from;
    private SizeMatchType matchType = SizeMatchType.BETWEEN;
    private long to;

    public FilesizeFilter() {
    }

    public String toString() {
        switch (this.getMatchType()) {
            case BETWEEN: {
                if (this.from == this.to) {
                    return _GUI.T.FilesizeFilter_toString_same(SizeFormatter.formatBytes((long)this.from));
                }
                return _GUI.T.FilesizeFilter_toString_(SizeFormatter.formatBytes((long)this.from), SizeFormatter.formatBytes((long)this.to));
            }
        }
        if (this.from == this.to) {
            return _GUI.T.FilesizeFilter_toString_same_not(SizeFormatter.formatBytes((long)this.from));
        }
        return _GUI.T.FilesizeFilter_toString_not(SizeFormatter.formatBytes((long)this.from), SizeFormatter.formatBytes((long)this.to));
    }

    public FilesizeFilter(long from, long to, boolean enabled, SizeMatchType matchType) {
        this.from = from;
        this.to = to;
        this.enabled = enabled;
        this.matchType = matchType;
    }

    public SizeMatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(SizeMatchType matchType) {
        this.matchType = matchType;
    }

    public long getFrom() {
        return this.from;
    }

    public void setFrom(long from) {
        this.from = from;
    }

    public long getTo() {
        return this.to;
    }

    public void setTo(long to) {
        this.to = to;
    }

    public static enum SizeMatchType {
        BETWEEN,
        NOT_BETWEEN;

    }
}

