/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.filter;

import java.util.ArrayList;
import org.appwork.storage.Storable;
import org.jdownloader.controlling.filter.CompiledFiletypeFilter;
import org.jdownloader.controlling.filter.Filter;
import org.jdownloader.gui.translate._GUI;

public class FiletypeFilter
extends Filter
implements Storable {
    private boolean audioFilesEnabled;
    private TypeMatchType matchType = TypeMatchType.IS;
    private boolean useRegex;
    private boolean hashEnabled;
    private boolean videoFilesEnabled;
    private boolean docFilesEnabled;
    private boolean subFilesEnabled;
    private boolean exeFilesEnabled;
    private boolean archivesEnabled;
    private boolean imagesEnabled;
    private String customs;

    public FiletypeFilter() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> cond = new ArrayList<String>();
        if (this.hashEnabled) {
            cond.add(CompiledFiletypeFilter.HashExtensions.MD5.getDesc());
        }
        if (this.videoFilesEnabled) {
            cond.add(CompiledFiletypeFilter.VideoExtensions.ASF.getDesc());
        }
        if (this.archivesEnabled) {
            cond.add(CompiledFiletypeFilter.ArchiveExtensions.ACE.getDesc());
        }
        if (this.audioFilesEnabled) {
            cond.add(CompiledFiletypeFilter.AudioExtensions.AAC.getDesc());
        }
        if (this.imagesEnabled) {
            cond.add(CompiledFiletypeFilter.ImageExtensions.BMP.getDesc());
        }
        if (this.docFilesEnabled) {
            cond.add(CompiledFiletypeFilter.DocumentExtensions.TXT.getDesc());
        }
        if (this.subFilesEnabled) {
            cond.add(CompiledFiletypeFilter.SubtitleExtensions.SRT.getDesc());
        }
        if (this.exeFilesEnabled) {
            cond.add(CompiledFiletypeFilter.ExecutableExtensions.EXE.getDesc());
        }
        if (this.customs != null) {
            cond.add(_GUI.T.FiletypeFilter_toString_custom(this.customs));
        }
        switch (this.getMatchType()) {
            case IS: {
                for (int i = 0; i < cond.size(); ++i) {
                    if (i > 0) {
                        if (i < cond.size() - 1) {
                            sb.append(_GUI.T.FilterRule_toString_comma3((String)cond.get(i)));
                            continue;
                        }
                        sb.append(" " + _GUI.T.FilterRule_toString_or((String)cond.get(i)).trim());
                        continue;
                    }
                    sb.append((String)cond.get(i));
                }
                return _GUI.T.FiletypeFilter_toString_(sb.toString());
            }
        }
        for (int i = 0; i < cond.size(); ++i) {
            if (i > 0) {
                if (i < cond.size() - 1) {
                    sb.append(_GUI.T.FilterRule_toString_comma3((String)cond.get(i)));
                    continue;
                }
                sb.append(" " + _GUI.T.FilterRule_toString_or(((String)cond.get(i)).trim()));
                continue;
            }
            sb.append((String)cond.get(i));
        }
        return _GUI.T.FiletypeFilter_toString_not(sb.toString());
    }

    public boolean isAudioFilesEnabled() {
        return this.audioFilesEnabled;
    }

    public FiletypeFilter(TypeMatchType typeMatchType, boolean enabled, boolean hashEnabled, boolean audioFilesEnabled, boolean videoFilesEnabled, boolean archivesEnabled, boolean imagesEnabled, boolean docFilesEnabled, boolean subFilesEnabled, boolean exeFilesEnabled, String customs, boolean regex) {
        this.enabled = enabled;
        this.audioFilesEnabled = audioFilesEnabled;
        this.videoFilesEnabled = videoFilesEnabled;
        this.archivesEnabled = archivesEnabled;
        this.imagesEnabled = imagesEnabled;
        this.customs = customs;
        this.useRegex = regex;
        this.hashEnabled = hashEnabled;
        this.matchType = typeMatchType;
        this.docFilesEnabled = docFilesEnabled;
        this.subFilesEnabled = subFilesEnabled;
        this.exeFilesEnabled = exeFilesEnabled;
    }

    public boolean isUseRegex() {
        return this.useRegex;
    }

    public void setUseRegex(boolean useRegex) {
        this.useRegex = useRegex;
    }

    public TypeMatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(TypeMatchType matchType) {
        this.matchType = matchType;
    }

    public void setAudioFilesEnabled(boolean audioFilesEnabled) {
        this.audioFilesEnabled = audioFilesEnabled;
    }

    public boolean isVideoFilesEnabled() {
        return this.videoFilesEnabled;
    }

    public void setVideoFilesEnabled(boolean videoFilesEnabled) {
        this.videoFilesEnabled = videoFilesEnabled;
    }

    public boolean isArchivesEnabled() {
        return this.archivesEnabled;
    }

    public void setArchivesEnabled(boolean archivesEnabled) {
        this.archivesEnabled = archivesEnabled;
    }

    public boolean isImagesEnabled() {
        return this.imagesEnabled;
    }

    public void setImagesEnabled(boolean imagesEnabled) {
        this.imagesEnabled = imagesEnabled;
    }

    public String getCustoms() {
        return this.customs;
    }

    public void setCustoms(String customs) {
        this.customs = customs;
    }

    public boolean isHashEnabled() {
        return this.hashEnabled;
    }

    public void setHashEnabled(boolean hashEnabled) {
        this.hashEnabled = hashEnabled;
    }

    public boolean isExeFilesEnabled() {
        return this.exeFilesEnabled;
    }

    public void setExeFilesEnabled(boolean exeFilesEnabled) {
        this.exeFilesEnabled = exeFilesEnabled;
    }

    public boolean isSubFilesEnabled() {
        return this.subFilesEnabled;
    }

    public void setSubFilesEnabled(boolean subFilesEnabled) {
        this.subFilesEnabled = subFilesEnabled;
    }

    public boolean isDocFilesEnabled() {
        return this.docFilesEnabled;
    }

    public void setDocFilesEnabled(boolean docFilesEnabled) {
        this.docFilesEnabled = docFilesEnabled;
    }

    public static enum TypeMatchType {
        IS,
        IS_NOT;

    }
}

