/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.filter;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import jd.controlling.TaskQueue;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.LinkCrawlerFilter;
import org.appwork.exceptions.WTFException;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.ConfigEvent;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.EventSuppressor;
import org.appwork.utils.event.predefined.changeevent.ChangeEvent;
import org.appwork.utils.event.predefined.changeevent.ChangeEventSender;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.controlling.filter.DirectHTTPView;
import org.jdownloader.controlling.filter.DupesView;
import org.jdownloader.controlling.filter.FilterRule;
import org.jdownloader.controlling.filter.LinkFilterSettings;
import org.jdownloader.controlling.filter.LinkgrabberFilterRule;
import org.jdownloader.controlling.filter.LinkgrabberFilterRuleWrapper;
import org.jdownloader.controlling.filter.OfflineView;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_LINKFILTER;

public class LinkFilterController
implements LinkCrawlerFilter {
    private static final LinkFilterController INSTANCE = new LinkFilterController(false);
    private volatile ArrayList<LinkgrabberFilterRule> filter;
    private final LinkFilterSettings config;
    private volatile List<LinkgrabberFilterRuleWrapper> acceptFilters = null;
    private volatile List<LinkgrabberFilterRuleWrapper> denyFilters = null;
    private final KeyHandler<Object> filterListHandler;
    private final ChangeEventSender eventSender = new ChangeEventSender();
    private final boolean testInstance;

    public static LinkFilterController getInstance() {
        return INSTANCE;
    }

    public static LinkFilterController createEmptyTestInstance() {
        return new LinkFilterController(true);
    }

    public List<LinkgrabberFilterRuleWrapper> getAcceptFilters() {
        return this.acceptFilters;
    }

    public LinkFilterController(boolean testInstance) {
        this.testInstance = testInstance;
        if (!this.isTestInstance()) {
            this.config = (LinkFilterSettings)JsonConfig.create(LinkFilterSettings.class);
            this.filterListHandler = this.config._getStorageHandler().getKeyHandler("FilterList");
            this.filter = this.readConfig();
            this.filterListHandler.getEventSender().addListener((EventListener)new GenericConfigEventListener<Object>(){

                public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
                    LinkFilterController.this.filter = LinkFilterController.this.readConfig();
                    LinkFilterController.this.update();
                }

                public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
                }
            });
            ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

                public void onShutdown(ShutdownRequest shutdownRequest) {
                    LinkFilterController.this.save(LinkFilterController.this.filter);
                }

                public long getMaxDuration() {
                    return 0L;
                }

                public String toString() {
                    return "save filters...";
                }
            });
            this.updateInternal();
        } else {
            this.config = null;
            this.filterListHandler = null;
            this.filter = new ArrayList();
        }
    }

    public ChangeEventSender getEventSender() {
        return this.eventSender;
    }

    private ArrayList<LinkgrabberFilterRule> readConfig() {
        ArrayList<LinkgrabberFilterRule> newList = new ArrayList<LinkgrabberFilterRule>();
        if (this.config != null) {
            ArrayList<LinkgrabberFilterRule> filter = this.config.getFilterList();
            if (filter == null) {
                filter = new ArrayList();
            }
            boolean dupesView = false;
            boolean offlineRule = false;
            boolean directHttpView = false;
            HashSet<String> dupefinder = new HashSet<String>();
            for (LinkgrabberFilterRule rule : filter) {
                LinkgrabberFilterRule r;
                LinkgrabberFilterRule clone = (LinkgrabberFilterRule)JSonStorage.restoreFromString((String)JSonStorage.serializeToJson((Object)rule), (TypeRef)new TypeRef<LinkgrabberFilterRule>(){});
                clone.setCreated(-1L);
                if (!dupefinder.add(JSonStorage.serializeToJson((Object)clone))) continue;
                if ("OfflineView".equals(rule.getId())) {
                    r = new OfflineView();
                    newList.add(r);
                    ((OfflineView)r).init();
                    r.setEnabled(rule.isEnabled());
                    offlineRule = true;
                    continue;
                }
                if ("DirectHTTPView".equals(rule.getId())) {
                    r = new DirectHTTPView();
                    newList.add(r);
                    ((DirectHTTPView)r).init();
                    r.setEnabled(rule.isEnabled());
                    directHttpView = true;
                    continue;
                }
                if ("DupesView".equals(rule.getId())) {
                    r = new DupesView();
                    newList.add(r);
                    ((DupesView)r).init();
                    r.setEnabled(rule.isEnabled());
                    dupesView = true;
                    continue;
                }
                newList.add(rule);
            }
            if (!directHttpView) {
                newList.add(new DirectHTTPView().init());
            }
            if (!offlineRule) {
                newList.add(new OfflineView().init());
            }
            if (!dupesView) {
                newList.add(new DupesView().init());
            }
        }
        return newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInternal() {
        ArrayList<LinkgrabberFilterRuleWrapper> newDenyFilters = new ArrayList<LinkgrabberFilterRuleWrapper>();
        ArrayList<LinkgrabberFilterRuleWrapper> newAcceptlFilters = new ArrayList<LinkgrabberFilterRuleWrapper>();
        LinkFilterController linkFilterController = this;
        synchronized (linkFilterController) {
            for (LinkgrabberFilterRule lgr : this.filter) {
                if (!lgr.isEnabled() || !lgr._isValid()) continue;
                try {
                    LinkgrabberFilterRuleWrapper compiled = lgr.compile();
                    lgr._setBroken(false);
                    if (lgr.isAccept()) {
                        newAcceptlFilters.add(compiled);
                        continue;
                    }
                    newDenyFilters.add(compiled);
                }
                catch (Throwable e) {
                    lgr.setEnabled(false);
                    lgr._setBroken(true);
                    LogController.CL().log(e);
                }
            }
            if (!this.isTestInstance()) {
                if (this.denyFilters != null && this.denyFilters.size() != newDenyFilters.size()) {
                    this.save(this.filter);
                } else if (this.acceptFilters != null && this.acceptFilters.size() != newAcceptlFilters.size()) {
                    this.save(this.filter);
                }
            }
        }
        this.denyFilters = newDenyFilters;
        this.acceptFilters = newAcceptlFilters;
        if (this.getEventSender().hasListener()) {
            this.getEventSender().fireEvent((DefaultEvent)new ChangeEvent((Object)this));
        }
    }

    public void update() {
        if (this.isTestInstance()) {
            this.updateInternal();
        } else {
            TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    LinkFilterController.this.updateInternal();
                    return null;
                }
            });
        }
    }

    public boolean isTestInstance() {
        return this.testInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LinkgrabberFilterRule> list() {
        LinkFilterController linkFilterController = this;
        synchronized (linkFilterController) {
            return new ArrayList<LinkgrabberFilterRule>(this.filter);
        }
    }

    public void add(LinkgrabberFilterRule linkFilter) {
        if (linkFilter != null) {
            ArrayList<LinkgrabberFilterRule> addAll = new ArrayList<LinkgrabberFilterRule>();
            addAll.add(linkFilter);
            this.addAll(addAll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<LinkgrabberFilterRule> all) {
        if (all != null && all.size() > 0) {
            LinkFilterController linkFilterController = this;
            synchronized (linkFilterController) {
                HashSet<String> dupecheck = this.createDupeSet();
                for (LinkgrabberFilterRule rule : all) {
                    if (rule.isStaticRule() || !dupecheck.add(JSonStorage.serializeToJson((Object)rule))) continue;
                    this.filter.add(rule);
                }
                this.save(this.filter);
            }
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<String> createDupeSet() {
        HashSet<String> ret = new HashSet<String>();
        LinkFilterController linkFilterController = this;
        synchronized (linkFilterController) {
            for (LinkgrabberFilterRule rule : this.filter) {
                ret.add(JSonStorage.serializeToJson((Object)rule));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void save(ArrayList<LinkgrabberFilterRule> filter) {
        if (this.config != null) {
            EventSuppressor<ConfigEvent> eventSuppressor;
            if (this.filterListHandler != null) {
                final Thread thread = Thread.currentThread();
                eventSuppressor = new EventSuppressor<ConfigEvent>(){

                    public boolean suppressEvent(ConfigEvent eventType) {
                        return Thread.currentThread() == thread;
                    }
                };
                this.filterListHandler.getEventSender().addEventSuppressor((EventSuppressor)eventSuppressor);
            } else {
                eventSuppressor = null;
            }
            try {
                this.config.setFilterList(filter);
            }
            finally {
                if (this.filterListHandler != null) {
                    this.filterListHandler.getEventSender().removeEventSuppressor((EventSuppressor)eventSuppressor);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(LinkgrabberFilterRule lf) {
        if (lf == null) {
            return;
        }
        LinkFilterController linkFilterController = this;
        synchronized (linkFilterController) {
            this.filter.remove(lf);
            this.save(this.filter);
        }
        this.update();
    }

    @Override
    public boolean dropByUrl(CrawledLink link) {
        if (link.getMatchingFilter() != null) {
            return false;
        }
        if (!this.isTestInstance() && !CFG_LINKFILTER.LINK_FILTER_ENABLED.isEnabled()) {
            return false;
        }
        for (LinkgrabberFilterRuleWrapper lgr : this.denyFilters) {
            if (!this.matches(link, lgr, false)) continue;
            link.setMatchingFilter((FilterRule)lgr.getRule());
            return true;
        }
        return false;
    }

    private boolean matches(CrawledLink link, LinkgrabberFilterRuleWrapper rule, boolean afterOnlineCheck) {
        if (!rule.checkHoster(link)) {
            return false;
        }
        if (!rule.checkPluginStatus(link)) {
            return false;
        }
        if (!this.isTestInstance()) {
            if (!rule.checkOrigin(link)) {
                return false;
            }
            if (!rule.checkConditions(link)) {
                return false;
            }
        }
        if (!rule.checkSource(link)) {
            return false;
        }
        if (!rule.checkOnlineStatus(link)) {
            return false;
        }
        if (!rule.checkFileName(link)) {
            return false;
        }
        if (!rule.checkPackageName(link)) {
            return false;
        }
        if (!rule.checkFileSize(link)) {
            return false;
        }
        return rule.checkFileType(link);
    }

    @Override
    public boolean dropByFileProperties(CrawledLink link) {
        if (link.getMatchingFilter() != null && link.getMatchingFilter() instanceof LinkgrabberFilterRule && !((LinkgrabberFilterRule)link.getMatchingFilter()).isAccept()) {
            return false;
        }
        if (!this.isTestInstance() && !CFG_LINKFILTER.LINK_FILTER_ENABLED.isEnabled()) {
            return false;
        }
        if (link.getDownloadLink() == null) {
            throw new WTFException();
        }
        for (LinkgrabberFilterRuleWrapper lgr : this.denyFilters) {
            if (!this.matches(link, lgr, true)) continue;
            link.setMatchingFilter((FilterRule)lgr.getRule());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LinkgrabberFilterRule> listFilters() {
        LinkFilterController linkFilterController = this;
        synchronized (linkFilterController) {
            ArrayList<LinkgrabberFilterRule> lst = this.filter;
            ArrayList<LinkgrabberFilterRule> ret = new ArrayList<LinkgrabberFilterRule>();
            for (LinkgrabberFilterRule l : lst) {
                if (l.isAccept()) continue;
                ret.add(l);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LinkgrabberFilterRule> listExceptions() {
        LinkFilterController linkFilterController = this;
        synchronized (linkFilterController) {
            ArrayList<LinkgrabberFilterRule> lst = this.filter;
            ArrayList<LinkgrabberFilterRule> ret = new ArrayList<LinkgrabberFilterRule>();
            for (LinkgrabberFilterRule l : lst) {
                if (!l.isAccept()) continue;
                ret.add(l);
            }
            return ret;
        }
    }
}

