/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.hosterrule;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdownloader.controlling.hosterrule.AccountReference;
import org.jdownloader.gui.translate._GUI;

public class AccountGroup {
    private final List<AccountReference> children;
    private Rules rule = Rules.RANDOM;
    private String name;

    public void setRule(Rules rule) {
        this.rule = rule == null ? Rules.RANDOM : rule;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AccountGroup(List<AccountReference> childs) {
        this.children = childs != null ? new CopyOnWriteArrayList<AccountReference>(childs) : new CopyOnWriteArrayList<AccountReference>();
    }

    public String toString() {
        return "AC: " + this.getName() + " - " + this.getChildren();
    }

    public AccountGroup(String name) {
        this(null, name);
    }

    public AccountGroup(ArrayList<AccountReference> refList, String name) {
        this(refList);
        this.setName(name);
    }

    public List<AccountReference> getChildren() {
        return this.children;
    }

    public Rules getRule() {
        return this.rule;
    }

    public static enum Rules {
        RANDOM(_GUI.T.Rules_random()),
        BALANCED("TODO JIAZ: " + _GUI.T.Rules_balanced()),
        ORDER(_GUI.T.Rules_order()),
        DISABLED(_GUI.T.Rules_disabled());

        private String translation;

        private Rules(String translation) {
            this.translation = translation;
        }

        public String translate() {
            return this.translation;
        }
    }
}

