/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.hosterrule;

import java.util.Date;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.AccountTrafficView;
import org.appwork.utils.Hash;
import org.jdownloader.DomainInfo;

public class AccountReference {
    protected boolean enabled = true;
    protected Account account;

    public AccountReference() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        return "Account: " + this.getAccount();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public AccountReference(Account acc) {
        this.setAccount(acc);
    }

    public Account getAccount() {
        return this.account;
    }

    public long getID() {
        return this.getAccount().getId().getID();
    }

    protected String getRef(long refID) {
        Account account = this.getAccount();
        String ret = Hash.getStringHash((String)(refID + account.getHoster() + account.getUser() + account.getPass()), (String)"SHA-512");
        return ret;
    }

    public void setAccount(Account acc) {
        this.account = acc;
    }

    public String getHoster() {
        return this.getAccount().getHoster();
    }

    public DomainInfo getDomainInfo() {
        return this.getAccount().getDomainInfo();
    }

    public String getUser() {
        return this.getAccount().getUser();
    }

    public Date getExpireDate() {
        AccountInfo ai = this.getAccount().getAccountInfo();
        if (ai == null) {
            return null;
        }
        if (ai.getValidUntil() <= 0L) {
            return null;
        }
        return new Date(ai.getValidUntil());
    }

    public boolean isValid() {
        Account acc = this.getAccount();
        return acc != null && acc.isValid();
    }

    public AccountTrafficView getAccountTrafficView() {
        Account acc = this.getAccount();
        if (acc != null) {
            return acc.getAccountTrafficView();
        }
        return null;
    }

    public boolean isAvailable() {
        Account acc = this.getAccount();
        return acc == null || acc.getAccountController() != null;
    }

    public boolean isTempDisabled() {
        Account acc = this.getAccount();
        return acc != null && acc.isTempDisabled();
    }

    public long getTmpDisabledTimeout() {
        Account acc = this.getAccount();
        if (acc != null) {
            return acc.getTmpDisabledTimeout();
        }
        return -1L;
    }

    public AccountInfo getAccountInfo() {
        Account acc = this.getAccount();
        if (acc != null) {
            return acc.getAccountInfo();
        }
        return null;
    }
}

