/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.hosterrule;

import java.io.File;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import jd.SecondLevelLaunch;
import jd.controlling.AccountController;
import jd.controlling.AccountControllerEvent;
import jd.controlling.AccountControllerListener;
import jd.controlling.downloadcontroller.AccountCache;
import jd.controlling.downloadcontroller.DownloadSession;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.orderpanel.dialog.EditHosterRuleDialog;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import jd.plugins.PluginForHost;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.Storage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.handler.ListHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.controlling.hosterrule.AccountGroup;
import org.jdownloader.controlling.hosterrule.AccountReference;
import org.jdownloader.controlling.hosterrule.AccountRuleStorable;
import org.jdownloader.controlling.hosterrule.AccountUsageRule;
import org.jdownloader.controlling.hosterrule.CachedAccountGroup;
import org.jdownloader.controlling.hosterrule.FreeAccountReference;
import org.jdownloader.controlling.hosterrule.HosterRuleConfig;
import org.jdownloader.controlling.hosterrule.HosterRuleControllerEvent;
import org.jdownloader.controlling.hosterrule.HosterRuleControllerEventSender;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.plugins.controller.host.PluginFinder;
import org.jdownloader.settings.advanced.AdvancedConfigManager;

public class HosterRuleController
implements AccountControllerListener {
    private static final HosterRuleController INSTANCE = new HosterRuleController();
    private final HosterRuleControllerEventSender eventSender;
    private List<AccountUsageRule> loadedRules;
    private final DelayedRunnable delayedSaver;
    private final File configFile;
    private final LogSource logger;
    private final AtomicBoolean initDone = new AtomicBoolean(false);
    private final Queue queue;

    public static HosterRuleController getInstance() {
        return INSTANCE;
    }

    private HosterRuleController() {
        this.eventSender = new HosterRuleControllerEventSender();
        this.configFile = Application.getResource((String)"cfg/accountUsageRules.json");
        if (!this.configFile.getParentFile().exists()) {
            this.configFile.getParentFile().mkdirs();
        }
        this.logger = LogController.getInstance().getLogger(HosterRuleController.class.getName());
        this.queue = new Queue("HosterRuleController"){

            public void killQueue() {
                HosterRuleController.this.logger.log(new Throwable("You cannot kill me!"));
            }
        };
        this.loadedRules = new CopyOnWriteArrayList<AccountUsageRule>();
        this.delayedSaver = new DelayedRunnable(5000L, 30000L){

            public String getID() {
                return "HosterRuleController";
            }

            public void delayedrun() {
                HosterRuleController.this.save();
            }
        };
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            public long getMaxDuration() {
                return 0L;
            }

            public void onShutdown(ShutdownRequest shutdownRequest) {
                HosterRuleController.this.save();
            }
        });
        StorageHandler<HosterRuleConfig> storageHandler = new StorageHandler<HosterRuleConfig>(HosterRuleConfig.class){
            private final String keyHandlerKey = "rules";
            {
                this.keyHandlerKey = "rules";
            }

            public Storage getPrimitiveStorage() {
                return null;
            }

            protected Object readObject(ListHandler keyHandler, AtomicBoolean readFlag) {
                if (HosterRuleController.this.isInitialized() && "rules".equals(keyHandler.getKey())) {
                    readFlag.set(true);
                    return HosterRuleController.this.toStorable();
                }
                return null;
            }

            public boolean isObjectCacheEnabled() {
                return false;
            }

            public void write() {
            }

            protected void writeObject(ListHandler keyHandler, Object object) {
                if (HosterRuleController.this.isInitialized() && "rules".equals(keyHandler.getKey())) {
                    List<AccountUsageRule> rules = HosterRuleController.this.fromStorable((List)object);
                    HosterRuleController.this.setList(rules);
                }
            }
        };
        SecondLevelLaunch.INIT_COMPLETE.executeWhenReached(new Runnable((StorageHandler)storageHandler){
            final /* synthetic */ StorageHandler val$storageHandler;
            {
                this.val$storageHandler = storageHandler;
            }

            @Override
            public void run() {
                HosterRuleConfig config = (HosterRuleConfig)JsonConfig.put((String)HosterRuleConfig.class.getName(), HosterRuleConfig.class, (StorageHandler)this.val$storageHandler);
                AdvancedConfigManager.getInstance().register(config);
            }
        });
        SecondLevelLaunch.ACCOUNTLIST_LOADED.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                HosterRuleController.this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        try {
                            HosterRuleController.this.load();
                            AccountController.getInstance().getEventSender().addListener((EventListener)HosterRuleController.this);
                        }
                        finally {
                            HosterRuleController.this.initDone.set(true);
                        }
                        return null;
                    }
                });
            }
        });
    }

    protected boolean isInitialized() {
        return SecondLevelLaunch.ACCOUNTLIST_LOADED.isReached() && this.initDone.get();
    }

    protected List<AccountUsageRule> fromStorable(List<AccountRuleStorable> list) {
        ArrayList<AccountUsageRule> rules = new ArrayList<AccountUsageRule>();
        if (list == null || list.size() == 0) {
            return rules;
        }
        ArrayList<Account> availableAccounts = AccountController.getInstance().list(null);
        PluginFinder pluginFinder = new PluginFinder((LogInterface)this.logger);
        for (AccountRuleStorable ars : list) {
            try {
                AccountUsageRule rule = ars.restore(availableAccounts);
                rule.setOwner(this);
                DownloadLink link = new DownloadLink(null, "", rule.getHoster(), "", false);
                PluginForHost plugin = pluginFinder.assignPlugin(link, false);
                this.assignPlugin(rule, plugin);
                rules.add(rule);
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        }
        try {
            this.validateRules(rules);
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        return rules;
    }

    private void load() {
        if (!this.configFile.exists()) {
            return;
        }
        try {
            ArrayList loaded = (ArrayList)JSonStorage.restoreFromString((String)IO.readFileToString((File)this.configFile), (TypeRef)new TypeRef<ArrayList<AccountRuleStorable>>(){}, null);
            if (loaded != null && loaded.size() > 0) {
                List<AccountUsageRule> rules = this.fromStorable(loaded);
                this.loadedRules.addAll(rules);
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
    }

    private boolean assignPlugin(AccountUsageRule rule, PluginForHost plugin) {
        if (plugin == null) {
            rule.setEnabled(false);
        } else {
            LazyHostPlugin lazy = plugin.getLazyP();
            boolean isUpdateRequiredPlugin = "UpdateRequired".equalsIgnoreCase(lazy.getDisplayName());
            boolean isOfflinePlugin = lazy.isOfflinePlugin();
            if (!isUpdateRequiredPlugin && !isOfflinePlugin) {
                boolean changed;
                boolean bl = changed = !StringUtils.equalsIgnoreCase((String)rule.getHoster(), (String)lazy.getHost());
                if (changed) {
                    rule.setHoster(lazy.getHost());
                    return true;
                }
            } else if (isOfflinePlugin) {
                rule.setEnabled(false);
            }
        }
        return false;
    }

    private void validateRules(final List<AccountUsageRule> loadedRules) {
        this.queue.addWait((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                if (loadedRules != null) {
                    for (AccountUsageRule hr : loadedRules) {
                        if (HosterRuleController.this.validateRule(hr)) continue;
                        HosterRuleController.this.remove(hr);
                    }
                }
                return null;
            }
        });
    }

    public void checkPluginUpdates() {
        if (!this.isInitialized()) {
            return;
        }
        this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                PluginFinder pluginFinder = new PluginFinder((LogInterface)HosterRuleController.this.logger);
                for (AccountUsageRule rule : HosterRuleController.this.loadedRules) {
                    DownloadLink link;
                    PluginForHost plugin;
                    if (!HosterRuleController.this.assignPlugin(rule, plugin = pluginFinder.assignPlugin(link = new DownloadLink(null, "", rule.getHoster(), "", false), false))) continue;
                    HosterRuleController.this.fireUpdate(rule);
                }
                return null;
            }
        });
    }

    public AccountCache getAccountCache(final String host, final DownloadSession session) {
        return (AccountCache)this.queue.addWait((QueueAction)new QueueAction<AccountCache, RuntimeException>(){

            protected AccountCache run() throws RuntimeException {
                for (AccountUsageRule hr : HosterRuleController.this.loadedRules) {
                    if (!hr.isEnabled() || !host.equalsIgnoreCase(hr.getHoster())) continue;
                    ArrayList<CachedAccountGroup> ret = new ArrayList<CachedAccountGroup>();
                    for (AccountGroup ag : hr.getAccounts()) {
                        CachedAccountGroup group = new CachedAccountGroup(ag.getRule());
                        for (AccountReference acr : ag.getChildren()) {
                            Account acc;
                            if (!acr.isAvailable()) continue;
                            if (!acr.isEnabled()) {
                                if (!FreeAccountReference.isFreeAccount(acr)) continue;
                                HosterRuleController.this.logger.info("Free Download disabled by Account Rule: " + host);
                                continue;
                            }
                            AccountCache.CachedAccount cachedAccount = FreeAccountReference.isFreeAccount(acr) ? new AccountCache.CachedAccount(host, null, session.getPlugin(host)) : ((acc = acr.getAccount()) != null ? new AccountCache.CachedAccount(host, acc, session.getPlugin(acc.getHoster())) : null);
                            if (cachedAccount == null) continue;
                            group.add(cachedAccount);
                        }
                        if (group.size() <= 0) continue;
                        ret.add(group);
                    }
                    return new AccountCache(ret){

                        @Override
                        public boolean isCustomizedCache() {
                            return true;
                        }
                    };
                }
                return null;
            }
        });
    }

    public boolean validateRule(AccountUsageRule hr) {
        List<Account> multiAccs;
        String host = hr.getHoster();
        HashSet<Account> accounts = new HashSet<Account>();
        AccountGroup defaultAccountGroup = null;
        AccountGroup defaultNoAccountGroup = null;
        AccountGroup defaultMultiHosterAccountGroup = null;
        ArrayList<AccountGroup> removeAccountGroups = new ArrayList<AccountGroup>();
        for (AccountGroup ag : hr.getAccounts()) {
            boolean onlyAccounts = ag.getChildren().size() > 0;
            boolean onlyMultiHoster = ag.getChildren().size() > 0;
            ArrayList<AccountReference> removeAccounts = new ArrayList<AccountReference>();
            for (AccountReference ar : ag.getChildren()) {
                if (FreeAccountReference.isFreeAccount(ar)) {
                    onlyMultiHoster = false;
                    onlyAccounts = false;
                    defaultNoAccountGroup = ag;
                    continue;
                }
                if (ar.getAccount() == null || !ar.isAvailable()) {
                    removeAccounts.add(ar);
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((String)ar.getAccount().getHoster(), (String)host)) {
                    onlyMultiHoster = false;
                } else {
                    onlyAccounts = false;
                }
                accounts.add(ar.getAccount());
            }
            ag.getChildren().removeAll(removeAccounts);
            if (ag.getChildren().size() == 0) {
                removeAccountGroups.add(ag);
                continue;
            }
            if (onlyAccounts) {
                defaultAccountGroup = ag;
            }
            if (!onlyMultiHoster) continue;
            defaultMultiHosterAccountGroup = ag;
        }
        hr.getAccounts().removeAll(removeAccountGroups);
        Boolean isHosterpluginAllowsUsageRuleCreation = null;
        ArrayList<Account> accs = AccountController.getInstance().list(host);
        if (accs != null && accs.size() > 0) {
            for (Account acc : accs) {
                if (accounts.add(acc)) {
                    AccountReference ar = new AccountReference(acc);
                    if (defaultAccountGroup == null) {
                        defaultAccountGroup = new AccountGroup(_GUI.T.HosterRuleController_validateRule_single_hoster_account());
                        hr.getAccounts().add(0, defaultAccountGroup);
                    }
                    defaultAccountGroup.getChildren().add(ar);
                }
                if (isHosterpluginAllowsUsageRuleCreation != null) continue;
                isHosterpluginAllowsUsageRuleCreation = this.allowUsageRule(acc.getPlugin().getLazyP());
            }
        } else {
            PluginFinder pluginFinder = new PluginFinder((LogInterface)this.logger);
            DownloadLink dummy = new DownloadLink(null, "", hr.getHoster(), "", false);
            PluginForHost plugin = pluginFinder.assignPlugin(dummy, false);
            isHosterpluginAllowsUsageRuleCreation = this.allowUsageRule(plugin.getLazyP());
        }
        if ((multiAccs = AccountController.getInstance().getMultiHostAccounts(host)) != null) {
            for (Account acc : multiAccs) {
                if (!accounts.add(acc)) continue;
                AccountReference ar = new AccountReference(acc);
                if (defaultMultiHosterAccountGroup == null) {
                    int index;
                    int n = index = defaultNoAccountGroup == null ? hr.getAccounts().size() : hr.getAccounts().indexOf(defaultNoAccountGroup);
                    if (index < 0) {
                        index = hr.getAccounts().size();
                    }
                    defaultMultiHosterAccountGroup = new AccountGroup(_GUI.T.HosterRuleController_validateRule_multi_hoster_account());
                    hr.getAccounts().add(index, defaultMultiHosterAccountGroup);
                }
                defaultMultiHosterAccountGroup.getChildren().add(ar);
            }
        }
        if (defaultNoAccountGroup == null) {
            defaultNoAccountGroup = new AccountGroup(_GUI.T.HosterRuleController_validateRule_free());
            FreeAccountReference far = new FreeAccountReference(host);
            if (accounts.size() > 0) {
                far.setEnabled(false);
            }
            defaultNoAccountGroup.getChildren().add(far);
            hr.getAccounts().add(defaultNoAccountGroup);
        }
        if (Boolean.FALSE.equals(isHosterpluginAllowsUsageRuleCreation)) {
            this.logger.info("Disable and removed rule for host " + host + " because: plugin does not allow usage rule creation");
            hr.setEnabled(false);
            return false;
        }
        return true;
    }

    public boolean allowUsageRule(LazyHostPlugin plg) {
        return !plg.isOfflinePlugin();
    }

    protected List<AccountRuleStorable> toStorable() {
        if (!this.isInitialized()) {
            return null;
        }
        ArrayList<AccountRuleStorable> saveList = new ArrayList<AccountRuleStorable>();
        for (AccountUsageRule hr : this.loadedRules) {
            saveList.add(new AccountRuleStorable(hr));
        }
        return saveList;
    }

    protected void save() {
        if (!this.isInitialized()) {
            return;
        }
        try {
            List<AccountRuleStorable> saveList = this.toStorable();
            SimpleMapper mapper = new SimpleMapper();
            mapper.setPrettyPrintEnabled(false);
            IO.secureWrite((File)this.configFile, (byte[])mapper.objectToByteArray(saveList));
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
        }
    }

    public HosterRuleControllerEventSender getEventSender() {
        return this.eventSender;
    }

    @Override
    public void onAccountControllerEvent(AccountControllerEvent event) {
        this.validateRules(this.loadedRules);
    }

    public List<AccountUsageRule> list() {
        return this.loadedRules;
    }

    public void add(final AccountUsageRule rule) {
        if (rule == null) {
            return;
        }
        this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                if (!HosterRuleController.this.validateRule(rule)) {
                    HosterRuleController.this.remove(rule);
                    return null;
                }
                rule.setOwner(HosterRuleController.this);
                HosterRuleController.this.loadedRules.add(rule);
                HosterRuleController.this.delayedSaver.delayedrun();
                HosterRuleController.this.eventSender.fireEvent((DefaultEvent)new HosterRuleControllerEvent((Object)this, HosterRuleControllerEvent.Type.ADDED, rule));
                return null;
            }
        });
    }

    public void fireUpdate(final AccountUsageRule rule) {
        if (rule == null) {
            return;
        }
        this.queue.addAsynch((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected boolean allowAsync() {
                return true;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected Void run() throws RuntimeException {
                HosterRuleController.this.delayedSaver.delayedrun();
                boolean valid = true;
                try {
                    valid = HosterRuleController.this.validateRule(rule);
                    if (!valid) {
                        HosterRuleController.this.remove(rule);
                    }
                    if (!valid) return null;
                }
                catch (Throwable throwable) {
                    if (!valid) throw throwable;
                    HosterRuleController.this.eventSender.fireEvent((DefaultEvent)new HosterRuleControllerEvent((Object)this, HosterRuleControllerEvent.Type.DATA_UPDATE, rule));
                    throw throwable;
                }
                HosterRuleController.this.eventSender.fireEvent((DefaultEvent)new HosterRuleControllerEvent((Object)this, HosterRuleControllerEvent.Type.DATA_UPDATE, rule));
                return null;
            }
        });
    }

    public boolean showEditPanel(final AccountUsageRule editing) {
        if (editing == null) {
            return false;
        }
        EditHosterRuleDialog d = new EditHosterRuleDialog(editing);
        try {
            Dialog.getInstance().showDialog((AbstractDialog)d);
            final AccountUsageRule newRule = d.getRule();
            this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    if (HosterRuleController.this.validateRule(newRule)) {
                        editing.set(newRule.isEnabled(), newRule.getAccounts());
                    }
                    return null;
                }
            });
            return true;
        }
        catch (DialogNoAnswerException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void removeRulesByDomain(final String domain) {
        this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                ArrayList<AccountUsageRule> rulesToRemove = new ArrayList<AccountUsageRule>();
                for (AccountUsageRule rule : HosterRuleController.this.loadedRules) {
                    if (!rule.getHoster().endsWith(domain)) continue;
                    rulesToRemove.add(rule);
                }
                for (AccountUsageRule rule : rulesToRemove) {
                    HosterRuleController.this.remove(rule);
                }
                return null;
            }
        });
    }

    public void remove(final AccountUsageRule rule) {
        if (rule == null) {
            return;
        }
        this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                if (HosterRuleController.this.loadedRules.remove(rule)) {
                    rule.setOwner(null);
                    HosterRuleController.this.delayedSaver.delayedrun();
                    HosterRuleController.this.eventSender.fireEvent((DefaultEvent)new HosterRuleControllerEvent((Object)this, HosterRuleControllerEvent.Type.REMOVED, rule));
                }
                return null;
            }
        });
    }

    public void setList(final List<AccountUsageRule> list) {
        this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                HosterRuleController.this.loadedRules = new CopyOnWriteArrayList(list);
                HosterRuleController.this.save();
                HosterRuleController.this.eventSender.fireEvent((DefaultEvent)new HosterRuleControllerEvent((Object)this, HosterRuleControllerEvent.Type.STRUCTURE_UPDATE, new Object[0]));
                return null;
            }
        });
    }
}

