/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.lists;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jd.controlling.downloadcontroller.DownloadController;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.utils.StringUtils;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class DupeManager {
    private volatile Map<String, Object> map = new HashMap<String, Object>();
    private final DelayedRunnable updateDelayer;
    private final boolean enabled = CFG_GENERAL.CFG.isDupeManagerEnabled();

    public DupeManager() {
        this.updateDelayer = this.enabled ? new DelayedRunnable(DownloadController.TIMINGQUEUE, 500L, 1000L){

            public String getID() {
                return DupeManager.class.getName();
            }

            public void delayedrun() {
                DupeManager.this.refreshMap();
            }
        } : null;
    }

    public void invalidate() {
        if (this.enabled) {
            this.updateDelayer.resetAndStart();
        }
    }

    public boolean hasID(String linkID) {
        if (this.enabled) {
            Map<String, Object> lMap = this.map;
            if (lMap == null) {
                return false;
            }
            Object item = lMap.get(linkID);
            if (item == null) {
                return false;
            }
            if (item instanceof DownloadLink) {
                DownloadLink link = (DownloadLink)item;
                if (StringUtils.equals((String)link.getLinkID(), (String)linkID)) {
                    FilePackage p = link.getParentNode();
                    if (p != null && p.getControlledBy() != null) {
                        return true;
                    }
                    this.invalidate();
                }
                return false;
            }
            List lst = (List)item;
            boolean invalidate = false;
            for (DownloadLink link : lst) {
                if (!StringUtils.equals((String)link.getLinkID(), (String)linkID)) continue;
                FilePackage p = link.getParentNode();
                if (p != null && p.getControlledBy() != null) {
                    return true;
                }
                invalidate = true;
            }
            if (invalidate) {
                this.invalidate();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshMap() {
        if (this.enabled) {
            HashMap<String, ArrayList<DownloadLink>> map = new HashMap<String, ArrayList<DownloadLink>>();
            for (FilePackage fpkg : DownloadController.getInstance().getPackagesCopy()) {
                boolean readL2 = fpkg.getModifyLock().readLock();
                try {
                    for (DownloadLink link : fpkg.getChildren()) {
                        String linkID = link.getLinkID();
                        ArrayList<DownloadLink> lst = (ArrayList<DownloadLink>)map.get(linkID);
                        if (lst == null) {
                            lst = new ArrayList<DownloadLink>();
                            map.put(linkID, lst);
                        }
                        lst.add(link);
                    }
                }
                finally {
                    fpkg.getModifyLock().readUnlock(readL2);
                }
            }
            HashMap<String, Object> cowMap = new HashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                if (((ArrayList)entry.getValue()).size() == 1) {
                    cowMap.put((String)entry.getKey(), ((ArrayList)entry.getValue()).get(0));
                    continue;
                }
                ((ArrayList)entry.getValue()).trimToSize();
                cowMap.put((String)entry.getKey(), entry.getValue());
            }
            this.map = cowMap.size() > 0 ? cowMap : null;
        } else {
            this.map = null;
        }
    }
}

