/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.packagizer;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.controlling.TaskQueue;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinknameCleaner;
import jd.controlling.linkcollector.PackagizerInterface;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.linkcrawler.PackageInfo;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.ParsedFilename;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.ConfigEvent;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.IO;
import org.appwork.utils.ModifyLock;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.URLEncode;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.EventSuppressor;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.FileCreationEvent;
import org.jdownloader.controlling.FileCreationListener;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.controlling.packagizer.DisableParFilesPackageRule;
import org.jdownloader.controlling.packagizer.DisableRevFilesPackageRule;
import org.jdownloader.controlling.packagizer.PackagizerControllerEvent;
import org.jdownloader.controlling.packagizer.PackagizerControllerEventSender;
import org.jdownloader.controlling.packagizer.PackagizerControllerListener;
import org.jdownloader.controlling.packagizer.PackagizerReplacer;
import org.jdownloader.controlling.packagizer.PackagizerRule;
import org.jdownloader.controlling.packagizer.PackagizerRuleWrapper;
import org.jdownloader.controlling.packagizer.PackagizerSettings;
import org.jdownloader.controlling.packagizer.SubFolderByPackageRule;
import org.jdownloader.controlling.packagizer.SubFolderByPluginRule;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.BooleanStatus;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchive;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchiveFile;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.settings.staticreferences.CFG_PACKAGIZER;

public class PackagizerController
implements PackagizerInterface,
FileCreationListener {
    public static final HashMap<String, Object> GLOBAL_PROPERTIES = new HashMap();
    private final PackagizerSettings config;
    private volatile ArrayList<PackagizerRule> list = new ArrayList();
    private final PackagizerControllerEventSender eventSender;
    private volatile List<PackagizerRuleWrapper> rules = null;
    public static final String ORGFILENAME = "orgfilename";
    public static final String ORGFILENAMEWITHOUTEXT = "orgfilenamewithoutext";
    public static final String ORGFILETYPE = "orgfiletype";
    public static final String HOSTER = "hoster";
    public static final String SOURCE = "source";
    public static final String ENV = "env";
    public static final String PACKAGENAME = "packagename";
    public static final String SIMPLEDATE = "simpledate";
    public static final String INDEXOF = "indexof";
    private static final PackagizerReplacer DATER_REPLACER = new PackagizerReplacer(){

        @Override
        public String getID() {
            return PackagizerController.SIMPLEDATE;
        }

        @Override
        public String replace(REPLACEVARIABLE replaceVariable, String modifiers, CrawledLink link, String input, PackagizerRuleWrapper lgr) {
            if (StringUtils.isNotEmpty((String)modifiers)) {
                String dateString = new SimpleDateFormat(modifiers).format(new Date());
                return Pattern.compile(PackagizerController.DATETAG + Pattern.quote(modifiers) + "/?>").matcher(input).replaceAll(Matcher.quoteReplacement(PackagizerController.preprocessReplacement(replaceVariable, dateString)));
            }
            return input;
        }
    };
    private static final PackagizerReplacer ENV_REPLACER = new PackagizerReplacer(){
        private final Map<String, String> env = System.getenv();

        @Override
        public String getID() {
            return PackagizerController.ENV;
        }

        @Override
        public String replace(REPLACEVARIABLE replaceVariable, String modifiers, CrawledLink link, String input, PackagizerRuleWrapper lgr) {
            if (StringUtils.isNotEmpty((String)modifiers)) {
                String value = this.env.get(modifiers);
                if (value == null) {
                    for (Map.Entry<String, String> entry : this.env.entrySet()) {
                        if (!StringUtils.containsIgnoreCase((String)entry.getKey(), (String)modifiers)) continue;
                        value = entry.getValue();
                        break;
                    }
                }
                return Pattern.compile(PackagizerController.ENVTAG + Pattern.quote(modifiers) + "/?>").matcher(input).replaceAll(Matcher.quoteReplacement(PackagizerController.preprocessReplacement(replaceVariable, StringUtils.valueOrEmpty((String)value))));
            }
            return input;
        }
    };
    private static final PackagizerReplacer SUBFOLDERBYPLUGIN_REPLACER = new PackagizerReplacer(){
        private final Pattern pat = Pattern.compile("<jd:subfolderbyplugin/?>");

        @Override
        public String replace(REPLACEVARIABLE replaceVariable, String modifiers, CrawledLink link, String input, PackagizerRuleWrapper lgr) {
            Object subFolderByPlugin;
            String subFolder = null;
            DownloadLink dlLink = link.getDownloadLink();
            if (dlLink != null && (subFolderByPlugin = dlLink.getProperty("subfolderbyplugin")) != null && subFolderByPlugin instanceof String) {
                String[] pathParts = ((String)subFolderByPlugin).split("/");
                StringBuilder sb = new StringBuilder();
                for (String pathPart : pathParts) {
                    if (sb.length() > 0) {
                        sb.append("/");
                    }
                    if (!StringUtils.isNotEmpty((String)(pathPart = PackagizerController.preprocessReplacement(replaceVariable, pathPart)))) continue;
                    sb.append(pathPart);
                }
                subFolder = sb.toString();
                if (CrossSystem.isAbsolutePath((String)subFolder)) {
                    subFolder = null;
                }
            }
            if (StringUtils.isEmpty(subFolder)) {
                return this.pat.matcher(input).replaceAll(Matcher.quoteReplacement(""));
            }
            return this.pat.matcher(input).replaceAll(Matcher.quoteReplacement(subFolder));
        }

        @Override
        public String getID() {
            return "subfolderbyplugin";
        }
    };
    private static final PackagizerController INSTANCE = new PackagizerController(false);
    public static final String ORGPACKAGENAME = "orgpackagename";
    private HashMap<String, PackagizerReplacer> replacers = new HashMap();
    private final boolean testInstance;
    private final KeyHandler<Object> ruleListHandler;
    public static final String PACKAGETAG = "<jd:packagename>";
    public static final String DATETAG = "<jd:simpledate:";
    public static final String INDEXOFTAG = "<jd:indexof>";
    public static final String ENVTAG = "<jd:env:";
    private static final String ORGPACKAGETAG = "<jd:orgpackagename>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getGlobalProperty(String key) {
        HashMap<String, Object> hashMap = GLOBAL_PROPERTIES;
        synchronized (hashMap) {
            return GLOBAL_PROPERTIES.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object putGlobalProperty(String key, Object value) {
        HashMap<String, Object> hashMap = GLOBAL_PROPERTIES;
        synchronized (hashMap) {
            return GLOBAL_PROPERTIES.put(key, value);
        }
    }

    public static PackagizerController getInstance() {
        return INSTANCE;
    }

    public static PackagizerController createEmptyTestInstance() {
        return new PackagizerController(true);
    }

    public boolean isTestInstance() {
        return this.testInstance;
    }

    private synchronized ArrayList<PackagizerRule> readConfig() {
        int sizeNow;
        ArrayList<PackagizerRule> list = new ArrayList<PackagizerRule>();
        if (this.config == null) {
            return list;
        }
        try {
            list = this.config.getRuleList();
        }
        catch (Throwable e) {
            LogController.CL(false).log(e);
        }
        int sizeLoaded = list != null ? list.size() : 0;
        list = this.addDefaultRules(list);
        int n = sizeNow = list != null ? list.size() : 0;
        if (sizeLoaded != sizeNow) {
            this.save(list);
        }
        return list;
    }

    private ArrayList<PackagizerRule> addDefaultRules(List<PackagizerRule> list) {
        if (list == null) {
            list = new ArrayList<PackagizerRule>();
        }
        ArrayList<PackagizerRule> ret = new ArrayList<PackagizerRule>();
        HashSet<String> dupefinder = new HashSet<String>();
        PackagizerRule disableRevFilesRule = null;
        PackagizerRule subFolderByPackgeRule = null;
        PackagizerRule subFolderByPluginRule = null;
        PackagizerRule disableParFilesRule = null;
        for (PackagizerRule rule : list) {
            PackagizerRule r;
            PackagizerRule clone = (PackagizerRule)JSonStorage.restoreFromString((String)JSonStorage.serializeToJson((Object)rule), (TypeRef)new TypeRef<PackagizerRule>(){});
            clone.setCreated(-1L);
            if (!dupefinder.add(JSonStorage.serializeToJson((Object)clone))) continue;
            if ("SubFolderByPackageRule".equals(rule.getId())) {
                if (!dupefinder.add(rule.getId())) continue;
                r = new SubFolderByPackageRule();
                ret.add(r);
                ((SubFolderByPackageRule)r).init();
                ((SubFolderByPackageRule)r).setEnabled(rule.isEnabled());
                subFolderByPackgeRule = r;
                continue;
            }
            if ("SubFolderByPluginRule".equals(rule.getId())) {
                if (!dupefinder.add(rule.getId())) continue;
                r = new SubFolderByPluginRule();
                ret.add(r);
                ((SubFolderByPluginRule)r).init();
                r.setEnabled(rule.isEnabled());
                subFolderByPluginRule = r;
                continue;
            }
            if ("DisableRevFilesPackageRule".equals(rule.getId())) {
                if (!dupefinder.add(rule.getId())) continue;
                r = new DisableRevFilesPackageRule();
                ret.add(r);
                ((DisableRevFilesPackageRule)r).init();
                r.setEnabled(rule.isEnabled());
                disableRevFilesRule = r;
                continue;
            }
            if ("DisableParFilesPackageRule".equals(rule.getId())) {
                if (!dupefinder.add(rule.getId())) continue;
                r = new DisableParFilesPackageRule();
                ret.add(r);
                ((DisableParFilesPackageRule)r).init();
                r.setEnabled(rule.isEnabled());
                disableParFilesRule = r;
                continue;
            }
            ret.add(rule);
        }
        if (disableRevFilesRule == null) {
            disableRevFilesRule = new DisableRevFilesPackageRule();
            ret.add(disableRevFilesRule);
            disableRevFilesRule.init();
        }
        if (disableParFilesRule == null) {
            disableParFilesRule = new DisableParFilesPackageRule();
            ret.add(disableParFilesRule);
            disableParFilesRule.init();
        }
        if (subFolderByPackgeRule == null) {
            subFolderByPackgeRule = new SubFolderByPackageRule();
            ret.add(subFolderByPackgeRule);
            subFolderByPackgeRule.init();
        }
        if (subFolderByPluginRule == null) {
            subFolderByPluginRule = new SubFolderByPluginRule();
            ret.add(subFolderByPluginRule);
            subFolderByPluginRule.init();
        }
        return ret;
    }

    public PackagizerController(boolean testInstance) {
        this.testInstance = testInstance;
        this.eventSender = new PackagizerControllerEventSender();
        if (!this.isTestInstance()) {
            this.config = (PackagizerSettings)JsonConfig.create(PackagizerSettings.class);
            this.ruleListHandler = this.config._getStorageHandler().getKeyHandler("RuleList");
        } else {
            this.ruleListHandler = null;
            this.config = null;
        }
        if (!this.isTestInstance()) {
            this.list = this.readConfig();
        }
        this.update();
        if (!this.isTestInstance()) {
            this.ruleListHandler.getEventSender().addListener((EventListener)new GenericConfigEventListener<Object>(){

                public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
                    if (newValue == null) {
                        PackagizerController.this.setList(null);
                    } else {
                        PackagizerController.this.setList((List)newValue);
                    }
                }

                public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
                }
            });
            ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onShutdown(ShutdownRequest shutdownRequest) {
                    PackagizerController packagizerController = PackagizerController.this;
                    synchronized (packagizerController) {
                        PackagizerController.this.save(PackagizerController.this.list);
                    }
                }

                public long getMaxDuration() {
                    return 0L;
                }

                public String toString() {
                    return "save packagizer...";
                }
            });
            FileCreationManager.getInstance().getEventSender().addListener(this);
        }
        this.addReplacer(ENV_REPLACER);
        this.addReplacer(DATER_REPLACER);
        this.addReplacer(new PackagizerReplacer(){

            @Override
            public String getID() {
                return PackagizerController.SOURCE;
            }

            @Override
            public String replace(REPLACEVARIABLE replaceVariable, String modifiers, CrawledLink link, String input, PackagizerRuleWrapper lgr) {
                int j;
                String[] sources;
                boolean inverted;
                if (StringUtils.isEmpty((String)modifiers)) {
                    return input;
                }
                int id = Integer.parseInt(modifiers);
                String output = input;
                String pattern = lgr.getSourceRule()._getPattern().pattern();
                boolean indexed = pattern.matches("^\\-?\\d+\\\\\\. .+");
                boolean bl = inverted = indexed && pattern.startsWith("-");
                if (link.getSourceUrls() != null) {
                    sources = link.getSourceUrls();
                } else {
                    sources = new String[2];
                    sources[0] = link.getURL();
                    LinkCollectingJob job = link.getSourceJob();
                    if (job != null) {
                        sources[1] = job.getCustomSourceUrl();
                    }
                }
                int i = 1;
                int n = j = inverted ? 0 : sources.length - 1;
                while (inverted ? j < sources.length : j >= 0) {
                    String s = sources[j];
                    if (s != null) {
                        String toMatch = indexed ? (inverted ? "-" : "") + i++ + ". " + s : s;
                        Regex regex = new Regex(toMatch, lgr.getSourceRule()._getPattern());
                        String[] values = null;
                        if (regex.matches()) {
                            values = regex.getRow(0);
                        } else {
                            regex = new Regex(s, lgr.getSourceRule()._getPattern());
                            if (regex.matches()) {
                                values = regex.getRow(0);
                            }
                        }
                        if (values != null && values.length > id - 1) {
                            String value = URLEncode.decodeURIComponent((String)StringUtils.valueOrEmpty((String)values[id - 1]));
                            output = Pattern.compile("<jd:source:" + Pattern.quote(String.valueOf(id)) + "\\s*/?\\s*>").matcher(output).replaceAll(Matcher.quoteReplacement(PackagizerController.preprocessReplacement(replaceVariable, value)));
                        }
                    }
                    j = inverted ? j + 1 : j - 1;
                }
                return output;
            }
        });
        this.addReplacer(new PackagizerReplacer(){
            private final Pattern pat = Pattern.compile("<jd:orgfilename\\s*/?\\s*>");

            @Override
            public String replace(REPLACEVARIABLE replaceVariable, String modifiers, CrawledLink link, String input, PackagizerRuleWrapper lgr) {
                String name = link.getName();
                if (StringUtils.isNotEmpty((String)modifiers)) {
                    Pattern pattern = lgr.getFileNameRule()._getPattern();
                    String rep = StringUtils.valueOrEmpty((String)new Regex(name, pattern).getMatch(Integer.parseInt(modifiers) - 1));
                    return Pattern.compile("<jd:orgfilename:" + Pattern.quote(modifiers) + "\\s*/?\\s*>").matcher(input).replaceAll(Matcher.quoteReplacement(PackagizerController.preprocessReplacement(replaceVariable, rep)));
                }
                return this.pat.matcher(input).replaceAll(Matcher.quoteReplacement(PackagizerController.preprocessReplacement(replaceVariable, name)));
            }

            @Override
            public String getID() {
                return PackagizerController.ORGFILENAME;
            }
        });
        this.addReplacer(new PackagizerReplacer(){
            private final Pattern pat = Pattern.compile("<jd:orgpackagename\\s*/?\\s*>");

            @Override
            public String replace(REPLACEVARIABLE replaceVariable, String modifiers, CrawledLink link, String input, PackagizerRuleWrapper lgr) {
                String packagename = null;
                if (link != null) {
                    CrawledPackage parentNode = link.getParentNode();
                    if (parentNode != null) {
                        packagename = parentNode.getName();
                    }
                    PackageInfo dpi = link.getDesiredPackageInfo();
                    if (StringUtils.isEmpty((String)packagename) && dpi != null) {
                        packagename = dpi.getName();
                    }
                }
                if (StringUtils.isEmpty(packagename)) {
                    packagename = "";
                }
                if (StringUtils.isNotEmpty((String)modifiers)) {
                    Pattern patt = lgr.getPackageNameRule()._getPattern();
                    String[] matches = new Regex(packagename, patt).getRow(0);
                    return Pattern.compile("<jd:orgpackagename:" + Pattern.quote(modifiers) + "\\s*/?\\s*>").matcher(input).replaceAll(Matcher.quoteReplacement(PackagizerController.preprocessReplacement(replaceVariable, StringUtils.valueOrEmpty((String)matches[Integer.parseInt(modifiers) - 1]))));
                }
                return this.pat.matcher(input).replaceAll(Matcher.quoteReplacement(PackagizerController.preprocessReplacement(replaceVariable, packagename)));
            }

            @Override
            public String getID() {
                return PackagizerController.ORGPACKAGENAME;
            }
        });
        this.addReplacer(SUBFOLDERBYPLUGIN_REPLACER);
        this.addReplacer(new PackagizerReplacer(){
            private final Pattern pat = Pattern.compile("<jd:orgfiletype/?>");

            @Override
            public String replace(REPLACEVARIABLE replaceVariable, String modifiers, CrawledLink link, String input, PackagizerRuleWrapper lgr) {
                String fileType = new Regex(link.getName(), "\\.([0-9a-zA-Z]+)$").getMatch(0);
                if (fileType == null) {
                    fileType = "";
                }
                if (StringUtils.isNotEmpty((String)modifiers)) {
                    return Pattern.compile("<jd:orgfiletype:" + Pattern.quote(modifiers) + "/?>").matcher(input).replaceAll(Matcher.quoteReplacement(PackagizerController.preprocessReplacement(replaceVariable, StringUtils.valueOrEmpty((String)new Regex(fileType, lgr.getFileNameRule()._getPattern()).getRow(0)[Integer.parseInt(modifiers) - 1]))));
                }
                return this.pat.matcher(input).replaceAll(Matcher.quoteReplacement(PackagizerController.preprocessReplacement(replaceVariable, fileType)));
            }

            @Override
            public String getID() {
                return PackagizerController.ORGFILETYPE;
            }
        });
        this.addReplacer(new PackagizerReplacer(){
            private final Pattern pat = Pattern.compile("<jd:orgfilenamewithoutext/?>");

            @Override
            public String replace(REPLACEVARIABLE replaceVariable, String modifiers, CrawledLink link, String input, PackagizerRuleWrapper lgr) {
                String filenameFull = link.getName();
                if (filenameFull == null) {
                    return this.pat.matcher(input).replaceAll("");
                }
                ParsedFilename pfname = ParsedFilename.parse(filenameFull);
                String filenameWithoutExt = pfname.getFilenameWithoutExtensionAdvanced();
                return this.pat.matcher(input).replaceAll(Matcher.quoteReplacement(PackagizerController.preprocessReplacement(replaceVariable, filenameWithoutExt)));
            }

            @Override
            public String getID() {
                return PackagizerController.ORGFILENAMEWITHOUTEXT;
            }
        });
        this.addReplacer(new PackagizerReplacer(){

            @Override
            public String replace(REPLACEVARIABLE replaceVariable, String modifiers, CrawledLink link, String input, PackagizerRuleWrapper lgr) {
                if (StringUtils.isEmpty((String)modifiers)) {
                    return input;
                }
                int id = Integer.parseInt(modifiers);
                if (id == -1) {
                    String host = link.getHost();
                    String value = URLEncode.decodeURIComponent((String)StringUtils.valueOrEmpty((String)host));
                    return Pattern.compile("<jd:hoster:" + Pattern.quote(String.valueOf(id)) + "/?>").matcher(input).replaceAll(Matcher.quoteReplacement(PackagizerController.preprocessReplacement(replaceVariable, value)));
                }
                String url = link.getDownloadLink() != null ? link.getDownloadLink().getContentUrlOrPatternMatcher() : link.getURL();
                Regex regex = new Regex(url, lgr.getHosterRule()._getPattern());
                if (regex.matches()) {
                    String[] values = regex.getRow(0);
                    String value = URLEncode.decodeURIComponent((String)StringUtils.valueOrEmpty((String)values[id - 1]));
                    return Pattern.compile("<jd:hoster:" + Pattern.quote(String.valueOf(id)) + "/?>").matcher(input).replaceAll(Matcher.quoteReplacement(PackagizerController.preprocessReplacement(replaceVariable, value)));
                }
                return input;
            }

            @Override
            public String getID() {
                return PackagizerController.HOSTER;
            }
        });
        this.addReplacer(new PackagizerReplacer(){

            @Override
            public String replace(REPLACEVARIABLE replaceVariable, String modifiers, CrawledLink link, String input, PackagizerRuleWrapper lgr) {
                if (StringUtils.isEmpty((String)modifiers) || link.getDownloadLink() == null) {
                    return input;
                }
                Object property = link.getDownloadLink().getProperty(modifiers);
                if (property == null || !(property instanceof String) && !(property instanceof Number)) {
                    return Pattern.compile("<jd:prop:" + Pattern.quote(modifiers) + "/?>").matcher(input).replaceAll("");
                }
                return Pattern.compile("<jd:prop:" + Pattern.quote(modifiers) + "/?>").matcher(input).replaceAll(Matcher.quoteReplacement(PackagizerController.preprocessReplacement(replaceVariable, property.toString())));
            }

            @Override
            public String getID() {
                return "prop";
            }
        });
        this.addReplacer(new PackagizerReplacer(){

            @Override
            public String replace(REPLACEVARIABLE replaceVariable, String key, CrawledLink link, String input, PackagizerRuleWrapper lgr) {
                if (StringUtils.isEmpty((String)key)) {
                    return input;
                }
                Object property = PackagizerController.getGlobalProperty(key);
                if (property == null || !(property instanceof String) && !(property instanceof Number)) {
                    return Pattern.compile("<jd:globprop:" + Pattern.quote(key) + "/?>").matcher(input).replaceAll("");
                }
                return Pattern.compile("<jd:globprop:" + Pattern.quote(key) + "/?>").matcher(input).replaceAll(Matcher.quoteReplacement(PackagizerController.preprocessReplacement(replaceVariable, property.toString())));
            }

            @Override
            public String getID() {
                return "globprop";
            }
        });
        this.addReplacer(new PackagizerReplacer(){
            private final Pattern pat = Pattern.compile("<jd:append/?>");

            @Override
            public String replace(REPLACEVARIABLE replaceVariable, String modifiers, CrawledLink link, String input, PackagizerRuleWrapper lgr) {
                CrawledPackage parentNode = link.getParentNode();
                PackageInfo dpi = link.getDesiredPackageInfo();
                String append = null;
                switch (replaceVariable) {
                    case COMMENT: {
                        append = link.getComment();
                        break;
                    }
                    case DIRECTORY: {
                        if (parentNode != null) {
                            append = parentNode.getDownloadFolder();
                        }
                        if (dpi == null || !StringUtils.isEmpty((String)append)) break;
                        append = dpi.getDestinationFolder();
                        break;
                    }
                    case FILENAME: {
                        append = link.getName();
                        break;
                    }
                    case PACKAGENAME: {
                        if (parentNode != null) {
                            append = parentNode.getName();
                        }
                        if (dpi == null || !StringUtils.isEmpty((String)append)) break;
                        append = dpi.getName();
                        break;
                    }
                    case PACKAGEKEY: {
                        if (dpi == null) break;
                        append = dpi.getPackageKey();
                        break;
                    }
                }
                if (StringUtils.isEmpty(append)) {
                    return this.pat.matcher(input).replaceAll("");
                }
                String ret = this.pat.matcher(input).replaceAll(Matcher.quoteReplacement(append));
                if (REPLACEVARIABLE.DIRECTORY.equals((Object)replaceVariable)) {
                    return CrossSystem.fixPathSeparators((String)ret);
                }
                return ret;
            }

            @Override
            public String getID() {
                return "append";
            }
        });
    }

    private static String preprocessReplacement(REPLACEVARIABLE replaceVariable, String string) {
        if (replaceVariable == null) {
            return string;
        }
        switch (replaceVariable) {
            case DIRECTORY: {
                return CrossSystem.alleviatePathParts((String)string);
            }
        }
        return string;
    }

    private void addReplacer(PackagizerReplacer replacer) {
        this.replacers.put(replacer.getID().toLowerCase(Locale.ENGLISH), replacer);
    }

    public PackagizerControllerEventSender getEventSender() {
        return this.eventSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PackagizerRule> list() {
        PackagizerController packagizerController = this;
        synchronized (packagizerController) {
            return new ArrayList<PackagizerRule>(this.list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setList(List<PackagizerRule> tableData) {
        ArrayList<PackagizerRule> newList = new ArrayList<PackagizerRule>();
        if (tableData != null) {
            newList.addAll(tableData);
        }
        PackagizerController packagizerController = this;
        synchronized (packagizerController) {
            this.list = newList;
            this.save(newList);
        }
        this.update();
    }

    public void update() {
        if (this.isTestInstance()) {
            this.updateInternal();
        } else {
            TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    PackagizerController.this.updateInternal();
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInternal() {
        ArrayList<PackagizerRuleWrapper> newRules = new ArrayList<PackagizerRuleWrapper>();
        PackagizerController packagizerController = this;
        synchronized (packagizerController) {
            for (PackagizerRule lgr : this.list) {
                if (!lgr.isEnabled() || !lgr._isValid()) continue;
                try {
                    PackagizerRuleWrapper compiled = lgr.compile();
                    lgr._setBroken(false);
                    newRules.add(compiled);
                }
                catch (Throwable e) {
                    lgr.setEnabled(false);
                    lgr._setBroken(true);
                    LogController.CL().log(e);
                }
            }
            if (!this.isTestInstance() && this.rules != null && newRules.size() != this.rules.size()) {
                this.save(this.list);
            }
        }
        this.rules = newRules;
        if (this.getEventSender().hasListener()) {
            this.getEventSender().fireEvent(new PackagizerControllerEvent(){

                @Override
                public void sendTo(PackagizerControllerListener listener) {
                    listener.onPackagizerUpdate();
                }
            });
        }
    }

    public void add(PackagizerRule linkFilter) {
        if (linkFilter != null) {
            ArrayList<PackagizerRule> addAll = new ArrayList<PackagizerRule>();
            addAll.add(linkFilter);
            this.addAll(addAll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<PackagizerRule> all) {
        if (all != null && all.size() > 0) {
            PackagizerController packagizerController = this;
            synchronized (packagizerController) {
                HashSet<String> dupecheck = this.createDupeSet();
                for (PackagizerRule rule : all) {
                    if (rule.isStaticRule() || !dupecheck.add(JSonStorage.serializeToJson((Object)rule))) continue;
                    this.list.add(rule);
                }
                this.save(this.list);
            }
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<String> createDupeSet() {
        HashSet<String> ret = new HashSet<String>();
        PackagizerController packagizerController = this;
        synchronized (packagizerController) {
            for (PackagizerRule rule : this.list) {
                ret.add(JSonStorage.serializeToJson((Object)rule));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(PackagizerRule lf) {
        if (lf != null) {
            PackagizerController packagizerController = this;
            synchronized (packagizerController) {
                this.list.remove(lf);
                this.save(this.list);
            }
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void save(ArrayList<PackagizerRule> rules) {
        if (this.config != null) {
            EventSuppressor<ConfigEvent> eventSuppressor;
            if (this.ruleListHandler != null) {
                final Thread thread = Thread.currentThread();
                eventSuppressor = new EventSuppressor<ConfigEvent>(){

                    public boolean suppressEvent(ConfigEvent eventType) {
                        return Thread.currentThread() == thread;
                    }
                };
                this.ruleListHandler.getEventSender().addEventSuppressor((EventSuppressor)eventSuppressor);
            } else {
                eventSuppressor = null;
            }
            try {
                if (rules == null) {
                    this.config.setRuleList(new ArrayList<PackagizerRule>(0));
                } else {
                    this.config.setRuleList(new ArrayList<PackagizerRule>(rules));
                }
            }
            finally {
                if (this.ruleListHandler != null) {
                    this.ruleListHandler.getEventSender().removeEventSuppressor((EventSuppressor)eventSuppressor);
                }
            }
        }
    }

    @Override
    public void runByFile(final CrawledLink link) {
        final PackagizerControllerListener.STATE firstState = !this.isTestInstance() && !CFG_PACKAGIZER.PACKAGIZER_ENABLED.isEnabled() ? PackagizerControllerListener.STATE.AFTER : PackagizerControllerListener.STATE.BEFORE;
        if (this.getEventSender().hasListener()) {
            this.getEventSender().fireEvent(new PackagizerControllerEvent(){

                @Override
                public void sendTo(PackagizerControllerListener listener) {
                    listener.onPackagizerRunAfterLinkcheck(link, firstState);
                }
            });
        }
        if (PackagizerControllerListener.STATE.BEFORE.equals((Object)firstState)) {
            this.applyPackagizerRules(link, this.rules, true);
            if (this.getEventSender().hasListener()) {
                this.getEventSender().fireEvent(new PackagizerControllerEvent(){

                    @Override
                    public void sendTo(PackagizerControllerListener listener) {
                        listener.onPackagizerRunAfterLinkcheck(link, PackagizerControllerListener.STATE.AFTER);
                    }
                });
            }
        }
    }

    @Override
    public void runByUrl(final CrawledLink link) {
        final PackagizerControllerListener.STATE firstState = !this.isTestInstance() && !CFG_PACKAGIZER.PACKAGIZER_ENABLED.isEnabled() ? PackagizerControllerListener.STATE.AFTER : PackagizerControllerListener.STATE.BEFORE;
        if (this.getEventSender().hasListener()) {
            this.getEventSender().fireEvent(new PackagizerControllerEvent(){

                @Override
                public void sendTo(PackagizerControllerListener listener) {
                    listener.onPackagizerRunBeforeLinkcheck(link, firstState);
                }
            });
        }
        if (PackagizerControllerListener.STATE.BEFORE.equals((Object)firstState)) {
            this.applyPackagizerRules(link, this.rules, false);
            if (this.getEventSender().hasListener()) {
                this.getEventSender().fireEvent(new PackagizerControllerEvent(){

                    @Override
                    public void sendTo(PackagizerControllerListener listener) {
                        listener.onPackagizerRunBeforeLinkcheck(link, PackagizerControllerListener.STATE.AFTER);
                    }
                });
            }
        }
    }

    private void applyPackagizerRules(CrawledLink link, List<PackagizerRuleWrapper> rules, boolean afterOnlineCheck) {
        if (rules != null) {
            for (PackagizerRuleWrapper lgr : rules) {
                if (!(lgr.getAlwaysFilter() != null && lgr.getAlwaysFilter().isEnabled() || lgr.checkHoster(link) && lgr.checkPluginStatus(link) && lgr.checkOrigin(link) && lgr.checkConditions(link) && lgr.checkSource(link) && lgr.checkPackageName(link) && lgr.checkFileType(link) && lgr.checkOnlineStatus(link) && lgr.checkFileName(link) && lgr.checkFileSize(link))) continue;
                this.set(link, lgr);
            }
        }
    }

    private static final int padLength(int size) {
        if (size < 10) {
            return 1;
        }
        if (size < 100) {
            return 2;
        }
        if (size < 1000) {
            return 3;
        }
        if (size < 10000) {
            return 4;
        }
        if (size < 100000) {
            return 5;
        }
        if (size < 1000000) {
            return 6;
        }
        if (size < 10000000) {
            return 7;
        }
        return 8;
    }

    private static String replaceDynamicTags(REPLACEVARIABLE type, String input, String tag, PackagizerReplacer replacer, AtomicBoolean modifyFlag) {
        int start;
        int lastStart = -1;
        while ((start = lastStart == -1 ? input.indexOf(tag) : input.indexOf(tag, lastStart)) > lastStart) {
            int end;
            if (modifyFlag != null) {
                modifyFlag.set(true);
            }
            lastStart = start;
            for (end = start + tag.length(); end < input.length() && input.charAt(end) != '>'; ++end) {
            }
            String modifier = input.substring(start + tag.length(), end);
            try {
                input = replacer.replace(type, modifier, null, input, null);
            }
            catch (Throwable e) {
                LogController.CL().log(e);
            }
        }
        return input;
    }

    public static String replaceDynamicTags(String input, String packageName, AbstractNode node) {
        return PackagizerController.replaceDynamicTags(input, packageName, node, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String replaceDynamicTags(String input, String packageName, AbstractNode node, Set<String> replaceTags) {
        String ret = input;
        if (ret != null && ret.contains("<jd:")) {
            AtomicBoolean modifyFlag = new AtomicBoolean(false);
            if (ret.contains(PACKAGETAG) && (replaceTags == null || replaceTags.contains(PACKAGETAG))) {
                modifyFlag.set(true);
                ret = StringUtils.isEmpty((String)packageName) ? ret.replace(PACKAGETAG, "") : ret.replace(PACKAGETAG, LinknameCleaner.cleanPackagename(packageName, true));
            }
            if (ret.contains(INDEXOFTAG) && (replaceTags == null || replaceTags.contains(INDEXOFTAG))) {
                modifyFlag.set(true);
                AbstractPackageNode parentNode = null;
                if (!(node instanceof AbstractPackageChildrenNode) || (parentNode = (AbstractPackageNode)((AbstractPackageChildrenNode)node).getParentNode()) == null) {
                    ret = ret.replace(INDEXOFTAG, "");
                } else {
                    int size;
                    int index;
                    ModifyLock modifyLock = parentNode.getModifyLock();
                    boolean readL = modifyLock.readLock();
                    try {
                        index = parentNode.indexOf((AbstractPackageChildrenNode)node);
                        size = parentNode.getChildren().size();
                    }
                    finally {
                        modifyLock.readUnlock(readL);
                    }
                    if (index >= 0) {
                        String replacement = String.format(Locale.US, "%0" + PackagizerController.padLength(size) + "d", index + 1);
                        ret = ret.replace(INDEXOFTAG, replacement);
                    } else {
                        ret = ret.replace(INDEXOFTAG, "");
                    }
                }
            }
            ret = PackagizerController.replaceDynamicTags(REPLACEVARIABLE.DIRECTORY, ret, ENVTAG, ENV_REPLACER, modifyFlag);
            ret = PackagizerController.replaceDynamicTags(REPLACEVARIABLE.DIRECTORY, ret, DATETAG, DATER_REPLACER, modifyFlag);
            if (modifyFlag.get()) {
                ret = CrossSystem.fixPathSeparators((String)ret);
            }
            ret = ret.trim();
        }
        return ret;
    }

    protected void set(CrawledLink link, PackagizerRuleWrapper lgr) {
        PackageInfo dpi;
        if ("SubFolderByPackageRule".equals(((PackagizerRule)lgr.getRule()).getId()) && StringUtils.contains((String)CFG_GENERAL.DEFAULT_DOWNLOAD_FOLDER.getValue(), (String)PACKAGETAG)) {
            return;
        }
        boolean packageKeyFlag = false;
        String packageKey = null;
        boolean packageNameFlag = false;
        String packageNameValue = null;
        boolean packageDirectoryFlag = false;
        String packageDirectoryValue = null;
        boolean fileNameFlag = false;
        String fileNameValue = null;
        if (((PackagizerRule)lgr.getRule()).getChunks() >= 0) {
            link.setChunks(((PackagizerRule)lgr.getRule()).getChunks());
        }
        if (!StringUtils.isEmpty((String)((PackagizerRule)lgr.getRule()).getDownloadDestination())) {
            packageDirectoryFlag = true;
            packageDirectoryValue = this.replaceVariables(REPLACEVARIABLE.DIRECTORY, ((PackagizerRule)lgr.getRule()).getDownloadDestination(), link, lgr);
        }
        if (((PackagizerRule)lgr.getRule()).getLinkEnabled() != null) {
            link.setEnabled(((PackagizerRule)lgr.getRule()).getLinkEnabled());
        }
        if (!StringUtils.isEmpty((String)((PackagizerRule)lgr.getRule()).getPackageName())) {
            packageNameFlag = true;
            packageNameValue = this.replaceVariables(REPLACEVARIABLE.PACKAGENAME, ((PackagizerRule)lgr.getRule()).getPackageName(), link, lgr);
        }
        if (((PackagizerRule)lgr.getRule()).getPriority() != null) {
            link.setPriority(((PackagizerRule)lgr.getRule()).getPriority());
        }
        if (!StringUtils.isEmpty((String)((PackagizerRule)lgr.getRule()).getFilename())) {
            fileNameFlag = true;
            fileNameValue = this.replaceVariables(REPLACEVARIABLE.FILENAME, ((PackagizerRule)lgr.getRule()).getFilename(), link, lgr);
        }
        if (!StringUtils.isEmpty((String)((PackagizerRule)lgr.getRule()).getComment())) {
            link.setComment(this.replaceVariables(REPLACEVARIABLE.COMMENT, ((PackagizerRule)lgr.getRule()).getComment(), link, lgr));
        }
        if (StringUtils.isNotEmpty((String)(packageKey = ((PackagizerRule)lgr.getRule()).getPackageKey()))) {
            packageKeyFlag = true;
            packageKey = this.replaceVariables(REPLACEVARIABLE.PACKAGEKEY, ((PackagizerRule)lgr.getRule()).getPackageKey(), link, lgr);
        }
        if (fileNameFlag && StringUtils.isNotEmpty((String)fileNameValue)) {
            link.setName(fileNameValue);
        }
        if (packageKeyFlag) {
            dpi = link.getDesiredPackageInfo() != null ? (StringUtils.isNotEmpty((String)packageKey) ? link.getDesiredPackageInfo() : null) : (StringUtils.isNotEmpty((String)packageKey) ? new PackageInfo() : null);
            if (dpi != null) {
                dpi.setPackageKey(packageKey);
                dpi.setPackagizerRuleMatched(true);
                link.setDesiredPackageInfo(dpi);
            }
        }
        if (packageNameFlag) {
            dpi = link.getDesiredPackageInfo() != null ? (StringUtils.isNotEmpty((String)packageNameValue) ? link.getDesiredPackageInfo() : null) : (StringUtils.isNotEmpty((String)packageNameValue) ? new PackageInfo() : null);
            if (dpi != null) {
                dpi.setPackagizerRuleMatched(true);
                dpi.setName(packageNameValue);
                link.setDesiredPackageInfo(dpi);
            }
        }
        if (packageDirectoryFlag) {
            dpi = link.getDesiredPackageInfo() != null ? (StringUtils.isNotEmpty((String)packageDirectoryValue) ? link.getDesiredPackageInfo() : null) : (StringUtils.isNotEmpty((String)packageDirectoryValue) ? new PackageInfo() : null);
            if (dpi != null) {
                dpi.setPackagizerRuleMatched(true);
                dpi.setDestinationFolder(packageDirectoryValue);
                link.setDesiredPackageInfo(dpi);
            }
        }
        Boolean b = null;
        b = ((PackagizerRule)lgr.getRule()).isAutoExtractionEnabled();
        if (b != null) {
            link.getArchiveInfo().setAutoExtract(b != false ? BooleanStatus.TRUE : BooleanStatus.FALSE);
        }
        if ((b = ((PackagizerRule)lgr.getRule()).isAutoAddEnabled()) != null) {
            link.setAutoConfirmEnabled(b);
        }
        if ((b = ((PackagizerRule)lgr.getRule()).isAutoStartEnabled()) != null) {
            link.setAutoStartEnabled(b);
        }
        if ((b = ((PackagizerRule)lgr.getRule()).isAutoForcedStartEnabled()) != null) {
            link.setForcedAutoStartEnabled(b);
        }
    }

    public String replaceVariables(REPLACEVARIABLE replaceVariable, String txt, CrawledLink link, PackagizerRuleWrapper lgr) {
        String[][] matches = new Regex(txt, "<jd:([^>:]+)(?::(.+?))?\\s*/?\\s*>").getMatches();
        if (matches != null) {
            for (String[] m : matches) {
                try {
                    PackagizerReplacer replacer = this.replacers.get(m[0].toLowerCase(Locale.ENGLISH));
                    if (replacer == null) continue;
                    String modifier = StringUtils.isEmpty((String)m[1]) ? null : m[1];
                    txt = replacer.replace(replaceVariable, modifier, link, txt, lgr);
                }
                catch (Throwable e) {
                    LogController.CL(false).log(e);
                }
            }
        }
        return txt;
    }

    @Override
    public void onNewFile(Object caller, File[] fileList) {
        if (CFG_PACKAGIZER.PACKAGIZER_ENABLED.isEnabled() && caller instanceof ExtractionController && caller != this && ((ExtractionController)caller).getArchive() instanceof DownloadLinkArchive) {
            CrawledPackage crawledPackage = null;
            for (ArchiveFile af : ((ExtractionController)caller).getArchive().getArchiveFiles()) {
                if (!(af instanceof DownloadLinkArchiveFile)) continue;
                for (DownloadLink link : ((DownloadLinkArchiveFile)af).getDownloadLinks()) {
                    for (File file : fileList) {
                        FilePackage filePackage;
                        if (!file.exists()) continue;
                        CrawledLink cl = new CrawledLink(link){

                            @Override
                            protected void passwordForward(DownloadLink dlLink) {
                            }
                        };
                        cl.setName(file.getName());
                        ArrayList<String> sourceURLs = new ArrayList<String>();
                        String url = link.getOriginUrl();
                        if (url != null) {
                            sourceURLs.add(url);
                        }
                        if ((url = link.getReferrerUrl()) != null) {
                            sourceURLs.add(url);
                        }
                        if ((url = link.getContainerUrl()) != null) {
                            sourceURLs.add(url);
                        }
                        if ((url = link.getContentUrl()) != null) {
                            sourceURLs.add(url);
                        }
                        if ((url = link.getCustomUrl()) != null) {
                            sourceURLs.add(url);
                        }
                        if (sourceURLs.size() > 0) {
                            cl.setSourceUrls(sourceURLs.toArray(new String[0]));
                        }
                        if ((filePackage = link.getLastValidFilePackage()) != null) {
                            crawledPackage = new CrawledPackage();
                            crawledPackage.setName(filePackage.getName());
                            crawledPackage.setDownloadFolder(filePackage.getDownloadDirectory());
                            cl.setParentNode(crawledPackage);
                        } else {
                            cl.setParentNode(crawledPackage);
                        }
                        this.runAfterExtraction(file, cl);
                    }
                }
            }
        }
    }

    private void runAfterExtraction(File file, CrawledLink dummyLink) {
        String originalFolder;
        String moveToFolder = originalFolder = file.getParent();
        String originalFileName = dummyLink.getName();
        for (PackagizerRuleWrapper lgr : this.rules) {
            String renameRule = ((PackagizerRule)lgr.getRule()).getRename();
            String moveRule = ((PackagizerRule)lgr.getRule()).getMoveto();
            if (StringUtils.isEmpty((String)renameRule) && StringUtils.isEmpty((String)moveRule) || (lgr.getAlwaysFilter() == null || !lgr.getAlwaysFilter().isEnabled()) && (!lgr.checkHoster(dummyLink) || !lgr.checkPluginStatus(dummyLink) || !lgr.checkOrigin(dummyLink) || !lgr.checkConditions(dummyLink) || !lgr.checkSource(dummyLink) || !lgr.checkPackageName(dummyLink) || !lgr.checkFileType(dummyLink) || !lgr.checkFileName(dummyLink) || !lgr.checkFileSize(dummyLink))) continue;
            if (!StringUtils.isEmpty((String)renameRule)) {
                renameRule = renameRule.replace(PACKAGETAG, ORGPACKAGETAG);
                dummyLink.setName(this.replaceVariables(REPLACEVARIABLE.FILENAME, renameRule, dummyLink, lgr));
            }
            if (StringUtils.isEmpty((String)moveRule)) continue;
            moveRule = moveRule.replace(PACKAGETAG, ORGPACKAGETAG);
            moveToFolder = this.replaceVariables(REPLACEVARIABLE.DIRECTORY, moveRule, dummyLink, lgr);
        }
        if (!originalFolder.equals(moveToFolder) || !originalFileName.equals(dummyLink.getName())) {
            File newFile = new File(moveToFolder, dummyLink.getName());
            if (!newFile.getParentFile().exists() && !FileCreationManager.getInstance().mkdir(newFile.getParentFile())) {
                LogController.CL(false).warning("Packagizer could not create " + newFile.getParentFile());
                return;
            }
            boolean successful = false;
            successful = file.renameTo(newFile);
            if (!successful) {
                LogSource log = LogController.CL(false);
                log.warning("Packagizer rename failed " + file + " to" + newFile);
                try {
                    log.warning("Packagizer try copy " + file + " to" + newFile);
                    IO.copyFile((File)file, (File)newFile);
                    FileCreationManager.getInstance().delete(file, null);
                    successful = true;
                }
                catch (Throwable e) {
                    FileCreationManager.getInstance().delete(newFile, null);
                    log.warning("Packagizer could not move/rename " + file + " to" + newFile);
                }
            }
            if (successful) {
                LogController.CL(false).info("Packagizer moved/renamed " + file + " to " + newFile);
                FileCreationManager.getInstance().getEventSender().fireEvent((DefaultEvent)new FileCreationEvent(this, FileCreationEvent.Type.NEW_FILES, newFile));
            }
        }
    }

    @Override
    public void onNewFolder(Object caller, File folder) {
    }

    public static enum REPLACEVARIABLE {
        PACKAGEKEY,
        DIRECTORY,
        COMMENT,
        FILENAME,
        PACKAGENAME;

    }
}

