/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.crosssystem.idlegetter;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.utils.Time;
import org.jdownloader.crosssystem.idlegetter.IdleGetter;

public class BasicMousePointerIdleGetter
extends IdleGetter
implements AWTEventListener,
ActionListener {
    private volatile Point lastLocation = null;
    private volatile long lastChange = System.currentTimeMillis();

    public BasicMousePointerIdleGetter() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 56L);
        Timer timer = new Timer(5000, this);
        timer.setRepeats(true);
        timer.start();
    }

    @Override
    public long getIdleTimeSinceLastUserInput() {
        return Time.systemIndependentCurrentJVMTimeMillis() - this.lastChange;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        this.lastChange = Time.systemIndependentCurrentJVMTimeMillis();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Point location = ToolTipController.getMouseLocation();
        if (this.lastLocation == null || !this.lastLocation.equals(location)) {
            this.lastChange = Time.systemIndependentCurrentJVMTimeMillis();
            this.lastLocation = location;
        }
    }
}

