/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.crosssystem.idlegetter;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinUser;
import org.jdownloader.crosssystem.idlegetter.BasicMousePointerIdleGetter;
import org.jdownloader.crosssystem.idlegetter.IdleGetter;

public class ModernWindowsJnaIdleGetter
extends IdleGetter {
    private volatile BasicMousePointerIdleGetter fallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getIdleTimeSinceLastUserInput() {
        try {
            long t = System.currentTimeMillis();
            try {
                if (this.fallback != null) {
                    long l = this.fallback.getIdleTimeSinceLastUserInput();
                    return l;
                }
                WinUser.LASTINPUTINFO lastInputInfo = new WinUser.LASTINPUTINFO();
                User32.INSTANCE.GetLastInputInfo(lastInputInfo);
                long l = Kernel32.INSTANCE.GetTickCount() - lastInputInfo.dwTime;
                return l;
            }
            finally {
                System.out.println("IDLE TIME CALL DURATIOn: " + (System.currentTimeMillis() - t));
            }
        }
        catch (Throwable e) {
            this.fallback = new BasicMousePointerIdleGetter();
            return this.fallback.getIdleTimeSinceLastUserInput();
        }
    }
}

