/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.crosssystem.macos;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.AppReOpenedListener;
import com.apple.eawt.Application;
import com.apple.eawt.FullScreenUtilities;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.OpenURIHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import java.awt.Window;
import java.io.File;
import jd.SecondLevelLaunch;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkOrigin;
import jd.gui.swing.dialog.AboutDialog;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.JDownloaderMainFrame;
import jd.gui.swing.jdgui.interfaces.View;
import jd.gui.swing.jdgui.views.settings.ConfigurationView;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.crosssystem.macos.MacOSDockAdapter;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.SmartRlyExitRequest;

public class EAWTMacOSApplicationAdapter
implements QuitHandler,
AboutHandler,
PreferencesHandler,
AppReOpenedListener,
OpenFilesHandler,
OpenURIHandler {
    public static void enableMacSpecial() throws Exception {
        Application macApplication = Application.getApplication();
        EAWTMacOSApplicationAdapter adapter = new EAWTMacOSApplicationAdapter();
        ReflectionUtils.invoke(macApplication.getClass(), (String)"setAboutHandler", (Object)macApplication, Void.TYPE, (Object[])new Object[]{adapter});
        ReflectionUtils.invoke(macApplication.getClass(), (String)"setPreferencesHandler", (Object)macApplication, Void.TYPE, (Object[])new Object[]{adapter});
        ReflectionUtils.invoke(macApplication.getClass(), (String)"setQuitHandler", (Object)macApplication, Void.TYPE, (Object[])new Object[]{adapter});
        ReflectionUtils.invoke(macApplication.getClass(), (String)"addAppEventListener", (Object)macApplication, Void.TYPE, (Object[])new Object[]{adapter});
        ReflectionUtils.invoke(macApplication.getClass(), (String)"setOpenFileHandler", (Object)macApplication, Void.TYPE, (Object[])new Object[]{adapter});
        ReflectionUtils.invoke(macApplication.getClass(), (String)"setOpenURIHandler", (Object)macApplication, Void.TYPE, (Object[])new Object[]{adapter});
        if (CrossSystem.getOS().isMinimum(CrossSystem.OperatingSystem.MAC_SIERRA)) {
            SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

                @Override
                public void run() {
                    try {
                        FullScreenUtilities.setWindowCanFullScreen((Window)JDGui.getInstance().getMainFrame(), (boolean)true);
                        LoggerFactory.getDefaultLogger().info("MacOS FullScreen Support activated");
                    }
                    catch (Throwable e) {
                        LoggerFactory.getDefaultLogger().log(e);
                    }
                }
            });
        }
        MacOSDockAdapter.init();
    }

    private EAWTMacOSApplicationAdapter() {
    }

    public void handleQuitRequestWith(AppEvent.QuitEvent e, final QuitResponse response) {
        RestartController.getInstance().exitAsynch((ShutdownRequest)new SmartRlyExitRequest(){

            public void onShutdown() {
                new Thread("QuitResponse:performQuit"){

                    @Override
                    public void run() {
                        response.performQuit();
                    }
                }.start();
            }

            public void onShutdownVeto() {
                new Thread("cancelQuit"){

                    @Override
                    public void run() {
                        response.cancelQuit();
                    }
                }.start();
            }
        });
    }

    public void handlePreferences(AppEvent.PreferencesEvent e) {
        this.appReOpened(null);
        ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setConfigViewVisible(true);
        JDGui.getInstance().setContent((View)ConfigurationView.getInstance(), true);
    }

    public void handleAbout(AppEvent.AboutEvent e) {
        AboutDialog.showNonBlocking();
    }

    public void appReOpened(AppEvent.AppReOpenedEvent e) {
        JDGui swingGui = JDGui.getInstance();
        if (swingGui == null || swingGui.getMainFrame() == null) {
            return;
        }
        JDownloaderMainFrame mainFrame = swingGui.getMainFrame();
        if (!mainFrame.isVisible()) {
            WindowManager.getInstance().setVisible((Window)mainFrame, true, WindowManager.FrameState.OS_DEFAULT);
        }
    }

    public void openFiles(AppEvent.OpenFilesEvent e) {
        this.appReOpened(null);
        LoggerFactory.getDefaultLogger().info("Handle open files from Dock " + e.getFiles().toString());
        StringBuilder sb = new StringBuilder();
        for (File file : e.getFiles()) {
            if (sb.length() > 0) {
                sb.append("\r\n");
            }
            sb.append(file.toURI().toString());
        }
        final String links = sb.toString();
        SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                LoggerFactory.getDefaultLogger().info("Distribute links: " + links);
                LinkCollector.getInstance().addCrawlerJob(new LinkCollectingJob(LinkOrigin.MAC_DOCK.getLinkOriginDetails(), links));
            }
        });
    }

    public void openURI(AppEvent.OpenURIEvent e) {
        this.appReOpened(null);
        LoggerFactory.getDefaultLogger().info("Handle open uri from Dock " + e.getURI().toString());
        final String links = e.getURI().toString();
        SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                LoggerFactory.getDefaultLogger().info("Distribute links: " + links);
                LinkCollector.getInstance().addCrawlerJob(new LinkCollectingJob(LinkOrigin.MAC_DOCK.getLinkOriginDetails(), links));
            }
        });
    }
}

