/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.crosssystem.macos;

import java.awt.Image;
import java.util.EventListener;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import jd.SecondLevelLaunch;
import jd.controlling.TaskQueue;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.event.DownloadWatchdogListener;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.EnumKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.EDTHelper;
import org.jdownloader.controlling.AggregatedNumbers;
import org.jdownloader.crosssystem.macos.MacOSApplicationAdapter;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.icon.IconBadgePainter;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public class MacOSDockAdapter {
    private static final AtomicReference<Thread> thread = new AtomicReference();
    private static final AtomicBoolean initFlag = new AtomicBoolean();

    public static void init() {
        if (initFlag.compareAndSet(false, true)) {
            SecondLevelLaunch.INIT_COMPLETE.executeWhenReached(new Runnable(){
                private DownloadWatchdogListener listener;

                @Override
                public void run() {
                    TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                        protected Void run() throws RuntimeException {
                            MacOSApplicationAdapter.setDockIcon(NewTheme.I().getImage("logo/jd_logo_128_128", 128));
                            return null;
                        }
                    });
                    EnumKeyHandler MacDOCKProgressDisplay = (EnumKeyHandler)((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class))._getStorageHandler().getKeyHandler("MacDockProgressDisplay", EnumKeyHandler.class);
                    MacDOCKProgressDisplay.getEventSender().addListener((EventListener)new GenericConfigEventListener<Enum>(){

                        public void onConfigValidatorError(KeyHandler<Enum> keyHandler, Enum invalidValue, ValidationException validateException) {
                        }

                        public void onConfigValueModified(KeyHandler<Enum> keyHandler, Enum newValue) {
                            if (GraphicalUserInterfaceSettings.MacDockProgressDisplay.TOTAL_PROGRESS.equals(newValue)) {
                                MacOSDockAdapter.startDockUpdater();
                            } else {
                                MacOSDockAdapter.stopDockUpdater();
                            }
                        }
                    });
                    this.listener = new DownloadWatchdogListener(){

                        @Override
                        public void onDownloadWatchdogStateIsStopping() {
                            MacOSDockAdapter.stopDockUpdater();
                        }

                        @Override
                        public void onDownloadWatchdogStateIsStopped() {
                            MacOSDockAdapter.stopDockUpdater();
                        }

                        @Override
                        public void onDownloadWatchdogStateIsRunning() {
                            MacOSDockAdapter.startDockUpdater();
                        }

                        @Override
                        public void onDownloadWatchdogStateIsPause() {
                            MacOSDockAdapter.startDockUpdater();
                        }

                        @Override
                        public void onDownloadWatchdogStateIsIdle() {
                        }

                        @Override
                        public void onDownloadWatchdogDataUpdate() {
                        }

                        @Override
                        public void onDownloadControllerStart(SingleDownloadController downloadController, DownloadLinkCandidate candidate) {
                        }

                        @Override
                        public void onDownloadControllerStopped(SingleDownloadController downloadController, DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
                        }

                        @Override
                        public void onDownloadWatchDogPropertyChange(DownloadWatchDogProperty propertyChange) {
                        }
                    };
                    DownloadWatchDog.getInstance().getEventSender().addListener(this.listener);
                    DownloadWatchDog.getInstance().notifyCurrentState(this.listener);
                }
            });
        }
    }

    private static void startDockUpdater() {
        if (((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getMacDockProgressDisplay() != GraphicalUserInterfaceSettings.MacDockProgressDisplay.TOTAL_PROGRESS) {
            return;
        }
        Thread thread = MacOSDockAdapter.thread.getAndSet(null);
        if (thread != null && thread.isAlive()) {
            return;
        }
        thread = new Thread("MacDOCKUpdater"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                int lastPercent = -1;
                HashMap<Integer, Image> imageCache = new HashMap<Integer, Image>();
                try {
                    while (Thread.currentThread() == thread.get()) {
                        try {
                            int finalpercent;
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                            AggregatedNumbers aggn = new AggregatedNumbers(DownloadsTable.getInstance().getSelectionInfo(false, false));
                            int percent = 0;
                            if (aggn.getTotalBytes() > 0L) {
                                percent = (int)(aggn.getLoadedBytes() * 100L / aggn.getTotalBytes());
                            }
                            if (lastPercent == (finalpercent = percent)) continue;
                            lastPercent = finalpercent;
                            Image image = (Image)imageCache.get(finalpercent);
                            if (image == null) {
                                image = (Image)new EDTHelper<Image>(){

                                    public Image edtRun() {
                                        return new IconBadgePainter(NewTheme.I().getImage("logo/jd_logo_128_128", 128)).getImage(finalpercent, finalpercent + "");
                                    }
                                }.getReturnValue();
                                imageCache.put(finalpercent, image);
                            }
                            if (image == null) continue;
                            final Image finalImage = image;
                            TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                                protected Void run() throws RuntimeException {
                                    MacOSApplicationAdapter.setDockIcon(finalImage);
                                    return null;
                                }
                            });
                        }
                        catch (Throwable e) {
                            LoggerFactory.getDefaultLogger().log(e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                        protected Void run() throws RuntimeException {
                            MacOSApplicationAdapter.setDockIcon(NewTheme.I().getImage("logo/jd_logo_128_128", 128));
                            return null;
                        }
                    });
                    thread.compareAndSet(Thread.currentThread(), null);
                    throw throwable;
                }
                TaskQueue.getQueue().add((QueueAction)new /* invalid duplicate definition of identical inner class */);
                thread.compareAndSet(Thread.currentThread(), null);
            }
        };
        thread.setDaemon(true);
        MacOSDockAdapter.stopDockUpdater(thread);
        thread.start();
    }

    private static void stopDockUpdater() {
        MacOSDockAdapter.stopDockUpdater(null);
    }

    private static void stopDockUpdater(Thread newThread) {
        Thread thread = MacOSDockAdapter.thread.getAndSet(newThread);
        if (thread != null && thread.isDaemon()) {
            thread.interrupt();
        }
    }
}

