/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.appwork.swing.MigPanel;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.jdownloader.dialogs.NewPasswordDialogInterface;
import org.jdownloader.translate._JDT;

public class NewPasswordDialog
extends AbstractDialog<String[]>
implements NewPasswordDialogInterface,
CaretListener,
MouseListener {
    private JPasswordField password;
    private JPasswordField passVerify;
    private Color titleColor;
    private String message;

    public NewPasswordDialog(int flag, String title, String message, Icon icon, String ok, String cancel) {
        super(flag, title, icon, ok, cancel);
        this.message = message;
    }

    protected int getPreferredWidth() {
        return 500;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private JLabel addSettingName(String name) {
        JLabel lbl = new JLabel(name);
        lbl.setForeground(this.titleColor);
        return lbl;
    }

    protected void modifyTextPane(JTextPane textField) {
    }

    protected void addMessageComponent(MigPanel p) {
        JTextPane textField = new JTextPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return !BinaryLogic.containsAll((int)NewPasswordDialog.this.flagMask, (int[])new int[]{64});
            }
        };
        this.modifyTextPane(textField);
        Font font = textField.getFont();
        if (BinaryLogic.containsAll((int)this.flagMask, (int[])new int[]{128})) {
            textField.setContentType("text/html");
            textField.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        CrossSystem.openURL((URL)e.getURL());
                    }
                }
            });
        } else {
            textField.setContentType("text/plain");
        }
        textField.setFont(font);
        textField.setText(this.getMessage());
        textField.setEditable(false);
        textField.setBackground(null);
        textField.setOpaque(false);
        textField.setFocusable(false);
        textField.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        textField.setCaretPosition(0);
        if (BinaryLogic.containsAll((int)this.flagMask, (int[])new int[]{64})) {
            p.add((Component)new JScrollPane(textField), (Object)"pushx,growx,spanx");
        } else {
            p.add((Component)textField, (Object)"spanx");
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.cancel();
        String pw = new String(this.password.getPassword());
        String pwv = new String(this.passVerify.getPassword());
        if (StringUtils.isEmpty((String)pw)) {
            this.okButton.setEnabled(false);
        } else if (!StringUtils.equals((String)pw, (String)pwv)) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    protected String[] createReturnValue() {
        if ((this.getReturnmask() & 0x22) == 0) {
            return null;
        }
        return new String[]{new String(this.password.getPassword()), new String(this.passVerify.getPassword())};
    }

    public JComponent layoutDialogContent() {
        MigPanel contentpane = new MigPanel("ins 5, wrap 2", "[]10[grow,fill]", "[][]");
        this.titleColor = Color.DARK_GRAY;
        this.password = new JPasswordField(10);
        this.passVerify = new JPasswordField(10);
        this.password.addCaretListener(this);
        this.passVerify.addCaretListener(this);
        this.password.addMouseListener(this);
        this.passVerify.addMouseListener(this);
        this.addMessageComponent(contentpane);
        contentpane.add((Component)this.addSettingName(_JDT.T.newpassworddialog_password()));
        contentpane.add((Component)this.password, (Object)"sizegroup g1");
        contentpane.add((Component)this.addSettingName(_JDT.T.newpassworddialog_password_verify()));
        contentpane.add((Component)this.passVerify, (Object)"sizegroup g1");
        this.caretUpdate(null);
        return contentpane;
    }

    protected void packed() {
        super.packed();
        this.setResizable(false);
    }

    protected void initFocus(JComponent focus) {
        this.password.selectAll();
        this.password.requestFocusInWindow();
    }

    @Override
    public String getPassword() {
        if ((this.getReturnmask() & 0x22) == 0) {
            return null;
        }
        return (String)new EDTHelper<String>(){

            public String edtRun() {
                return new String(NewPasswordDialog.this.password.getPassword());
            }
        }.getReturnValue();
    }

    @Override
    public String getPasswordVerification() {
        if ((this.getReturnmask() & 0x22) == 0) {
            return null;
        }
        return (String)new EDTHelper<String>(){

            public String edtRun() {
                return new String(NewPasswordDialog.this.passVerify.getPassword());
            }
        }.getReturnValue();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.cancel();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

