/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.donate;

import java.io.File;
import org.appwork.utils.Application;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class DonationManager {
    private static final DonationManager INSTANCE = new DonationManager();
    private final long autoVisibleTimeout = 7776000000L;
    private final long donationThankYou = 7776000000L;

    private DonationManager() {
        File donation = Application.getResource((String)"cfg/donation_0.json");
        switch (CFG_GUI.CFG.getDonateButtonState()) {
            case AUTO_VISIBLE: {
                if (!donation.isFile()) break;
                long waitUntil = donation.lastModified() + 7776000000L;
                if (System.currentTimeMillis() >= waitUntil) break;
                CFG_GUI.CFG.setDonateButtonLatestAutoChange(donation.lastModified());
                CFG_GUI.CFG.setDonateButtonState(GraphicalUserInterfaceSettings.DonateButtonState.AUTO_HIDDEN);
                break;
            }
            case CUSTOM_HIDDEN: 
            case AUTO_HIDDEN: {
                long lastChange = System.currentTimeMillis() - CFG_GUI.CFG.getDonateButtonLatestAutoChange();
                if (lastChange <= 7776000000L) break;
                CFG_GUI.CFG.setDonateButtonLatestAutoChange(System.currentTimeMillis());
                CFG_GUI.CFG.setDonateButtonState(GraphicalUserInterfaceSettings.DonateButtonState.AUTO_VISIBLE);
                break;
            }
        }
    }

    public static DonationManager getInstance() {
        return INSTANCE;
    }

    public boolean isButtonVisible() {
        switch (CFG_GUI.CFG.getDonateButtonState()) {
            case AUTO_VISIBLE: 
            case CUSTOM_VISIBLE: {
                return true;
            }
        }
        return false;
    }
}

