/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.downloader.hls;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jd.http.Browser;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;

public class M3U8Playlist {
    private static final boolean X_BYTERANGE_SUPPORT = false;
    protected final ArrayList<M3U8Segment> segments = new ArrayList();
    private final HashMap<String, List<M3U8Segment>> map = new HashMap();
    protected int mediaSequenceOffset = 0;
    protected long averageBandwidth = -1L;
    protected M3U8Segment extXMap = null;
    protected long targetDuration = -1L;

    public String toString() {
        return "M3U8:Encrypted:" + (Object)((Object)this.getEncryptionMethod()) + "|Segments:" + this.size() + "|Duration:" + this.getEstimatedDuration() + "ms|Estimated Size:" + this.getEstimatedSize();
    }

    public static List<M3U8Playlist> loadM3U8(String m3u8, Browser br) throws IOException {
        return M3U8Playlist.loadM3U8(m3u8, br, false);
    }

    public static List<M3U8Playlist> loadM3U8(String m3u8, Browser br, boolean X_BYTERANGE_SUPPORT) throws IOException {
        br.getPage(m3u8);
        br.followRedirect();
        if (br.getHttpConnection().getResponseCode() != 200 && br.getHttpConnection().getResponseCode() != 206) {
            throw new IOException("ResponseCode must be 200 or 206!");
        }
        return M3U8Playlist.parseM3U8(br, X_BYTERANGE_SUPPORT);
    }

    public static List<M3U8Playlist> parseM3U8(Browser br) throws IOException {
        return M3U8Playlist.parseM3U8(br, false);
    }

    public static List<M3U8Playlist> parseM3U8(Browser br, Boolean X_BYTERANGE_SUPPORT) throws IOException {
        ArrayList<M3U8Playlist> ret = new ArrayList<M3U8Playlist>();
        M3U8Playlist current = new M3U8Playlist();
        long lastSegmentDuration = -1L;
        long[] byteRange = null;
        int sequenceOffset = 0;
        String extXMapURL = null;
        M3U8Segment.X_KEY_METHOD xKeyMethod = M3U8Segment.X_KEY_METHOD.NONE;
        String xKeyIV = null;
        String xKeyURI = null;
        for (String line : Regex.getLines((String)br.toString())) {
            String targetDuration;
            if (StringUtils.isEmpty((String)line)) continue;
            if (line.startsWith("#EXT-X-DISCONTINUITY")) {
                if (current != null && current.size() > 0) {
                    ret.add(current);
                }
                M3U8Playlist before = current;
                current = new M3U8Playlist();
                current.setMediaSequenceOffset(sequenceOffset);
                current.setExtTargetDuration(before.getExtTargetDuration());
                lastSegmentDuration = -1L;
            }
            if (StringUtils.startsWithCaseInsensitive((String)line, (String)"concat") || StringUtils.contains((String)line, (String)"file:")) continue;
            if (line.matches("^https?://.+") || !line.trim().startsWith("#") || line.startsWith("#EXT-X-MAP:URI")) {
                String segmentURL;
                if (line.matches("^https?://.+") || !line.trim().startsWith("#")) {
                    segmentURL = br.getURL(line).toString();
                } else {
                    String URI2 = new Regex(line, "URI\\s*=\\s*\"(.*?)\"").getMatch(0);
                    if (URI2 == null) {
                        throw new IOException("Unsupported EXT-X-MAP:URI:" + line);
                    }
                    extXMapURL = segmentURL = br.getURL(URI2).toString();
                }
                M3U8Segment existing = current.getSegment(segmentURL, null);
                if (existing == null || existing.isByteRange()) {
                    M3U8Segment segment;
                    M3U8Segment lastSegment = current.getLastSegment();
                    int index = current.addSegment(segmentURL, lastSegmentDuration);
                    if (!M3U8Segment.X_KEY_METHOD.NONE.equals((Object)xKeyMethod)) {
                        segment = current.getSegment(index);
                        segment.setxKeyMethod(xKeyMethod);
                        segment.setxKeyIV(xKeyIV);
                        segment.setxKeyURI(xKeyURI);
                    }
                    if (byteRange != null) {
                        segment = current.getSegment(index);
                        if (X_BYTERANGE_SUPPORT.booleanValue()) {
                            if (lastSegment == null || !lastSegment.getUrl().endsWith(segmentURL)) {
                                byteRange[0] = byteRange[0] + byteRange[1];
                                byteRange[1] = 0L;
                            }
                            segment.setByteRange(byteRange);
                        }
                        segment.setSize((long)byteRange[0]);
                    }
                } else if (existing != null && byteRange != null) {
                    existing.setDuration(existing.getDuration() + lastSegmentDuration);
                    if (existing.getSize() > 0L) {
                        existing.setSize(existing.getSize() + byteRange[0]);
                    }
                }
                lastSegmentDuration = -1L;
                byteRange = null;
                continue;
            }
            if (line.startsWith("#EXT-X-BYTERANGE")) {
                long byteRangeLength = Long.parseLong(new Regex(line, "#EXT-X-BYTERANGE:(\\d+)").getMatch(0));
                String byteRangeStart = new Regex(line, "#EXT-X-BYTERANGE:\\d+@(\\d+)").getMatch(0);
                if (byteRangeStart != null) {
                    byteRange = new long[]{byteRangeLength, Long.parseLong(byteRangeStart)};
                    continue;
                }
                M3U8Segment lastSegment = current.getLastSegment();
                if (lastSegment != null && lastSegment.isByteRange()) {
                    byteRange = new long[]{byteRangeLength, lastSegment.getByteRange()[0] + lastSegment.getByteRange()[1]};
                    continue;
                }
                byteRange = new long[]{byteRangeLength, -1L};
                continue;
            }
            if (line.startsWith("#EXT-X-MEDIA-SEQUENCE")) {
                sequenceOffset = Integer.parseInt(new Regex(line, "#EXT-X-MEDIA-SEQUENCE:(\\d+)").getMatch(0));
                current.setMediaSequenceOffset(sequenceOffset);
                continue;
            }
            if (line.startsWith("#EXTINF:")) {
                lastSegmentDuration = M3U8Segment.fromExtInfDuration(line);
                ++sequenceOffset;
                continue;
            }
            if (line.startsWith("#EXT-X-KEY")) {
                xKeyMethod = M3U8Segment.X_KEY_METHOD.get(new Regex(line, "METHOD=(NONE|AES-128|SAMPLE-AES)").getMatch(0));
                xKeyIV = new Regex(line, "IV=0x([a-fA-F0-9]{32})").getMatch(0);
                xKeyURI = new Regex(line, "URI=\"(.*?)\"").getMatch(0);
                if (xKeyURI == null) continue;
                xKeyURI = br.getURL(xKeyURI).toString();
                continue;
            }
            if (!line.startsWith("#EXT-X-TARGETDURATION") || (targetDuration = new Regex(line, "#EXT-X-TARGETDURATION:(\\d+)").getMatch(0)) == null) continue;
            current.setExtTargetDuration(Long.parseLong(targetDuration));
        }
        if (current != null && current.size() > 0) {
            if (extXMapURL != null) {
                // empty if block
            }
            ret.add(current);
        }
        return ret;
    }

    public int addSegment(String segmentURL, long segmentDuration) {
        M3U8Segment segment = new M3U8Segment(segmentURL, segmentDuration);
        return this.addSegment(segment);
    }

    public M3U8Segment getExtXMap() {
        return this.extXMap;
    }

    public void setAverageBandwidth(long averageBandwidth) {
        this.averageBandwidth = averageBandwidth;
    }

    public long getAverageBandwidth() {
        return this.averageBandwidth;
    }

    public int getMediaSequenceOffset() {
        return this.mediaSequenceOffset;
    }

    protected void setMediaSequenceOffset(int mediaSequenceOffset) {
        this.mediaSequenceOffset = mediaSequenceOffset;
    }

    public long getTargetDuration() {
        long ret = -1L;
        for (M3U8Segment segment : this.segments) {
            ret = Math.max(segment.getDuration(), ret);
        }
        return Math.max(ret, this.getExtTargetDuration());
    }

    public long getExtTargetDuration() {
        return this.targetDuration;
    }

    public void setExtTargetDuration(long targetDuration) {
        this.targetDuration = targetDuration <= 0L ? -1L : targetDuration;
    }

    public int indexOf(M3U8Segment segment) {
        return this.segments.indexOf(segment);
    }

    public M3U8Segment.X_KEY_METHOD getEncryptionMethod() {
        for (M3U8Segment segment : this.segments) {
            if (M3U8Segment.X_KEY_METHOD.NONE.equals((Object)segment.getxKeyMethod())) continue;
            return segment.getxKeyMethod();
        }
        return M3U8Segment.X_KEY_METHOD.NONE;
    }

    public long getSegmentLoaded(int index) {
        if (index >= 0 && index < this.segments.size()) {
            return this.segments.get(index).getLoaded();
        }
        return -1L;
    }

    public void setSegmentLoaded(int index, long loaded) {
        if (index >= 0 && index < this.segments.size()) {
            this.segments.get(index).setLoaded(loaded);
        }
    }

    public void clearLoadedSegments() {
        for (M3U8Segment segment : this.segments) {
            segment.setLoaded(-1L);
        }
    }

    public M3U8Segment getSegment(int index) {
        if (index >= 0 && index < this.segments.size()) {
            return this.segments.get(index);
        }
        return null;
    }

    public boolean containsSegmentURL(String segmentURL) {
        return this.map.containsKey(segmentURL);
    }

    public int size() {
        return this.segments.size();
    }

    private void addSegmentToMap(M3U8Segment segment) {
        if (segment != null) {
            String url = segment.getUrl();
            List<M3U8Segment> list = this.map.get(url);
            if (list == null) {
                list = new ArrayList<M3U8Segment>();
                this.map.put(url, list);
            }
            if (!list.contains(segment)) {
                list.add(segment);
            }
        }
    }

    private void removeSegmentFromMap(M3U8Segment segment) {
        String url;
        List<M3U8Segment> list;
        if (segment != null && (list = this.map.get(url = segment.getUrl())) != null && list.remove(segment) && list.size() == 0) {
            this.map.remove(url);
        }
    }

    public int addSegment(M3U8Segment segment) {
        if (segment != null) {
            int index = this.segments.indexOf(segment);
            if (index == -1) {
                index = this.segments.size();
                this.segments.add(segment);
                this.addSegmentToMap(segment);
            }
            return index;
        }
        return -1;
    }

    public M3U8Segment setSegment(int index, M3U8Segment segment) {
        if (segment != null && index >= 0 && index < this.segments.size()) {
            M3U8Segment ret = this.segments.set(index, segment);
            this.removeSegmentFromMap(ret);
            this.addSegment(segment);
            return ret;
        }
        return null;
    }

    public long getEstimatedDuration() {
        return M3U8Playlist.getEstimatedDuration(Arrays.asList(this));
    }

    public static long getEstimatedDuration(List<M3U8Playlist> list) {
        long duration = 0L;
        for (M3U8Playlist playList : list) {
            for (M3U8Segment segment : playList.segments) {
                duration += Math.max(0L, segment.getDuration());
            }
        }
        return duration;
    }

    public static long getEstimatedSize(List<M3U8Playlist> list) {
        long size = -1L;
        long duration = 0L;
        long unknownSizeDuration = 0L;
        if (list != null) {
            for (M3U8Playlist playList : list) {
                long averageBandwidth = playList.getAverageBandwidth();
                for (M3U8Segment segment : playList.segments) {
                    if (segment.getSize() != -1L) {
                        size += segment.getSize();
                        duration += segment.getDuration();
                        continue;
                    }
                    if (averageBandwidth > 0L && segment.getDuration() > 0L) {
                        size += averageBandwidth / 8L * (segment.getDuration() / 1000L);
                        duration += segment.getDuration();
                        continue;
                    }
                    unknownSizeDuration += segment.getDuration();
                }
            }
        }
        if (unknownSizeDuration == 0L && duration > 0L) {
            return size + 1L;
        }
        if (size > 0L && duration > 0L) {
            double averagePerSecond = (double)Math.max(1L, size) / ((double)duration / 1000.0);
            return size + (long)(averagePerSecond * ((double)unknownSizeDuration / 1000.0));
        }
        return -1L;
    }

    public long getEstimatedSize() {
        return M3U8Playlist.getEstimatedSize(Arrays.asList(this));
    }

    protected M3U8Segment getLastSegment() {
        if (this.segments.size() > 0) {
            return this.segments.get(this.segments.size() - 1);
        }
        return null;
    }

    protected M3U8Segment getSegment(String url, long[] byteRange) {
        List<M3U8Segment> list = this.map.get(url);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public M3U8Segment removeSegment(int index) {
        if (index >= 0 && index < this.segments.size()) {
            M3U8Segment ret = this.segments.remove(index);
            this.removeSegmentFromMap(ret);
            return ret;
        }
        return null;
    }

    public boolean addSegment(int index, M3U8Segment segment) {
        if (segment != null && index >= 0) {
            this.segments.add(index, segment);
            this.addSegmentToMap(segment);
            return true;
        }
        return false;
    }

    public static class M3U8Segment {
        private X_KEY_METHOD xKeyMethod = X_KEY_METHOD.NONE;
        private String xKeyIV = null;
        private String xKeyURI = null;
        private final String url;
        private volatile long loaded = -1L;
        private volatile long duration;
        private volatile long size = -1L;
        private long[] byteRange = null;

        public String getxKeyIV() {
            return this.xKeyIV;
        }

        protected void setxKeyIV(String xKeyIV) {
            this.xKeyIV = xKeyIV;
        }

        public String getxKeyURI() {
            return this.xKeyURI;
        }

        protected void setxKeyURI(String xKeyURI) {
            this.xKeyURI = xKeyURI;
        }

        public X_KEY_METHOD getxKeyMethod() {
            return this.xKeyMethod;
        }

        public boolean isEncrypted() {
            return this.getxKeyMethod().isEncrypted();
        }

        protected void setxKeyMethod(X_KEY_METHOD xKeyMethod) {
            this.xKeyMethod = xKeyMethod == null ? X_KEY_METHOD.NONE : xKeyMethod;
        }

        public static final String toExtInfDuration(long duration) {
            String value = Long.toString(duration);
            switch (value.length()) {
                case 0: {
                    return "0.000";
                }
                case 1: {
                    return "0.00".concat(value);
                }
                case 2: {
                    return "0.0".concat(value);
                }
                case 3: {
                    return "0.".concat(value);
                }
            }
            return value.replaceFirst("(\\d{3})$", ".$1").replaceFirst("^\\.", "0.");
        }

        public static long fromExtInfDuration(String extInf) {
            String[] duration = new Regex(extInf, "#EXTINF:(\\d+)(\\.(\\d+))?").getRow(0);
            if (duration != null) {
                String secs = duration[0];
                String msns = duration[2];
                if (duration.length == 1 || msns == null) {
                    return Long.parseLong(secs) * 1000L;
                }
                long ret = Long.parseLong(secs) * 1000L;
                ret = msns.length() == 1 ? (ret += Long.parseLong(msns) * 100L) : (msns.length() == 2 ? (ret += Long.parseLong(msns) * 10L) : (msns.length() == 3 ? (ret += Long.parseLong(msns)) : (ret += Long.parseLong(msns.substring(0, 3)))));
                return ret;
            }
            return -1L;
        }

        public long getLoaded() {
            return this.loaded;
        }

        public void setLoaded(long loaded) {
            this.loaded = loaded >= 0L ? loaded : -1L;
        }

        public long getSize() {
            if (this.isByteRange()) {
                return this.getByteRange()[0];
            }
            return this.size;
        }

        public void setSize(long size) {
            this.size = Math.max(size, 0L);
        }

        public String getUrl() {
            return this.url;
        }

        public long getDuration() {
            return this.duration;
        }

        private void setDuration(long duration) {
            this.duration = duration;
        }

        public long[] getByteRange() {
            return this.byteRange;
        }

        public boolean isByteRange() {
            return this.getByteRange() != null;
        }

        private void setByteRange(long[] byteRange) {
            this.byteRange = byteRange;
        }

        public M3U8Segment(String url, long duration) {
            this.url = url;
            this.duration = duration < 0L ? -1L : duration;
        }

        public String toString() {
            if (this.isByteRange()) {
                return "M3U8Segment:Encrypted:" + this.isEncrypted() + "|Duration:" + this.getDuration() + "ms|ByteRange:" + Arrays.toString(this.getByteRange()) + "|URL:" + this.getUrl();
            }
            return "M3U8Segment:Encrypted:" + this.isEncrypted() + "|Duration:" + this.getDuration() + "ms|URL:" + this.getUrl();
        }

        public static enum X_KEY_METHOD {
            NONE("NONE"),
            AES_128("AES-128"),
            SAMPLE_AES("SAMPLE-AES");

            private final String method;

            public String getMethod() {
                return this.method;
            }

            private X_KEY_METHOD(String method) {
                this.method = method;
            }

            public boolean isEncrypted() {
                return this != NONE;
            }

            public static X_KEY_METHOD get(String method) {
                if (method == null || method.trim().length() == 0) {
                    return NONE;
                }
                for (X_KEY_METHOD ret : X_KEY_METHOD.values()) {
                    if (!ret.getMethod().equals(method)) continue;
                    return ret;
                }
                return null;
            }
        }
    }
}

