/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.encoding;

import java.util.ArrayList;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;

public class AADecoder {
    private static final String HEX_HASH_MARKER = "(o\uff9f\uff70\uff9fo)+ ";
    private static final String BLOCK_START_MARKER = "(\uff9f\u0414\uff9f)[\uff9f\u03b5\uff9f]+";
    private static final String[] BYTES = new String[]{"(c^_^o)", "(\uff9f\u0398\uff9f)", "((o^_^o) - (\uff9f\u0398\uff9f))", "(o^_^o)", "(\uff9f\uff70\uff9f)", "((\uff9f\uff70\uff9f) + (\uff9f\u0398\uff9f))", "((o^_^o) +(o^_^o))", "((\uff9f\uff70\uff9f) + (o^_^o))", "((\uff9f\uff70\uff9f) + (\uff9f\uff70\uff9f))", "((\uff9f\uff70\uff9f) + (\uff9f\uff70\uff9f) + (\uff9f\u0398\uff9f))", "(\uff9f\u0414\uff9f) .\uff9f\u03c9\uff9f\uff89", "(\uff9f\u0414\uff9f) .\uff9f\u0398\uff9f\uff89", "(\uff9f\u0414\uff9f) ['c']", "(\uff9f\u0414\uff9f) .\uff9f\uff70\uff9f\uff89", "(\uff9f\u0414\uff9f) .\uff9f\u0414\uff9f\uff89", "(\uff9f\u0414\uff9f) [\uff9f\u0398\uff9f]"};
    public static boolean DEBUG = false;
    private String input = null;

    public AADecoder() {
    }

    public AADecoder(String input) {
        this.input = input;
    }

    public boolean isAAEncoded(String js) {
        if (!js.startsWith("\uff9f\u03c9\uff9f\uff89= /\uff40\uff4d\u00b4\uff09\uff89 ~\u253b\u2501\u253b   //*\u00b4\u2207\uff40*/ ['_']; o=(\uff9f\uff70\uff9f)  =_=3; c=(\uff9f\u0398\uff9f) =(\uff9f\uff70\uff9f)-(\uff9f\uff70\uff9f); ")) {
            return false;
        }
        return js.endsWith("(\uff9f\u0414\uff9f)[\uff9fo\uff9f]) (\uff9f\u0398\uff9f)) ('_');");
    }

    protected String fetchJs() {
        if (this.input == null) {
            throw new WTFException("Problemo, with finding JS");
        }
        String js = new Regex(this.input, "\uff9f\u03c9\uff9f.*?\\('_'\\);").getMatch(-1);
        return js;
    }

    public String decode() throws Exception {
        return this.decode(null);
    }

    public String decode(String js) throws Exception {
        if (StringUtils.isEmpty((String)js) && StringUtils.isEmpty((String)(js = this.fetchJs()))) {
            return null;
        }
        js = js.replace("/*\u00b4\u2207\uff40*/", "");
        js = js.replaceAll("^\\s+|\\s+$", "");
        String data = new Regex(js, "\\(\uff9f\u0414\uff9f\\)\\[\uff9fo\uff9f\\]\\+ (.+?)\\(\uff9f\u0414\uff9f\\)\\[\uff9fo\uff9f\\]\\)").getMatch(0);
        String out = "";
        while (StringUtils.isNotEmpty((String)data)) {
            String uniCodeNumString;
            int index = data.indexOf(BLOCK_START_MARKER);
            if (index != 0) {
                throw new WTFException("No AAEncode");
            }
            data = data.substring(BLOCK_START_MARKER.length());
            String encodedBlock = null;
            index = data.indexOf(BLOCK_START_MARKER);
            if (index == -1) {
                encodedBlock = data;
                data = "";
            } else {
                encodedBlock = data.substring(0, index);
                data = data.substring(encodedBlock.length());
            }
            int radix = 8;
            if (encodedBlock.indexOf(HEX_HASH_MARKER) == 0) {
                encodedBlock = encodedBlock.substring(HEX_HASH_MARKER.length());
                radix = 16;
            }
            if (DEBUG) {
                System.out.println("Rad " + radix);
            }
            if (StringUtils.isEmpty((String)(uniCodeNumString = this.decodeBlock(encodedBlock, radix)))) {
                throw new WTFException("Bad decoding for " + encodedBlock);
            }
            out = out + Character.toString((char)Integer.parseInt(uniCodeNumString, radix));
            if (!DEBUG) continue;
            System.out.println(out);
        }
        return out;
    }

    public static double eval(final String str) {
        return new Object(){
            int pos = -1;
            int ch;

            void nextChar() {
                this.ch = ++this.pos < str.length() ? (int)str.charAt(this.pos) : -1;
            }

            boolean eat(int charToEat) {
                while (this.ch == 32) {
                    this.nextChar();
                }
                if (this.ch == charToEat) {
                    this.nextChar();
                    return true;
                }
                return false;
            }

            double parse() {
                this.nextChar();
                double x = this.parseExpression();
                if (this.pos < str.length()) {
                    throw new RuntimeException("Unexpected: " + (char)this.ch);
                }
                return x;
            }

            double parseExpression() {
                double x = this.parseTerm();
                while (true) {
                    if (this.eat(43)) {
                        x += this.parseTerm();
                        continue;
                    }
                    if (this.eat(45)) {
                        x -= this.parseTerm();
                        continue;
                    }
                    if (!this.eat(126)) break;
                    x -= this.parseTerm();
                }
                return x;
            }

            double parseTerm() {
                double x = this.parseFactor();
                while (true) {
                    if (this.eat(42)) {
                        x *= this.parseFactor();
                        continue;
                    }
                    if (this.eat(47)) {
                        x /= this.parseFactor();
                        continue;
                    }
                    if (!this.eat(126)) break;
                    double pf = this.parseFactor();
                    x = ~((int)Math.floor(x));
                }
                return x;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            double parseFactor() {
                double x;
                if (this.eat(43)) {
                    return this.parseFactor();
                }
                if (this.eat(45)) {
                    return -this.parseFactor();
                }
                if (this.eat(126)) {
                    return ~((int)Math.floor(this.parseFactor()));
                }
                int startPos = this.pos;
                if (this.eat(40)) {
                    x = this.parseExpression();
                    this.eat(41);
                } else if (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                    while (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                        this.nextChar();
                    }
                    x = Double.parseDouble(str.substring(startPos, this.pos));
                } else {
                    if (this.ch < 97) throw new RuntimeException("Unexpected: " + (char)this.ch);
                    if (this.ch > 122) throw new RuntimeException("Unexpected: " + (char)this.ch);
                    while (this.ch >= 97 && this.ch <= 122) {
                        this.nextChar();
                    }
                    String func = str.substring(startPos, this.pos);
                    x = this.parseFactor();
                    if (func.equals("sqrt")) {
                        x = Math.sqrt(x);
                    } else if (func.equals("sin")) {
                        x = Math.sin(Math.toRadians(x));
                    } else if (func.equals("cos")) {
                        x = Math.cos(Math.toRadians(x));
                    } else {
                        if (!func.equals("tan")) throw new RuntimeException("Unknown function: " + func);
                        x = Math.tan(Math.toRadians(x));
                    }
                }
                if (!this.eat(94)) return x;
                return Math.pow(x, this.parseFactor());
            }
        }.parse();
    }

    private String decodeBlock(String encodedBlock, int radix) {
        String org = encodedBlock;
        for (int i = 0; i < BYTES.length; ++i) {
            encodedBlock = encodedBlock.replace(BYTES[i], String.valueOf(i));
        }
        StringBuilder exp = new StringBuilder();
        ArrayList<String> expressions = new ArrayList<String>();
        int braceCount = 0;
        for (int i = 0; i < encodedBlock.length(); ++i) {
            char c = encodedBlock.charAt(i);
            if (c == '(') {
                if (exp.length() > 0 && braceCount == 0) {
                    expressions.add(exp.toString());
                    exp.setLength(0);
                }
                ++braceCount;
                if (Character.isWhitespace(c)) continue;
                exp.append(c);
                continue;
            }
            if (c == ')') {
                --braceCount;
                if (Character.isWhitespace(c)) continue;
                exp.append(c);
                continue;
            }
            if (!Character.isWhitespace(c)) {
                exp.append(c);
                continue;
            }
            if (i <= 0 || c != ' ' || encodedBlock.charAt(i - 1) != '+' || braceCount != 0 || exp.length() <= 0) continue;
            expressions.add(exp.toString());
            exp.setLength(0);
        }
        if (exp.length() > 0) {
            expressions.add(exp.toString());
            exp.setLength(0);
        }
        String ret = "";
        for (String expression : expressions) {
            expression = expression.trim().replaceAll("\\+$", "");
            ret = ret + Integer.toString((int)AADecoder.eval(expression), radix);
        }
        if (DEBUG) {
            System.out.println(ret + " - " + encodedBlock);
        }
        return ret;
    }
}

