/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions;

import java.awt.Component;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import javax.swing.Icon;
import jd.config.ConfigContainer;
import jd.gui.swing.jdgui.views.settings.sidebar.AddonConfig;
import jd.plugins.AddonPanel;
import jd.plugins.ExtensionConfigInterface;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.JsonConfig;
import org.appwork.txtresource.TranslateInterface;
import org.appwork.txtresource.TranslationFactory;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.extensions.ExtensionConfigPanel;
import org.jdownloader.extensions.StartException;
import org.jdownloader.extensions.StopException;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.advanced.AdvancedConfigManager;

public abstract class AbstractExtension<ConfigType extends ExtensionConfigInterface, TranslationType extends TranslateInterface> {
    public static final int ADDON_INTERFACE_VERSION = 8;
    private boolean enabled = false;
    private String name = this.getClass().getSimpleName();
    private int version = AbstractExtension.readVersion(this.getClass());
    private ConfigType store = this.buildStore();
    public TranslationType T;
    protected final LogSource logger;

    public boolean isEnabled() {
        return this.enabled;
    }

    public Icon getIcon(int i) {
        return NewTheme.I().getIcon(this.getIconKey(), i);
    }

    public synchronized void setEnabled(boolean enabled) throws StartException, StopException {
        if (enabled == this.enabled) {
            return;
        }
        this.enabled = enabled;
        if (enabled) {
            this.store.setEnabled(true);
            this.start();
        } else {
            this.store.setEnabled(false);
            this.stop();
            if (this.getGUI() != null) {
                this.getGUI().setActive(false);
            }
        }
    }

    public void dispose() {
        try {
            this.stop();
        }
        catch (StopException e) {
            e.printStackTrace();
        }
        if (this.getGUI() != null) {
            this.getGUI().setActive(false);
        }
    }

    @Deprecated
    protected ExtensionConfigPanel createPanelFromContainer(ConfigContainer initSettings) {
        final AddonConfig cp = AddonConfig.getInstance((ConfigContainer)initSettings, (String)"", (boolean)false);
        ExtensionConfigPanel ret = new ExtensionConfigPanel<AbstractExtension<ConfigType, TranslationType>>(this, false){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onShow() {
            }

            @Override
            protected void onHide() {
            }

            @Override
            public void save() {
                cp.setHidden();
            }

            @Override
            public void updateContents() {
                cp.setShown();
            }
        };
        ret.add((Component)cp, "gapleft 25,spanx,growx,pushx,growy,pushy");
        return ret;
    }

    public ConfigType getSettings() {
        return this.store;
    }

    protected abstract void stop() throws StopException;

    protected abstract void start() throws StartException;

    public LogSource getLogger() {
        return this.logger;
    }

    public TranslationType getTranslation() {
        return this.T;
    }

    public String getName() {
        return this.name;
    }

    public AbstractExtension() {
        AdvancedConfigManager.getInstance().register((ConfigInterface)this.store);
        this.logger = LogController.getInstance().getLogger(this.name);
        this.initTranslation();
    }

    private void initTranslation() {
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            Class cl = (Class)((ParameterizedType)type).getActualTypeArguments()[1];
            if (cl == TranslateInterface.class) {
                return;
            }
            this.T = TranslationFactory.create((Class)cl);
        }
    }

    protected void setTitle(String title) {
        this.name = title == null ? this.getClass().getSimpleName() : title;
    }

    private ConfigType buildStore() {
        return (ConfigType)((ExtensionConfigInterface)JsonConfig.create((File)Application.getResource((String)("cfg/" + this.getClass().getName())), this.getConfigClass()));
    }

    public Class<ConfigType> getConfigClass() {
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        throw new RuntimeException("Bad Extension Definition. Please add Generic ConfigClass: class " + this.getClass().getSimpleName() + " extends AbstractExtension<" + this.getClass().getSimpleName() + "Config>{... with 'public interface " + this.getClass().getSimpleName() + "Config extends ExtensionConfigInterface{...");
    }

    public static ExtensionConfigInterface createStore(String className, Class<? extends ExtensionConfigInterface> interfaceClass) {
        return (ExtensionConfigInterface)JsonConfig.create((File)Application.getResource((String)("cfg/" + className)), interfaceClass);
    }

    protected abstract void initExtension() throws StartException;

    public static int readVersion(Class<? extends AbstractExtension> class1) {
        try {
            URL url = class1.getResource("version.dat");
            if (url == null) {
                return -1;
            }
            return Integer.parseInt(IO.readURLToString((URL)url).trim());
        }
        catch (Throwable e) {
            return -1;
        }
    }

    public abstract ExtensionConfigPanel<?> getConfigPanel();

    public abstract boolean hasConfigPanel();

    public abstract String getDescription();

    public boolean isLinuxRunnable() {
        return true;
    }

    public abstract String getIconKey();

    public boolean isWindowsRunnable() {
        return true;
    }

    public boolean isMacRunnable() {
        return true;
    }

    public abstract AddonPanel<? extends AbstractExtension<ConfigType, TranslationType>> getGUI();

    public boolean isDefaultEnabled() {
        return false;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isQuickToggleEnabled() {
        return false;
    }

    public void init() throws StartException {
        long t = System.currentTimeMillis();
        this.initExtension();
        if (this.store.isFreshInstall()) {
            this.store.setEnabled(this.isDefaultEnabled());
            this.store.setFreshInstall(false);
        }
        if (this.store.isEnabled()) {
            try {
                this.setEnabled(true);
            }
            catch (StopException stopException) {
                // empty catch block
            }
        }
        this.logger.info("Init Duration: " + (System.currentTimeMillis() - t));
    }

    public void handleCommand(String command, String ... parameters) {
    }

    public boolean isGuiOptional() {
        return true;
    }

    public abstract boolean isHeadlessRunnable();
}

