/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.swing.Icon;
import jd.gui.swing.jdgui.views.settings.sidebar.CheckBoxedEntry;
import jd.plugins.ExtensionConfigInterface;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.Storable;
import org.appwork.utils.Application;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.extensions.AbstractExtension;
import org.jdownloader.extensions.StartException;
import org.jdownloader.extensions.StopException;
import org.jdownloader.images.NewTheme;
import org.jdownloader.translate._JDT;

public class LazyExtension
implements Storable,
CheckBoxedEntry {
    private Class<AbstractExtension<?, ?>> clazz;
    private boolean settings;
    private String configInterface;
    private boolean quickToggle;
    private boolean headlessRunnable;
    private String description;
    private AbstractExtension<?, ?> extension = null;
    private String lng;
    private String iconPath;
    private boolean linuxRunnable;
    private boolean macRunnable;
    private String name;
    private int version;
    private boolean windowsRunnable;
    private ClassLoader classLoader;
    private String classname;
    protected volatile Class<AbstractExtension<?, ?>> pluginClass;
    private volatile Constructor<AbstractExtension<?, ?>> constructor;
    private String jarPath;
    private String className;

    public static LazyExtension create(String id, Class<AbstractExtension<?, ?>> cls) throws StartException, InstantiationException, IllegalAccessException, IOException {
        LazyExtension ret = new LazyExtension();
        long t = System.currentTimeMillis();
        AbstractExtension<?, ?> plg = cls.newInstance();
        ret.description = plg.getDescription();
        Object fos = null;
        ret.iconPath = plg.getIconKey();
        ret.linuxRunnable = plg.isLinuxRunnable();
        ret.macRunnable = plg.isMacRunnable();
        ret.settings = plg.hasConfigPanel();
        ret.name = plg.getName();
        ret.lng = _JDT.getLanguage();
        ret.version = plg.getVersion();
        ret.windowsRunnable = plg.isWindowsRunnable();
        ret.classname = cls.getName();
        ret.extension = plg;
        ret.configInterface = plg.getConfigClass().getName();
        ret.quickToggle = plg.isQuickToggleEnabled();
        ret.headlessRunnable = plg.isHeadlessRunnable();
        if (!Application.isHeadless() || ret.headlessRunnable) {
            plg.init();
        }
        return ret;
    }

    public boolean isQuickToggle() {
        return this.quickToggle;
    }

    public void setQuickToggle(boolean quickToggle) {
        this.quickToggle = quickToggle;
    }

    public String getConfigInterface() {
        return this.extension == null ? this.configInterface : this.extension.getConfigClass().getName();
    }

    public void setConfigInterface(String configInterface) {
        this.configInterface = configInterface;
    }

    public boolean isSettings() {
        return this.extension == null ? this.settings : this.extension.hasConfigPanel();
    }

    public void setSettings(boolean settings) {
        this.settings = settings;
    }

    public String getLng() {
        return this.lng;
    }

    public void setLng(String lng) {
        this.lng = lng;
    }

    public AbstractExtension<?, ?> _getExtension() {
        return this.extension;
    }

    public Icon _getIcon(int size) {
        if (this.extension == null) {
            return NewTheme.I().getIcon(this.iconPath, size);
        }
        return NewTheme.I().getIcon(this.extension.getIconKey(), size);
    }

    public String getDescription() {
        return this.extension == null ? this.description : this.extension.getDescription();
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getName() {
        return this.extension == null ? this.name : this.extension.getName();
    }

    public int getVersion() {
        return this.extension == null ? this.version : this.extension.getVersion();
    }

    public boolean isLinuxRunnable() {
        return this.extension == null ? this.linuxRunnable : this.extension.isLinuxRunnable();
    }

    public boolean isMacRunnable() {
        return this.extension == null ? this.macRunnable : this.extension.isMacRunnable();
    }

    public boolean isWindowsRunnable() {
        return this.extension == null ? this.windowsRunnable : this.extension.isWindowsRunnable();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public void setLinuxRunnable(boolean linuxRunnable) {
        this.linuxRunnable = linuxRunnable;
    }

    public void setMacRunnable(boolean macRunnable) {
        this.macRunnable = macRunnable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setWindowsRunnable(boolean windowsRunnable) {
        this.windowsRunnable = windowsRunnable;
    }

    public void init() throws InstantiationException, IllegalAccessException, ClassNotFoundException, StartException {
        if (this.extension == null) {
            AbstractExtension<?, ?> plg = this.newInstance();
            plg.init();
            this.extension = plg;
        }
    }

    public boolean _isEnabled() {
        if (this.extension == null) {
            ExtensionConfigInterface ret = this._getSettings();
            if (ret == null) {
                return false;
            }
            return ret.isEnabled();
        }
        return this.extension.isEnabled();
    }

    public void _setEnabled(boolean b) throws StartException, StopException {
        if (this.extension == null) {
            ExtensionConfigInterface ret = this._getSettings();
            if (ret == null) {
                return;
            }
            ret.setEnabled(b);
            if (b) {
                try {
                    this.init();
                }
                catch (Throwable e) {
                    throw new StartException(e);
                }
            }
        } else {
            this.extension.setEnabled(b);
        }
    }

    public ExtensionConfigInterface _getSettings() {
        try {
            return AbstractExtension.createStore(this.getClassname(), Class.forName(this.getConfigInterface(), true, this._getClassLoader()));
        }
        catch (Throwable e) {
            throw new WTFException(e);
        }
    }

    private synchronized ClassLoader _getClassLoader() {
        if (this.classLoader == null) {
            if (this.jarPath == null || !this.jarPath.endsWith(".jar")) {
                this.classLoader = LazyExtension.class.getClassLoader();
            } else {
                try {
                    LoggerFactory.getDefaultLogger().info("Use " + this.jarPath + " classloader");
                    this.classLoader = new URLClassLoader(new URL[]{new File(this.jarPath).toURI().toURL()}, this.getClass().getClassLoader());
                }
                catch (MalformedURLException e) {
                    LoggerFactory.getDefaultLogger().info("WTF");
                    e.printStackTrace();
                    throw new WTFException((Throwable)e);
                }
            }
        }
        return this.classLoader;
    }

    public void _setPluginClass(Class<AbstractExtension<?, ?>> pluginClass) {
        this.pluginClass = pluginClass;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    private AbstractExtension<?, ?> newInstance() {
        try {
            this._getConstructor();
            return this.constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new WTFException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Constructor<AbstractExtension<?, ?>> _getConstructor() {
        if (this.constructor != null) {
            return this.constructor;
        }
        LazyExtension lazyExtension = this;
        synchronized (lazyExtension) {
            if (this.constructor != null) {
                return this.constructor;
            }
            try {
                this.constructor = this._getPluginClass().getConstructor(new Class[0]);
            }
            catch (Throwable e) {
                throw new WTFException(e);
            }
            return this.constructor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<AbstractExtension<?, ?>> _getPluginClass() {
        if (this.pluginClass != null) {
            return this.pluginClass;
        }
        LazyExtension lazyExtension = this;
        synchronized (lazyExtension) {
            if (this.pluginClass != null) {
                return this.pluginClass;
            }
            try {
                this.pluginClass = Class.forName(this.classname, true, this._getClassLoader());
            }
            catch (Throwable e) {
                throw new WTFException(e);
            }
            return this.pluginClass;
        }
    }

    public void setJarPath(String absolutePath) {
        this.jarPath = absolutePath;
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public void validateCache() throws InstantiationException {
        if (Application.getRessourceURL((String)this.iconPath) == null && !NewTheme.I().hasIcon(this.iconPath)) {
            throw new InstantiationException("Cache of " + this.jarPath + " is invalid. Icon:'" + this.iconPath + "' is missing");
        }
    }

    public boolean isHeadlessRunnable() {
        return this.headlessRunnable;
    }

    public void setHeadlessRunnable(boolean headless) {
        this.headlessRunnable = headless;
    }
}

