/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateListener;
import jd.gui.swing.jdgui.views.settings.components.TextPane;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.IconLabelToolTip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.components.tooltips.ToolTipHandler;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;

public class RegexListTextPane
extends TextPane
implements ToolTipHandler {
    private UnderlineHighlightPainter lastPainter;

    public void setEnabled(boolean enabled) {
        if (this.txt != null) {
            this.txt.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.txt != null && this.txt.isEnabled();
    }

    public RegexListTextPane() {
        this.addStateUpdateListener(new StateUpdateListener(){

            public void onStateUpdated() {
                RegexListTextPane.this.updateHighlights();
            }
        });
        ToolTipController.getInstance().register((ToolTipHandler)this);
        ToolTipManager.sharedInstance().unregisterComponent((JComponent)((Object)this));
        ToolTipManager.sharedInstance().unregisterComponent(this.txt);
        this.txt.setMargin(new Insets(0, 30, 0, 0));
        this.txt.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                RegexListTextPane.this.dispatchEvent(SwingUtilities.convertMouseEvent(RegexListTextPane.this.txt, e, (Component)((Object)RegexListTextPane.this)));
                if (CrossSystem.isContextMenuTrigger((MouseEvent)e)) {
                    ToolTipController.getInstance().show((ToolTipHandler)RegexListTextPane.this);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                RegexListTextPane.this.dispatchEvent(SwingUtilities.convertMouseEvent(RegexListTextPane.this.txt, e, (Component)((Object)RegexListTextPane.this)));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RegexListTextPane.this.dispatchEvent(SwingUtilities.convertMouseEvent(RegexListTextPane.this.txt, e, (Component)((Object)RegexListTextPane.this)));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                RegexListTextPane.this.dispatchEvent(SwingUtilities.convertMouseEvent(RegexListTextPane.this.txt, e, (Component)((Object)RegexListTextPane.this)));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                RegexListTextPane.this.dispatchEvent(SwingUtilities.convertMouseEvent(RegexListTextPane.this.txt, e, (Component)((Object)RegexListTextPane.this)));
            }
        });
        this.txt.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                RegexListTextPane.this.dispatchEvent(SwingUtilities.convertMouseEvent(RegexListTextPane.this.txt, e, (Component)((Object)RegexListTextPane.this)));
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                RegexListTextPane.this.dispatchEvent(SwingUtilities.convertMouseEvent(RegexListTextPane.this.txt, e, (Component)((Object)RegexListTextPane.this)));
            }
        });
    }

    protected void updateHighlights() {
        Highlighter highlighter = this.txt.getHighlighter();
        Highlighter.Highlight[] highlights = highlighter.getHighlights();
        for (int i = 0; i < highlights.length; ++i) {
            Highlighter.Highlight h = highlights[i];
            if (!(h.getPainter() instanceof UnderlineHighlightPainter)) continue;
            highlighter.removeHighlight(h);
        }
        try {
            Document doc = this.txt.getDocument();
            String text = doc.getText(0, doc.getLength());
            Matcher matcher = Pattern.compile("([^\r\n]+)").matcher(text);
            int line = 0;
            while (matcher.find()) {
                MatchResult mr = matcher.toMatchResult();
                int start = mr.start();
                String g2 = mr.group(1);
                int end = start + g2.length();
                if (this.validateLine(g2)) {
                    try {
                        this.txt.getHighlighter().addHighlight(start, end, new UnderlineHighlightPainter(line++, g2, true));
                    }
                    catch (BadLocationException e1) {
                        LoggerFactory.getDefaultLogger().log((Throwable)e1);
                    }
                    continue;
                }
                try {
                    this.txt.getHighlighter().addHighlight(start, end, new UnderlineHighlightPainter(line++, g2, false));
                }
                catch (BadLocationException e1) {
                    LoggerFactory.getDefaultLogger().log((Throwable)e1);
                }
            }
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
    }

    protected boolean validateLine(String g2) {
        try {
            Pattern.compile(g2);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public ExtTooltip createExtTooltip(Point position) {
        if (position == null) {
            position = ToolTipController.getMouseLocation();
            if (position == null) {
                this.lastPainter = null;
                return null;
            }
            position = new Point(position);
            SwingUtilities.convertPointFromScreen(position, (Component)((Object)this));
        }
        UnderlineHighlightPainter p = null;
        Highlighter highlighter = this.txt.getHighlighter();
        Highlighter.Highlight[] highlights = highlighter.getHighlights();
        for (int i = 0; i < highlights.length; ++i) {
            Rectangle bounds;
            Highlighter.Highlight h = highlights[i];
            if (!(h.getPainter() instanceof UnderlineHighlightPainter) || (bounds = ((UnderlineHighlightPainter)h.getPainter()).getBounds()) == null || !bounds.contains(position)) continue;
            p = (UnderlineHighlightPainter)h.getPainter();
        }
        this.lastPainter = p;
        if (p == null) {
            return null;
        }
        if (p.isOk()) {
            return this.createOkTooltip(p.getPattern());
        }
        return this.createFailTooltip(p.getPattern());
    }

    public ExtTooltip createFailTooltip(String p) {
        IconLabelToolTip ret = new IconLabelToolTip(_GUI.T.RegexListTextPane_createExtTooltip_bad(p), (Icon)new AbstractIcon("warning", 24));
        return ret;
    }

    public ExtTooltip createOkTooltip(String p) {
        IconLabelToolTip ret = new IconLabelToolTip(_GUI.T.RegexListTextPane_createExtTooltip_ok(p), (Icon)new AbstractIcon("ok", 24));
        return ret;
    }

    public boolean isTooltipDisabledUntilNextRefocus() {
        return false;
    }

    public boolean updateTooltip(ExtTooltip activeToolTip, MouseEvent e) {
        UnderlineHighlightPainter p = null;
        Highlighter highlighter = this.txt.getHighlighter();
        Highlighter.Highlight[] highlights = highlighter.getHighlights();
        for (int i = 0; i < highlights.length; ++i) {
            Rectangle bounds;
            Highlighter.Highlight h = highlights[i];
            if (!(h.getPainter() instanceof UnderlineHighlightPainter) || (bounds = ((UnderlineHighlightPainter)h.getPainter()).getBounds()) == null || !bounds.contains(e.getPoint())) continue;
            p = (UnderlineHighlightPainter)h.getPainter();
        }
        return p != this.lastPainter;
    }

    public boolean isFocusable() {
        return this.txt != null && this.txt.isFocusable();
    }

    public void setText(String t) {
        super.setText(t);
        this.updateHighlights();
    }

    public boolean hasFocus() {
        return this.txt != null && this.txt.hasFocus();
    }

    public boolean isTooltipWithoutFocusEnabled() {
        return false;
    }

    public int getTooltipDelay(Point mousePositionOnScreen) {
        mousePositionOnScreen = new Point(mousePositionOnScreen);
        SwingUtilities.convertPointFromScreen(mousePositionOnScreen, this.txt);
        UnderlineHighlightPainter p = null;
        Highlighter highlighter = this.txt.getHighlighter();
        Highlighter.Highlight[] highlights = highlighter.getHighlights();
        for (int i = 0; i < highlights.length; ++i) {
            Rectangle bounds;
            Highlighter.Highlight h = highlights[i];
            if (!(h.getPainter() instanceof UnderlineHighlightPainter) || (bounds = ((UnderlineHighlightPainter)h.getPainter()).getBounds()) == null || !bounds.contains(mousePositionOnScreen)) continue;
            p = (UnderlineHighlightPainter)h.getPainter();
        }
        if (p == null) {
            return 0;
        }
        if (p.isOk()) {
            return 0;
        }
        return 100;
    }

    public static class UnderlineHighlightPainter
    extends LayeredHighlighter.LayerPainter {
        private boolean ok;
        private AbstractIcon warning;
        private Rectangle bounds;
        private String pattern;
        private int line;
        private int min = Integer.MAX_VALUE;
        protected Color color;

        public String getPattern() {
            return this.pattern;
        }

        public UnderlineHighlightPainter(int line, String pattern, boolean ok) {
            this.ok = ok;
            this.color = ok ? Color.GREEN : Color.red;
            this.warning = new AbstractIcon("warning", 14);
            this.line = line;
            this.pattern = pattern;
        }

        public boolean isOk() {
            return this.ok;
        }

        @Override
        public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
        }

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
            g.setColor(this.color == null ? c.getSelectionColor() : this.color);
            Rectangle alloc = null;
            if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            } else {
                try {
                    Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                    alloc = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                }
                catch (BadLocationException e) {
                    return null;
                }
            }
            FontMetrics fm = c.getFontMetrics(c.getFont());
            int baseline = alloc.y + alloc.height - fm.getDescent() + 1;
            if (!this.ok) {
                g.drawLine(alloc.x, baseline, alloc.x + alloc.width + this.warning.getIconWidth(), baseline);
                g.drawLine(alloc.x, baseline + 1, alloc.x + alloc.width + this.warning.getIconWidth(), baseline + 1);
                this.warning.paintIcon(c, g, alloc.x + alloc.width, baseline - 14 + 1);
                this.bounds = new Rectangle(alloc.x, alloc.y, alloc.width + this.warning.getIconWidth(), alloc.height);
            } else {
                g.drawLine(alloc.x, baseline, alloc.x + alloc.width, baseline);
                g.drawLine(alloc.x, baseline + 1, alloc.x + alloc.width, baseline + 1);
                this.bounds = new Rectangle(alloc.x, alloc.y, alloc.width, alloc.height);
            }
            g.setColor(Color.GRAY);
            g.drawLine(alloc.x - 2, alloc.y, alloc.x - 2, alloc.y + alloc.height);
            this.min = Math.min(this.min, offs0);
            if (offs0 == this.min) {
                g.drawString(this.line + 1 + "", 0, baseline);
            }
            return alloc;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }
    }
}

