/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.helpdialogs;

import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.locator.DialogLocator;
import org.appwork.utils.swing.locator.AbstractLocator;
import org.jdownloader.gui.helpdialogs.MessageConfig;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.RestartController;

public class HelpDialog {
    public static void showIfAllowed(MessageConfig config) {
        if (!CFG_GUI.CFG.isHelpDialogsEnabled()) {
            return;
        }
        HelpDialog.show(config.getPoint(), config.getDontShowAgainKey(), config.getFlags(), config.getTitle(), config.getMsg(), config.getIcon());
    }

    public static void show(Point point, String dontShowAgainKey, int flags, String title, String msg, Icon icon) {
        HelpDialog.show(null, null, point, dontShowAgainKey, flags, title, msg, icon);
    }

    public static void showCaptchaSkippedDialog() {
        if (CFG_GUI.HELP_DIALOGS_ENABLED.isEnabled()) {
            HelpDialog.show(false, true, ToolTipController.getMouseLocation(), "SKIPPEDHOSTER", 32, _GUI.T.ChallengeDialogHandler_viaGUI_skipped_help_title(), _GUI.T.ChallengeDialogHandler_viaGUI_skipped_help_msg(), new AbstractIcon("skipped", 32));
        }
    }

    public static void show(final Boolean expandToBottom, final Boolean expandToRight, final Point point, final String dontShowAgainKey, int flags, String title, String msg, Icon icon) {
        Integer ret;
        final boolean test = RestartController.getInstance().getParameterParser(null).hasCommandSwitch("translatortest");
        if (!((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).isBalloonNotificationEnabled()) {
            return;
        }
        if (dontShowAgainKey != null && (ret = (Integer)JSonStorage.getPlainStorage((String)"Dialogs").get(dontShowAgainKey, (Object)-1)) != null && ret > 0) {
            return;
        }
        try {
            Integer ret2;
            ConfirmDialog d = new ConfirmDialog(flags | 0x10 | 0x20, title, _GUI.T.literall_usage_tipp() + "\r\n\r\n..." + msg, icon, null, null){
                {
                    super(x0, x1, x2, x3, x4, x5);
                    if (point != null) {
                        this.setLocator(new DialogLocator(){

                            public Point getLocationOnScreen(AbstractDialog<?> abstractDialog) {
                                if (Boolean.FALSE.equals(expandToBottom)) {
                                    point.y -= abstractDialog.getPreferredSize().height;
                                }
                                if (Boolean.FALSE.equals(expandToRight)) {
                                    point.x -= abstractDialog.getPreferredSize().width;
                                }
                                return AbstractLocator.correct((Point)point, (Window)abstractDialog.getDialog());
                            }

                            public void onClose(AbstractDialog<?> abstractDialog, ComponentEvent event) {
                            }
                        });
                    }
                }

                public String getDontShowAgainKey() {
                    if (test) {
                        return "bla_" + System.currentTimeMillis();
                    }
                    if (dontShowAgainKey == null) {
                        return super.getDontShowAgainKey();
                    }
                    return dontShowAgainKey;
                }

                public void windowClosing(WindowEvent arg0) {
                    this.setReturnmask(false);
                    this.dispose();
                }
            };
            if (BinaryLogic.containsAll((int)flags, (int[])new int[]{32})) {
                d.setDoNotShowAgainSelected(true);
            }
            if ((ret2 = (Integer)JSonStorage.getPlainStorage((String)"Dialogs").get(d.getDontShowAgainKey(), (Object)-1)) != null && ret2 > 0) {
                return;
            }
            d.show();
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
    }

    public static void show(int flags, String title, String msg, Icon icon) {
        HelpDialog.show(null, title, flags, title, msg, icon);
    }
}

