/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.jdtrayicon;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.components.toolbar.actions.ExitToolbarAction;
import jd.utils.JDUtilities;
import net.miginfocom.swing.MigLayout;
import org.appwork.swing.ExtJFrame;
import org.appwork.swing.components.ExtJToggleButton;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.EDTHelper;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.MenuContainer;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.MenuLink;
import org.jdownloader.controlling.contextmenu.SeparatorData;
import org.jdownloader.controlling.contextmenu.gui.ExtPopupMenu;
import org.jdownloader.controlling.contextmenu.gui.MenuBuilder;
import org.jdownloader.extensions.ExtensionNotLoadedException;
import org.jdownloader.gui.jdtrayicon.HoverEffect;
import org.jdownloader.gui.jdtrayicon.MenuManagerTrayIcon;
import org.jdownloader.gui.jdtrayicon.TrayExtension;
import org.jdownloader.gui.toolbar.MenuManagerMainToolbar;
import org.jdownloader.images.NewTheme;
import org.jdownloader.updatev2.gui.LAFOptions;

public final class TrayIconPopup
extends ExtJFrame
implements MouseListener {
    private static final long serialVersionUID = 2623190748929934409L;
    private boolean enteredPopup;
    private boolean hideThreadrunning = false;
    private transient Thread hideThread;
    private TrayExtension extension;
    private static final int ICON_SIZE = 20;
    private long visibleUntil = -1L;

    public void setVisible(boolean b) {
        if (this.isVisible() && !b) {
            this.visibleUntil = System.currentTimeMillis();
        }
        super.setVisible(b);
    }

    public void dispose() {
        this.visibleUntil = System.currentTimeMillis();
        super.dispose();
    }

    public TrayIconPopup(TrayExtension trayExtension) {
        this.setTitle("JDownloader");
        this.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
        this.extension = trayExtension;
        this.setVisible(false);
        this.setLayout((LayoutManager)new MigLayout("ins 0", "[grow,fill]", "[grow,fill]"));
        this.addMouseListener(this);
        this.setUndecorated(true);
        JPanel content = new JPanel((LayoutManager)new MigLayout("ins 5, wrap 1", "[fill]", "[]5[]"));
        this.add(content);
        JButton header = new JButton("<html><b>" + JDUtilities.getJDTitle(0) + "</b></html>");
        content.add((Component)header, "align center");
        header.setBorderPainted(false);
        header.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDGui.getInstance().setWindowToTray(false);
                TrayIconPopup.this.dispose();
            }
        });
        MenuItemData last = null;
        for (final MenuItemData menudata : MenuManagerTrayIcon.getInstance().getMenuData().getItems()) {
            JToggleButton bt = null;
            try {
                CustomizableAppAction action;
                if (!menudata.isVisible()) continue;
                if (menudata instanceof SeparatorData) {
                    if (last != null && last instanceof SeparatorData) continue;
                    content.add((Component)new JSeparator(0), "growx,spanx");
                    last = menudata;
                    continue;
                }
                if (menudata._getValidateException() != null) continue;
                if (menudata.getType() == MenuItemData.Type.CONTAINER) {
                    bt = new JToggleButton(){

                        @Override
                        protected void paintComponent(Graphics g) {
                            super.paintComponent(g);
                            Graphics2D g2 = (Graphics2D)g;
                            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                            g2.setComposite(AlphaComposite.getInstance(3, 0.8f));
                            g2.setColor(Color.BLACK);
                            g2.fillPolygon(new int[]{this.getWidth() - 5, this.getWidth() - 5 - 6, this.getWidth() - 5 - 6}, new int[]{this.getHeight() / 2, this.getHeight() / 2 - 4, this.getHeight() / 2 + 4}, 3);
                        }
                    };
                    bt.setText(menudata.getName());
                    bt.setOpaque(false);
                    bt.setContentAreaFilled(false);
                    bt.setBorderPainted(false);
                    bt.addActionListener(new ActionListener(){
                        private ExtPopupMenu root = null;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TrayIconPopup.this.hideThreadrunning = false;
                            if (this.root != null && this.root.isShowing()) {
                                return;
                            }
                            this.root = new ExtPopupMenu();
                            new MenuBuilder(MenuManagerMainToolbar.getInstance(), this.root, (MenuContainer)menudata){

                                @Override
                                protected void addAction(JComponent root, MenuItemData inst, int index, int size) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, ExtensionNotLoadedException {
                                    final JComponent ret = inst.addTo(root, this);
                                    if (ret instanceof AbstractButton) {
                                        ((AbstractButton)ret).addActionListener(new ActionListener(){

                                            @Override
                                            public void actionPerformed(ActionEvent evt) {
                                                ((AbstractButton)ret).getAction().actionPerformed(evt);
                                                TrayIconPopup.this.dispose();
                                            }
                                        });
                                    }
                                }
                            }.run();
                            Object src = e.getSource();
                            if (e.getSource() instanceof Component) {
                                Component button = (Component)e.getSource();
                                Dimension prefSize = this.root.getPreferredSize();
                                Insets insets = LAFOptions.getInstance().getExtension().customizePopupBorderInsets();
                                this.root.show(button, button.getWidth(), -insets.top);
                            }
                        }
                    });
                    bt.setIcon(MenuItemData.getIcon(menudata.getIconKey(), 20));
                    bt.setCursor(Cursor.getPredefinedCursor(12));
                    bt.setFocusPainted(false);
                    bt.setHorizontalAlignment(2);
                    bt.setIconTextGap(5);
                    bt.addMouseListener((MouseListener)((Object)new HoverEffect(bt)));
                    final JToggleButton finalBt = bt;
                    bt.addMouseListener(new MouseListener(){
                        private Timer timer;

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            if (this.timer != null) {
                                this.timer.stop();
                                this.timer = null;
                            }
                        }

                        @Override
                        public void mousePressed(MouseEvent e) {
                            if (this.timer != null) {
                                this.timer.stop();
                                this.timer = null;
                            }
                        }

                        @Override
                        public void mouseExited(MouseEvent e) {
                            if (this.timer != null) {
                                this.timer.stop();
                                this.timer = null;
                            }
                        }

                        @Override
                        public void mouseEntered(MouseEvent e) {
                            this.timer = new Timer(500, new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    finalBt.doClick();
                                }
                            });
                            this.timer.setRepeats(false);
                            this.timer.start();
                        }

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (this.timer != null) {
                                this.timer.stop();
                                this.timer = null;
                            }
                        }
                    });
                    content.add(bt);
                    continue;
                }
                if (menudata instanceof MenuLink) {
                    JComponent item = menudata.createItem(null);
                    if (StringUtils.isNotEmpty((String)menudata.getIconKey()) && item instanceof AbstractButton) {
                        ((AbstractButton)item).setIcon(MenuItemData.getIcon(menudata.getIconKey(), 20));
                    }
                    content.add((Component)item, "");
                    continue;
                }
                if (menudata.getActionData() == null || !menudata.getActionData()._isValidDataForCreatingAnAction() || !(action = menudata.createAction()).isVisible()) continue;
                if (StringUtils.isNotEmpty((String)menudata.getShortcut()) && KeyStroke.getKeyStroke(menudata.getShortcut()) != null) {
                    action.setAccelerator(KeyStroke.getKeyStroke(menudata.getShortcut()));
                } else if (MenuItemData.isEmptyValue(menudata.getShortcut())) {
                    action.setAccelerator(null);
                }
                content.add(this.getMenuEntry(action));
                last = menudata;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        content.setBorder(BorderFactory.createLineBorder(content.getBackground().darker()));
        this.setAlwaysOnTop(true);
        this.pack();
        this.hideThread = new Thread(){

            @Override
            public void run() {
                while (TrayIconPopup.this.hideThreadrunning) {
                    try {
                        5.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!TrayIconPopup.this.enteredPopup || !TrayIconPopup.this.hideThreadrunning) continue;
                    Point mouse = ToolTipController.getMouseLocation();
                    if (mouse == null) {
                        TrayIconPopup.this.dispose();
                        break;
                    }
                    Point current = TrayIconPopup.this.getLocation();
                    if (mouse.getLocation().x < current.x || mouse.getLocation().x > current.x + TrayIconPopup.this.getSize().width) {
                        TrayIconPopup.this.dispose();
                        break;
                    }
                    if (mouse.getLocation().y >= current.y && mouse.getLocation().y <= current.y + TrayIconPopup.this.getSize().height) continue;
                    TrayIconPopup.this.dispose();
                    break;
                }
            }
        };
        this.hideThreadrunning = true;
        this.hideThread.start();
    }

    public void startAutoHide() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!TrayIconPopup.this.enteredPopup) {
                    new EDTHelper<Object>(){

                        public Object edtRun() {
                            TrayIconPopup.this.hideThreadrunning = false;
                            TrayIconPopup.this.dispose();
                            return null;
                        }
                    }.start();
                }
            }
        }.start();
    }

    private AbstractButton getMenuEntry(AppAction action) {
        AbstractButton b = this.createButton(action);
        if (action instanceof ExitToolbarAction) {
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrayIconPopup.this.hideThreadrunning = false;
                    TrayIconPopup.this.dispose();
                }
            });
        }
        action.addVisibilityPropertyChangeListener(b);
        return b;
    }

    private AbstractButton createButton(AppAction action) {
        if (action instanceof CustomizableAppAction) {
            ((CustomizableAppAction)action).requestUpdate(this);
        }
        if (action.isToggle()) {
            ExtJToggleButton bt = new ExtJToggleButton((AbstractAction)((Object)action));
            bt.setOpaque(false);
            bt.setContentAreaFilled(false);
            bt.setBorderPainted(false);
            bt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrayIconPopup.this.hideThreadrunning = false;
                    TrayIconPopup.this.dispose();
                }
            });
            Icon icon = NewTheme.I().getCheckBoxImage(action.getIconKey(), false, 20);
            bt.setIcon(icon);
            bt.setRolloverIcon(icon);
            icon = NewTheme.I().getCheckBoxImage(action.getIconKey(), true, 20);
            bt.setSelectedIcon(icon);
            bt.setRolloverSelectedIcon(icon);
            bt.setCursor(Cursor.getPredefinedCursor(12));
            bt.setFocusPainted(false);
            bt.setHorizontalAlignment(2);
            bt.setIconTextGap(5);
            bt.addMouseListener((MouseListener)((Object)new HoverEffect((AbstractButton)bt)));
            return bt;
        }
        ExtJToggleButton bt = new ExtJToggleButton((AbstractAction)((Object)action));
        bt.setOpaque(false);
        bt.setContentAreaFilled(false);
        bt.setBorderPainted(false);
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrayIconPopup.this.hideThreadrunning = false;
                TrayIconPopup.this.dispose();
            }
        });
        Icon actionIcon = action.getIcon(20);
        if (actionIcon != null) {
            bt.setIcon(actionIcon);
        }
        bt.setCursor(Cursor.getPredefinedCursor(12));
        bt.setFocusPainted(false);
        bt.setHorizontalAlignment(2);
        bt.setIconTextGap(5);
        bt.addMouseListener((MouseListener)((Object)new HoverEffect((AbstractButton)bt)));
        return bt;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.enteredPopup = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public boolean hasBeenRecentlyActive() {
        return this.isVisible() || System.currentTimeMillis() - this.visibleUntil < 10000L;
    }
}

