/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.jdtrayicon;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.gui.swing.components.JWindowTooltip;
import jd.gui.swing.jdgui.components.JDProgressBar;
import jd.nutils.Formatter;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.AggregatedNumbers;
import org.jdownloader.gui.jdtrayicon.translate._TRAY;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;

public class TrayIconTooltip
extends JWindowTooltip {
    private static final long serialVersionUID = -400023413449818691L;
    private JLabel lblSpeed;
    private JLabel lblDlRunning;
    private JDProgressBar prgTotal;
    private JLabel lblETA;
    private JLabel lblProgress;

    public TrayIconTooltip() {
        this.setName("JDownloader");
    }

    protected void addContent(JPanel panel) {
        panel.setLayout((LayoutManager)new MigLayout("wrap 2", "[fill, grow][fill, grow]"));
        panel.add((Component)new JLabel(_TRAY.T.plugins_optional_trayIcon_downloads()), "spanx 2");
        panel.add((Component)new JLabel(_TRAY.T.plugins_optional_trayIcon_dl_running()), "gapleft 10");
        this.lblDlRunning = new JLabel("0");
        panel.add(this.lblDlRunning);
        panel.add(new JLabel(_TRAY.T.plugins_optional_trayIcon_speed()));
        this.lblSpeed = new JLabel("0 B/s");
        panel.add(this.lblSpeed);
        panel.add(new JLabel(_TRAY.T.plugins_optional_trayIcon_progress()));
        this.lblProgress = new JLabel("--.-- Mib / --.-- Mib");
        panel.add(this.lblProgress);
        this.prgTotal = new JDProgressBar();
        panel.add((Component)this.prgTotal, "spanx 2");
        panel.add(new JLabel(_TRAY.T.plugins_optional_trayIcon_eta()));
        this.lblETA = new JLabel("00d:00h:00m:00s");
        panel.add(this.lblETA);
    }

    protected void updateContent() {
        final Thread thread = Thread.currentThread();
        SelectionInfo<FilePackage, DownloadLink> selection = DownloadsTableModel.getInstance().getTable().getSelectionInfo(false, false);
        if (selection != null) {
            final AggregatedNumbers dla = new AggregatedNumbers(selection);
            new EDTRunner(){

                protected void runInEDT() {
                    if (TrayIconTooltip.this.isVisible()) {
                        long totalDl = dla.getTotalBytes();
                        long curDl = dla.getLoadedBytes();
                        TrayIconTooltip.this.lblDlRunning.setText(String.valueOf(DownloadWatchDog.getInstance().getRunningDownloadLinks().size()));
                        TrayIconTooltip.this.lblSpeed.setText(Formatter.formatReadable((long)DownloadWatchDog.getInstance().getDownloadSpeedManager().getSpeed()) + "/s");
                        TrayIconTooltip.this.lblProgress.setText(Formatter.formatFilesize((double)curDl, (int)0) + " / " + Formatter.formatFilesize((double)totalDl, (int)0));
                        TrayIconTooltip.this.prgTotal.setMaximum(totalDl);
                        TrayIconTooltip.this.prgTotal.setValue(curDl);
                        TrayIconTooltip.this.lblETA.setText(dla.getEtaString());
                    } else {
                        TrayIconTooltip.this.updater.compareAndSet((Object)thread, null);
                    }
                }
            }.waitForEDT();
        }
    }
}

