/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.mainmenu;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.filechooser.FileFilter;
import org.appwork.loggingv3.LogV3;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.utils.Application;
import org.appwork.utils.Files;
import org.appwork.utils.Regex;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.ExtFileChooserDialog;
import org.appwork.utils.swing.dialog.FileChooserSelectionMode;
import org.appwork.utils.swing.dialog.FileChooserType;
import org.appwork.utils.zip.ZipIOReader;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.mainmenu.BackupCreateAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.translate._JDT;
import org.jdownloader.updatev2.ForcedRestartRequest;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.RestartRequest;

public class BackupRestoreAction
extends CustomizableAppAction
implements ActionContext {
    private int maxAutoBackupFiles = -1;
    private int maxCFGBackupFolders = -1;

    public BackupRestoreAction() {
        this.setIconKey("load");
        this.setName(_GUI.T.BackupRestoreAction_BackupRestoreAction());
        this.setTooltipText(_GUI.T.BackupRestoreAction_BackupRestoreAction_tt());
    }

    public static String getTranslationForMaxAutoBackupFiles() {
        return _JDT.T.BackupRestoreAction_getTranslationForMaxAutoBackupFiles();
    }

    public static String getTranslationForMaxCFGBackupFolders() {
        return _JDT.T.BackupRestoreAction_getTranslationForMaxCFGBackupFolders();
    }

    @Customizer(link="#getTranslationForMaxAutoBackupFiles")
    public int getMaxAutoBackupFiles() {
        return this.maxAutoBackupFiles;
    }

    public void setMaxAutoBackupFiles(int maxAutoBackupFiles) {
        this.maxAutoBackupFiles = maxAutoBackupFiles;
    }

    @Customizer(link="#getTranslationForMaxCFGBackupFolders")
    public int getMaxCFGBackupFolders() {
        return this.maxCFGBackupFolders;
    }

    public void setMaxCFGBackupFolders(int maxCFGBackupFolders) {
        this.maxCFGBackupFolders = maxCFGBackupFolders;
    }

    private void cleanupCFGBackFolders(int maxCFGBackupFolders) {
        if (maxCFGBackupFolders < 1) {
            return;
        }
        File[] files = Application.getResource((String)"autobackup").getParentFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("^cfg_backup_\\d+$") && new File(dir, name).isDirectory();
            }
        });
        if (files != null && files.length > maxCFGBackupFolders) {
            ArrayList<File> list = new ArrayList<File>();
            for (File f : files) {
                list.add(f);
            }
            Collections.sort(list, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    long i1 = Long.parseLong(new Regex(o1.getName(), "cfg_backup_(\\d+)").getMatch(0));
                    long i2 = Long.parseLong(new Regex(o2.getName(), "cfg_backup_(\\d+)").getMatch(0));
                    return Long.compare(i2, i1);
                }
            });
            for (int i = maxCFGBackupFolders; i < list.size(); ++i) {
                try {
                    Files.deleteRecursiv((File)((File)list.get(i)));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void cleanupAutoBackups(int maxAutoBackupFiles) {
        if (maxAutoBackupFiles < 0) {
            return;
        }
        File[] files = Application.getResource((String)"autobackup").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("^backup_\\d+\\.jd2backup$");
            }
        });
        if (files != null && files.length > maxAutoBackupFiles) {
            ArrayList<File> list = new ArrayList<File>();
            for (File f : files) {
                list.add(f);
            }
            Collections.sort(list, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    int i1 = Integer.parseInt(new Regex(o1.getName(), "backup_(\\d+)\\.jd2backup").getMatch(0));
                    int i2 = Integer.parseInt(new Regex(o2.getName(), "backup_(\\d+)\\.jd2backup").getMatch(0));
                    return Integer.compare(i2, i1);
                }
            });
            for (int i = maxAutoBackupFiles; i < list.size(); ++i) {
                ((File)list.get(i)).delete();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        new Thread("Restore Backup"){

            @Override
            public void run() {
                BackupRestoreAction.this.cleanupCFGBackFolders(3);
                ExtFileChooserDialog d = new ExtFileChooserDialog(0, _GUI.T.BackupCreateAction_actionPerformed_filechooser_title(), _GUI.T.lit_open(), null);
                d.setFileFilter(new FileFilter[]{new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "*.jd2backup";
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().endsWith(".jd2backup");
                    }
                }});
                d.setFileSelectionMode(FileChooserSelectionMode.FILES_ONLY);
                d.setMultiSelection(false);
                d.setType(FileChooserType.OPEN_DIALOG);
                try {
                    int i = 1;
                    File auto = Application.getResource((String)("autobackup/backup_" + i + ".jd2backup"));
                    while (auto.exists()) {
                        auto = Application.getResource((String)("autobackup/backup_" + ++i + ".jd2backup"));
                    }
                    final File fauto = auto;
                    Dialog.getInstance().showConfirmDialog(0, _GUI.T.lit_restart(), _GUI.T.BackupRestoreAction_run_restart_ask(auto.getAbsolutePath()), null, _GUI.T.lit_continue(), null);
                    Dialog.getInstance().showDialog((AbstractDialog)d);
                    final File file = d.getSelectedFile();
                    if (file == null || !file.exists()) {
                        return;
                    }
                    ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){
                        {
                            this.setHookPriority(Integer.MIN_VALUE);
                        }

                        public String toString() {
                            return "ShutdownHook: Restore Backup";
                        }

                        public long getMaxDuration() {
                            return 0L;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onShutdown(ShutdownRequest shutdownRequest) {
                            try {
                                if (BackupRestoreAction.this.getMaxAutoBackupFiles() > 0) {
                                    BackupCreateAction.create(fauto);
                                }
                                if (BackupRestoreAction.this.getMaxAutoBackupFiles() >= 0) {
                                    BackupRestoreAction.this.cleanupAutoBackups(BackupRestoreAction.this.getMaxAutoBackupFiles());
                                }
                                File tmp = Application.getTempResource((String)("restorebackup_" + System.currentTimeMillis()));
                                while (tmp.exists()) {
                                    tmp = Application.getTempResource((String)("restorebackup_" + System.currentTimeMillis()));
                                }
                                File backup = Application.getResource((String)("cfg_backup_" + System.currentTimeMillis()));
                                while (backup.exists()) {
                                    backup = Application.getResource((String)("cfg_backup_" + System.currentTimeMillis()));
                                }
                                ZipIOReader zip = new ZipIOReader(file);
                                try {
                                    zip.extractTo(tmp);
                                }
                                finally {
                                    try {
                                        zip.close();
                                    }
                                    catch (Throwable throwable) {}
                                }
                                Application.getResource((String)"cfg").renameTo(backup);
                                if (BackupRestoreAction.this.getMaxCFGBackupFolders() >= 0) {
                                    BackupRestoreAction.this.cleanupCFGBackFolders(BackupRestoreAction.this.getMaxCFGBackupFolders());
                                }
                                if (Application.getResource((String)"cfg").exists()) {
                                    throw new Exception("Could not delete " + Application.getResource((String)"cfg"));
                                }
                                new File(tmp, "cfg").renameTo(Application.getResource((String)"cfg"));
                            }
                            catch (Exception e) {
                                LogV3.defaultLogger().log((Throwable)e);
                                Dialog.getInstance().showExceptionDialog(_GUI.T.lit_error_occured(), e.getMessage() + "\r\nPlease try to close JDownloader, and extract the file\r\n" + file.getAbsolutePath() + "\r\nto " + Application.getResource((String)"cfg").getParent() + "\r\nusing an application like WinZip, 7Zip or Winrar.\r\nIf this does not work, feel free to contact our support.", (Throwable)e);
                            }
                        }
                    });
                    RestartController.getInstance().directRestart((RestartRequest)new ForcedRestartRequest(new String[0]));
                }
                catch (DialogClosedException e1) {
                    e1.printStackTrace();
                }
                catch (DialogCanceledException e1) {
                    e1.printStackTrace();
                }
            }
        }.start();
    }
}

