/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify;

import java.util.List;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.notify.Element;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;
import org.jdownloader.gui.notify.gui.BubbleNotifyConfig;
import org.jdownloader.gui.notify.gui.CFG_BUBBLE;

public abstract class AbstractBubbleSupport {
    private String label;
    protected BooleanKeyHandler keyHandler;

    public String getLabel() {
        return this.label;
    }

    public abstract List<Element> getElements();

    public BooleanKeyHandler getKeyHandler() {
        return this.keyHandler;
    }

    public AbstractBubbleSupport(String label, BooleanKeyHandler keyhandler) {
        this.label = label;
        this.keyHandler = keyhandler;
    }

    protected void show(final AbstractNotifyWindow no) {
        if (no != null) {
            if (this.isEnabled()) {
                BubbleNotify.getInstance().show(no);
            } else {
                new EDTRunner(){

                    protected void runInEDT() {
                        no.dispose();
                    }
                };
            }
        }
    }

    public boolean isEnabled() {
        return this.keyHandler.isEnabled() && !BubbleNotifyConfig.BubbleNotifyEnabledState.NEVER.equals((Object)CFG_BUBBLE.CFG.getBubbleNotifyEnabledState());
    }

    protected void show(BubbleNotify.AbstractNotifyWindowFactory factory) {
        if (this.isEnabled() && factory != null) {
            BubbleNotify.getInstance().show(factory);
        }
    }
}

