/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify.captcha;

import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import jd.gui.swing.jdgui.components.IconedProcessIndicator;
import net.miginfocom.swing.MigLayout;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.actions.AppAction;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.SolverStatus;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.RecaptchaV2Challenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.ImageCaptchaChallenge;
import org.jdownloader.captcha.v2.solver.CESChallengeSolver;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.gui.notify.AbstractBubbleContentPanel;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.notify.Element;
import org.jdownloader.gui.notify.captcha.CESBubble;
import org.jdownloader.gui.notify.gui.CFG_BUBBLE;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.updatev2.gui.LAFOptions;

public class CESBubbleContent
extends AbstractBubbleContentPanel {
    private JLabel status;
    private long startTime;
    private JLabel duration;
    private CESChallengeSolver<?> solver;
    private CESSolverJob<?> job;
    private JLabel statusLbl;
    private JLabel timeoutLbl;
    private JLabel durationLbl;
    private ExtButton button;
    private CESBubble bubble;
    private SolverStatus latestStatus;
    private JLabel creditsLabel;
    private JLabel credits;
    protected IconedProcessIndicator progressCircle = null;

    public CESBubbleContent(final CESChallengeSolver<?> solver, final CESSolverJob<?> cesSolverJob, int timeoutms) {
        super(solver.getService().getIcon(20));
        Challenge<?> ic;
        this.solver = solver;
        this.job = cesSolverJob;
        this.startTime = System.currentTimeMillis();
        this.setLayout((LayoutManager)new MigLayout("ins 3 3 0 3,wrap 2", "[fill][grow,fill]", "[]"));
        MigPanel east = new MigPanel("ins 0 0 0 0,wrap 2", "[fill][grow,fill]", "[]");
        east.setOpaque(false);
        this.timeoutLbl = new JLabel(_GUI.T.CESBubbleContent_CESBubbleContent_wait(TimeFormatter.formatMilliSeconds((long)timeoutms, (int)0), solver.getService().getName()));
        east.add((Component)this.timeoutLbl, (Object)"hidemode 3,spanx");
        this.timeoutLbl.setForeground(LAFOptions.getInstance().getColorForErrorForeground());
        SwingUtils.toBold((JLabel)this.timeoutLbl);
        this.durationLbl = this.createHeaderLabel(_GUI.T.ReconnectDialog_layoutDialogContent_duration());
        east.add((Component)this.durationLbl, (Object)"hidemode 3");
        this.duration = new JLabel("");
        east.add((Component)this.duration, (Object)"hidemode 3");
        this.creditsLabel = this.createHeaderLabel(_GUI.T.CESBubbleContent_CESBubbleContent_credits());
        east.add((Component)this.creditsLabel, (Object)"hidemode 3");
        this.credits = new JLabel("");
        east.add((Component)this.credits, (Object)"hidemode 3");
        this.statusLbl = this.createHeaderLabel(_GUI.T.CESBubbleContent_CESBubbleContent_status());
        east.add((Component)this.statusLbl, (Object)"hidemode 3");
        this.status = new JLabel("");
        east.add((Component)this.status, (Object)"hidemode 3");
        this.progressCircle = this.createProgress(solver.getService().getIcon(20));
        this.add((Component)this.progressCircle, "width 32!,height 32!,pushx,growx,pushy,growy,aligny top");
        this.add((Component)east);
        if (CFG_BUBBLE.CFG.isCaptchaExchangeSolverBubbleImageVisible() && !(cesSolverJob.getChallenge() instanceof RecaptchaV2Challenge) && (ic = cesSolverJob.getChallenge()) instanceof ImageCaptchaChallenge) {
            try {
                ImageIcon icon = null;
                icon = new ImageIcon(((ImageCaptchaChallenge)ic).getAnnotatedImage());
                if (icon.getIconWidth() > 300 || icon.getIconHeight() > 300) {
                    icon = new ImageIcon(IconIO.getScaledInstance((Image)icon.getImage(), (int)300, (int)300));
                }
                this.add(new JSeparator(), "spanx,pushx,growx");
                this.add(new JLabel(icon), "spanx,pushx,growx");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.progressCircle.setIndeterminate(true);
        this.progressCircle.setValue(0);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                solver.kill(cesSolverJob.getJob());
                if (CESBubbleContent.this.bubble != null) {
                    CESBubbleContent.this.bubble.hideBubble(0);
                }
            }
        });
        this.button = new ExtButton((AbstractAction)((Object)new AppAction(){
            {
                this.setName(_GUI.T.lit_cancel());
            }

            public void actionPerformed(ActionEvent e) {
                solver.kill(cesSolverJob.getJob());
                if (CESBubbleContent.this.bubble != null) {
                    CESBubbleContent.this.bubble.hideBubble(0);
                }
            }
        }));
        this.add((Component)this.button, "hidemode 3,spanx,pushx,growx");
        this.updateTimer(timeoutms);
    }

    @Override
    public void stop() {
        IconedProcessIndicator progressCircle = this.progressCircle;
        if (progressCircle != null) {
            progressCircle.setIndeterminate(false);
            progressCircle.setMaximum(100);
            progressCircle.setValue(100);
        }
        super.stop();
        this.update();
        this.button.setVisible(false);
    }

    public void update() {
        SolverStatus s = this.job.getStatus();
        if (s != null) {
            this.latestStatus = s;
        }
        this.credits.setText(this.solver.getAccountStatusString());
        if (this.latestStatus == null) {
            this.status.setVisible(false);
            this.statusLbl.setVisible(false);
        } else {
            this.status.setVisible(true);
            this.statusLbl.setVisible(true);
            this.status.setText(this.latestStatus.getLabel());
            this.status.setIcon(this.latestStatus.getIcon());
        }
        this.duration.setText(TimeFormatter.formatMilliSeconds((long)(System.currentTimeMillis() - this.startTime), (int)0));
    }

    @Override
    public void updateLayout() {
    }

    public static void fill(ArrayList<Element> elements) {
    }

    public void updateTimer(long rest) {
        this.update();
        this.timeoutLbl.setText(_GUI.T.CESBubbleContent_CESBubbleContent_wait(TimeFormatter.formatMilliSeconds((long)rest, (int)0), this.solver.getService().getName()));
        this.button.setVisible(true);
        this.timeoutLbl.setVisible(rest > 0L);
        this.durationLbl.setVisible(rest <= 0L);
        this.duration.setVisible(rest <= 0L);
        this.statusLbl.setVisible(rest <= 0L);
        this.status.setVisible(rest <= 0L);
        this.creditsLabel.setVisible(StringUtils.isNotEmpty((String)this.credits.getText()));
        this.credits.setVisible(StringUtils.isNotEmpty((String)this.credits.getText()));
        if (this.bubble != null) {
            this.bubble.pack();
            BubbleNotify.getInstance().relayout();
        }
    }

    public void setBubble(CESBubble cesBubble) {
        this.bubble = cesBubble;
    }
}

