/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify.captcha;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.captcha.v2.solver.CESChallengeSolver;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.gui.notify.AbstractBubbleSupport;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.notify.Element;
import org.jdownloader.gui.notify.captcha.CESBubble;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.settings.staticreferences.CFG_CAPTCHA;

public class CESBubbleSupport
extends AbstractBubbleSupport {
    private static final CESBubbleSupport INSTANCE = new CESBubbleSupport();

    public static CESBubbleSupport getInstance() {
        return INSTANCE;
    }

    private CESBubbleSupport() {
        super(_GUI.T.CESBubbleSupport_CESBubbleSupport(), CFG_CAPTCHA.REMOTE_CAPTCHA_BUBBLE_ENABLED);
    }

    @Override
    public List<Element> getElements() {
        return null;
    }

    public CESBubble show(final CESChallengeSolver<?> solver, final CESSolverJob<?> cesSolverJob, final int timeoutms) throws InterruptedException {
        if (this.isEnabled()) {
            final CESBubble ret = (CESBubble)new EDTHelper<CESBubble>(){

                public CESBubble edtRun() {
                    final AtomicReference<Object> ret = new AtomicReference<Object>(null);
                    CESBubbleSupport.this.show(new BubbleNotify.AbstractNotifyWindowFactory(){

                        @Override
                        public AbstractNotifyWindow<?> buildAbstractNotifyWindow() {
                            CESBubble bubble = new CESBubble(solver, cesSolverJob, timeoutms);
                            ret.set(bubble);
                            return bubble;
                        }
                    });
                    return ret.get();
                }
            }.getReturnValue();
            try {
                if (ret != null) {
                    long waitUntil = System.currentTimeMillis() + (long)timeoutms;
                    while (!cesSolverJob.getJob().isSolved()) {
                        final long rest = waitUntil - System.currentTimeMillis();
                        Thread.sleep(1000L);
                        new EDTRunner(){

                            protected void runInEDT() {
                                ret.update(rest);
                            }
                        }.waitForEDT();
                        if (rest > 0L) continue;
                        return ret;
                    }
                }
            }
            catch (InterruptedException e) {
                this.hide(ret);
                throw e;
            }
            return ret;
        }
        return null;
    }

    public void hide(CESBubble bubble) {
        if (bubble != null) {
            bubble.hideBubble(5000);
        }
    }
}

