/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify.downloads;

import java.io.File;
import javax.swing.JComponent;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.controlling.proxy.NoProxySelector;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.gui.notify.AbstractBubbleContentPanel;
import org.jdownloader.gui.notify.gui.CFG_BUBBLE;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class DownloadStartedContentPanel
extends AbstractBubbleContentPanel {
    protected SingleDownloadController downloadController;
    private AbstractBubbleContentPanel.Pair filename;
    private AbstractBubbleContentPanel.Pair hoster;
    private AbstractBubbleContentPanel.Pair saveTo;
    private AbstractBubbleContentPanel.Pair proxy;
    private AbstractBubbleContentPanel.Pair account;

    public DownloadStartedContentPanel(SingleDownloadController downloadController) {
        this.downloadController = downloadController;
        this.layoutComponents();
        SwingUtils.setOpaque((JComponent)((Object)this), (boolean)false);
    }

    protected void layoutComponents() {
        DownloadLink downloadLink = this.downloadController.getDownloadLink();
        Account account = this.downloadController.getAccount();
        if (CFG_BUBBLE.DOWNLOAD_STARTED_BUBBLE_CONTENT_FILENAME_VISIBLE.isEnabled()) {
            this.filename = this.addPair(this.filename, _GUI.T.lit_filename() + ":", downloadLink.getLinkInfo().getIcon());
            this.filename.setText(new File(downloadLink.getFileOutput()).getName());
        }
        if (CFG_BUBBLE.DOWNLOAD_STARTED_BUBBLE_CONTENT_HOSTER_VISIBLE.isEnabled() && (account == null || account.isMultiHost())) {
            this.hoster = this.addPair(this.hoster, _GUI.T.lit_hoster() + ":", downloadLink.getDomainInfo().getFavIcon());
            this.hoster.setText(downloadLink.getDomainInfo().getTld());
        }
        if (CFG_BUBBLE.DOWNLOAD_STARTED_BUBBLE_CONTENT_ACCOUNT_VISIBLE.isEnabled() && account != null) {
            this.account = this.addPair(this.account, _GUI.T.lit_account() + ":", account.getDomainInfo().getFavIcon());
            this.account.setText(account.getUser() + (CFG_GUI.SHOW_FULL_HOSTNAME.isEnabled() ? "@" + account.getHoster() : ""));
        }
        AbstractProxySelectorImpl proxy = this.downloadController.getDownloadLinkCandidate().getProxySelector();
        if (CFG_BUBBLE.DOWNLOAD_STARTED_BUBBLE_CONTENT_PROXY_VISIBLE.isEnabled() && proxy != null && !(proxy instanceof NoProxySelector)) {
            this.proxy = this.addPair(this.proxy, _GUI.T.lit_proxy() + ":", new AbstractIcon("proxy", 18));
            this.proxy.setText(proxy.toString());
        }
        if (CFG_BUBBLE.DOWNLOAD_STARTED_BUBBLE_CONTENT_SAVE_TO_VISIBLE.isEnabled()) {
            this.saveTo = this.addPair(this.saveTo, _GUI.T.lit_save_to() + ":", new AbstractIcon("folder", 18));
            this.saveTo.setText(new File(downloadLink.getFileOutput()).getParent());
        }
    }

    public void onClicked() {
        CrossSystem.showInExplorer((File)new File(this.downloadController.getDownloadLink().getFileOutput()));
    }

    @Override
    public void updateLayout() {
        this.removeAll();
        this.layoutComponents();
        this.revalidate();
        this.repaint();
    }
}

