/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify.downloads;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadSession;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogJob;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.event.DownloadWatchdogListener;
import org.appwork.storage.config.WeakHashSet;
import org.jdownloader.gui.notify.AbstractBubbleSupport;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.notify.Element;
import org.jdownloader.gui.notify.downloads.DownloadStartedNotify;
import org.jdownloader.gui.notify.downloads.DownloadStoppedNotify;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;
import org.jdownloader.gui.notify.gui.CFG_BUBBLE;
import org.jdownloader.gui.translate._GUI;

public class StartDownloadsBubbleSupport
extends AbstractBubbleSupport
implements DownloadWatchdogListener {
    private ArrayList<Element> elements;
    private final WeakHashMap<SingleDownloadController, QueuedStart> queue = new WeakHashMap();
    private volatile Thread queueWorker = null;
    private final WeakHashSet<SingleDownloadController> started = new WeakHashSet();

    public StartDownloadsBubbleSupport() {
        super(_GUI.T.plugins_optional_JDLightTray_ballon_startstopdownloads2(), CFG_BUBBLE.BUBBLE_NOTIFY_START_STOP_DOWNLOADS_ENABLED);
        this.elements = new ArrayList();
        this.elements.add(new Element(CFG_BUBBLE.DOWNLOAD_STARTED_BUBBLE_CONTENT_FILENAME_VISIBLE, _GUI.T.lit_filename(), "file"));
        this.elements.add(new Element(CFG_BUBBLE.DOWNLOAD_STARTED_BUBBLE_CONTENT_HOSTER_VISIBLE, _GUI.T.lit_hoster(), "download"));
        this.elements.add(new Element(CFG_BUBBLE.DOWNLOAD_STARTED_BUBBLE_CONTENT_ACCOUNT_VISIBLE, _GUI.T.lit_account(), "premium"));
        this.elements.add(new Element(CFG_BUBBLE.DOWNLOAD_STARTED_BUBBLE_CONTENT_PROXY_VISIBLE, _GUI.T.lit_proxy(), "proxy"));
        this.elements.add(new Element(CFG_BUBBLE.DOWNLOAD_STARTED_BUBBLE_CONTENT_SAVE_TO_VISIBLE, _GUI.T.lit_save_to(), "folder"));
        this.elements.add(new Element(CFG_BUBBLE.DOWNLOAD_STARTED_BUBBLE_CONTENT_STATUS_VISIBLE, _GUI.T.lit_status(), "media-playback-start"));
        DownloadWatchDog.getInstance().getEventSender().addListener(this, true);
    }

    @Override
    public List<Element> getElements() {
        return this.elements;
    }

    @Override
    public synchronized void onDownloadControllerStart(SingleDownloadController downloadController, DownloadLinkCandidate candidate) {
        if (!this.isEnabled()) {
            this.started.clear();
            this.queue.clear();
        } else {
            this.queue.put(downloadController, new QueuedStart(downloadController));
            Thread thread = this.queueWorker;
            if (thread == null || !thread.isAlive()) {
                thread = new Thread("BubbleNotifyDelayerQUeue"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        while (true) {
                            StartDownloadsBubbleSupport startDownloadsBubbleSupport;
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                startDownloadsBubbleSupport = StartDownloadsBubbleSupport.this;
                                // MONITORENTER : startDownloadsBubbleSupport
                                StartDownloadsBubbleSupport.this.started.clear();
                                StartDownloadsBubbleSupport.this.queue.clear();
                                StartDownloadsBubbleSupport.this.queueWorker = null;
                                // MONITOREXIT : startDownloadsBubbleSupport
                                startDownloadsBubbleSupport = StartDownloadsBubbleSupport.this;
                                // MONITORENTER : startDownloadsBubbleSupport
                                StartDownloadsBubbleSupport.this.queueWorker = null;
                                // MONITOREXIT : startDownloadsBubbleSupport
                                return;
                            }
                            StartDownloadsBubbleSupport startDownloadsBubbleSupport2 = StartDownloadsBubbleSupport.this;
                            // MONITORENTER : startDownloadsBubbleSupport2
                            Iterator it = StartDownloadsBubbleSupport.this.queue.values().iterator();
                            while (it.hasNext()) {
                                QueuedStart next = (QueuedStart)it.next();
                                if (next == null) continue;
                                final SingleDownloadController controller = next.controller;
                                if (!controller.isActive()) {
                                    it.remove();
                                    continue;
                                }
                                if (System.currentTimeMillis() - next.time <= CFG_BUBBLE.CFG.getDownloadStartEndNotifyDelay()) continue;
                                it.remove();
                                DownloadWatchDog.getInstance().enqueueJob(new DownloadWatchDogJob(){

                                    @Override
                                    public void interrupt() {
                                    }

                                    @Override
                                    public void execute(DownloadSession currentSession) {
                                        if (controller.isActive()) {
                                            StartDownloadsBubbleSupport.this.show(new BubbleNotify.AbstractNotifyWindowFactory(){

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public AbstractNotifyWindow<?> buildAbstractNotifyWindow() {
                                                    if (controller.isActive()) {
                                                        StartDownloadsBubbleSupport startDownloadsBubbleSupport = StartDownloadsBubbleSupport.this;
                                                        synchronized (startDownloadsBubbleSupport) {
                                                            StartDownloadsBubbleSupport.this.started.add((Object)controller);
                                                        }
                                                        return new DownloadStartedNotify(StartDownloadsBubbleSupport.this, controller);
                                                    }
                                                    return null;
                                                }
                                            });
                                        }
                                    }

                                    @Override
                                    public boolean isHighPriority() {
                                        return false;
                                    }
                                });
                            }
                            if (StartDownloadsBubbleSupport.this.queue.size() != 0) break block20;
                            StartDownloadsBubbleSupport.this.queueWorker = null;
                            // MONITOREXIT : startDownloadsBubbleSupport2
                            startDownloadsBubbleSupport = StartDownloadsBubbleSupport.this;
                            break;
                        }
                        catch (Throwable throwable) {
                            StartDownloadsBubbleSupport startDownloadsBubbleSupport = StartDownloadsBubbleSupport.this;
                            // MONITORENTER : startDownloadsBubbleSupport
                            StartDownloadsBubbleSupport.this.queueWorker = null;
                            // MONITOREXIT : startDownloadsBubbleSupport
                            throw throwable;
                        }
                        {
                            block20: {
                                // MONITORENTER : startDownloadsBubbleSupport
                                StartDownloadsBubbleSupport.this.queueWorker = null;
                                // MONITOREXIT : startDownloadsBubbleSupport
                                return;
                            }
                            // MONITOREXIT : startDownloadsBubbleSupport2
                            continue;
                        }
                    }
                };
                thread.setDaemon(true);
                thread.start();
                this.queueWorker = thread;
            }
        }
    }

    @Override
    public synchronized void onDownloadControllerStopped(final SingleDownloadController downloadController, DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
        if (!this.isEnabled()) {
            this.started.clear();
            this.queue.clear();
        } else if (this.started.remove((Object)downloadController)) {
            this.show(new BubbleNotify.AbstractNotifyWindowFactory(){

                @Override
                public AbstractNotifyWindow<?> buildAbstractNotifyWindow() {
                    return new DownloadStoppedNotify(StartDownloadsBubbleSupport.this, downloadController);
                }
            });
        }
    }

    @Override
    public void onDownloadWatchdogDataUpdate() {
    }

    @Override
    public void onDownloadWatchdogStateIsIdle() {
    }

    @Override
    public void onDownloadWatchdogStateIsPause() {
    }

    @Override
    public void onDownloadWatchdogStateIsRunning() {
    }

    @Override
    public void onDownloadWatchdogStateIsStopped() {
    }

    @Override
    public void onDownloadWatchdogStateIsStopping() {
    }

    @Override
    public void onDownloadWatchDogPropertyChange(DownloadWatchDogProperty propertyChange) {
    }

    private class QueuedStart {
        private final SingleDownloadController controller;
        private final long time;

        public QueuedStart(SingleDownloadController downloadController) {
            this.controller = downloadController;
            this.time = System.currentTimeMillis();
        }
    }
}

