/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify.gui;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.Timer;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.interfaces.View;
import jd.gui.swing.jdgui.views.settings.ConfigurationView;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.ExtJWindow;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.utils.ColorUtils;
import org.appwork.utils.DebugMode;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.Time;
import org.appwork.utils.images.TransparentIcon;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.contextmenu.gui.ExtPopupMenu;
import org.jdownloader.gui.jdtrayicon.ScreenStack;
import org.jdownloader.gui.notify.AbstractBubbleContentPanel;
import org.jdownloader.gui.notify.AbstractBubbleSupport;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.notify.Element;
import org.jdownloader.gui.notify.gui.Balloner;
import org.jdownloader.gui.notify.gui.BubbleNotifyConfigPanel;
import org.jdownloader.gui.notify.gui.CFG_BUBBLE;
import org.jdownloader.gui.notify.gui.Fader;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.ExtRealCheckBoxMenuItem;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.updatev2.gui.LAFOptions;

public abstract class AbstractNotifyWindow<T extends AbstractBubbleContentPanel>
extends ExtJWindow
implements ActionListener,
AWTEventListener,
GenericConfigEventListener<Boolean> {
    private static final int BOTTOM_MARGIN = 5;
    private static final int TOP_MARGIN = 20;
    private MigPanel content;
    private Timer timer;
    private Fader fader;
    private ScreenStack screenStack;
    private Point endLocation;
    private int timeout = 15000;
    private Point startLocation;
    private int round = 10;
    private Balloner controller;
    private T contentComponent;
    private long endTime = 0L;
    private boolean mouseOver;
    private Rectangle bounds;
    private boolean disposed;
    private boolean closed;
    private JLabel headerLbl;
    private AbstractBubbleSupport bubbleSupport;
    private Color highlightColor;
    private static Boolean getWindowOpacitySupported = null;
    private static Boolean setWindowOpacitySupported = null;

    public Point getEndLocation() {
        return this.endLocation;
    }

    public AbstractNotifyWindow(String caption, T comp) {
        this(null, caption, comp);
    }

    public AbstractNotifyWindow(AbstractBubbleSupport bubbleSupport, String caption, T comp) {
        List<Element> elements;
        this.bubbleSupport = bubbleSupport;
        if (JVMVersion.isMinimum((long)JVMVersion.JAVA_1_7)) {
            this.setType(Window.Type.POPUP);
        }
        this.bounds = new Rectangle();
        this.content = new MigPanel("ins 2 5 10 5,wrap 1", "[grow,fill]", "[][grow,fill]"){

            public void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                int width = this.getWidth();
                int height = this.getHeight();
                BufferedImage img = AbstractNotifyWindow.this.getSoftClipWorkaroundImage(g2d, width, height);
                g2d.drawImage((Image)img, 0, 0, null);
                g2d.dispose();
            }
        };
        ((AbstractBubbleContentPanel)((Object)comp)).setWindow(this);
        this.setContentPane((Container)this.content);
        this.content.add(this.createHeader(caption));
        this.contentComponent = comp;
        this.content.add(comp);
        this.pack();
        this.round = 0;
        try {
            if (!AbstractNotifyWindow.setWindowOpaque((Window)((Object)this))) {
                this.round = 10;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        AbstractNotifyWindow.setWindowOpacity((Window)((Object)this), 0.0f);
        this.fader = new Fader(this);
        this.setTimeout((Integer)CFG_BUBBLE.DEFAULT_TIMEOUT.getValue());
        if (bubbleSupport != null && (elements = bubbleSupport.getElements()) != null) {
            for (Element e : elements) {
                e.getKeyhandler().getEventSender().addListener((EventListener)this, true);
            }
        }
    }

    public AbstractBubbleSupport getBubbleSupport() {
        return this.bubbleSupport;
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        new EDTRunner(){

            protected void runInEDT() {
                AbstractNotifyWindow.this.updateLayout();
            }
        };
    }

    protected void updateLayout() {
        ((AbstractBubbleContentPanel)((Object)this.getContentComponent())).updateLayout();
        this.pack();
        BubbleNotify.getInstance().relayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            List<Element> elements;
            this.disposed = true;
            this.closed = true;
            AbstractBubbleSupport bubbleSupport = this.bubbleSupport;
            if (bubbleSupport != null && (elements = bubbleSupport.getElements()) != null) {
                for (Element e : elements) {
                    e.getKeyhandler().getEventSender().removeListener((EventListener)this);
                }
            }
        }
        finally {
            super.dispose();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public T getContentComponent() {
        return this.contentComponent;
    }

    public static boolean setWindowOpaque(Window owner) {
        try {
            boolean opaque = false;
            Color bg = owner.getBackground();
            if (bg == null) {
                bg = new Color(0, 0, 0, 0);
            }
            owner.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 0));
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Float getWindowOpacity(Window owner) {
        if (Boolean.FALSE.equals(getWindowOpacitySupported) || owner == null) {
            return null;
        }
        try {
            Float ret = JVMVersion.isMinimum((long)JVMVersion.JAVA_1_7) ? Float.valueOf(owner.getOpacity()) : (Float)ReflectionUtils.invoke((String)"com.sun.awt.AWTUtilities", (String)"getWindowOpacity", null, Float.TYPE, (Object[])new Object[]{owner});
            getWindowOpacitySupported = Boolean.TRUE;
            return ret;
        }
        catch (Throwable e) {
            e.printStackTrace();
            getWindowOpacitySupported = Boolean.FALSE;
            return null;
        }
    }

    public static void setWindowOpacity(Window window, float opacity) {
        if (Boolean.FALSE.equals(setWindowOpacitySupported)) {
            return;
        }
        try {
            if (JVMVersion.isMinimum((long)JVMVersion.JAVA_1_7)) {
                if (setWindowOpacitySupported == null) {
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice gd = ge.getDefaultScreenDevice();
                    setWindowOpacitySupported = gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT);
                }
                if (Boolean.TRUE.equals(setWindowOpacitySupported)) {
                    window.setOpacity(opacity);
                    return;
                }
            } else if (setWindowOpacitySupported == null || Boolean.TRUE.equals(setWindowOpacitySupported)) {
                ReflectionUtils.invoke((String)"com.sun.awt.AWTUtilities", (String)"setWindowOpacity", null, Void.TYPE, (Object[])new Object[]{window, Float.valueOf(opacity)});
                return;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            setWindowOpacitySupported = Boolean.FALSE;
        }
    }

    @Override
    public void eventDispatched(AWTEvent e) {
        try {
            if (e instanceof MouseEvent) {
                MouseEvent m = (MouseEvent)e;
                if (!this.mouseOver && m.getID() == 504) {
                    if (this.isMouseOver(m.getLocationOnScreen(), (Component)((Object)this))) {
                        this.mouseOver = true;
                        this.onMouseEntered(m);
                        return;
                    }
                } else if (this.mouseOver && m.getID() == 505) {
                    if (!this.isMouseOver(m.getLocationOnScreen(), (Component)((Object)this))) {
                        this.mouseOver = false;
                        this.onMouseExited(m);
                        return;
                    }
                } else if (m.getID() == 500 && this.isMouseOver(m.getLocationOnScreen(), (Component)this.contentComponent)) {
                    this.onMouseClicked(m);
                    return;
                }
            }
        }
        catch (Throwable e1) {
            LoggerFactory.getDefaultLogger().log(e1);
        }
    }

    protected void onMouseClicked(MouseEvent m) {
    }

    protected boolean isMouseOver(Point loc, Component comp) {
        try {
            comp.getBounds(this.bounds);
            Point los = comp.getLocationOnScreen();
            this.bounds.x = los.x;
            this.bounds.y = los.y;
            return loc.x >= this.bounds.x && loc.x <= this.bounds.x + this.bounds.width && loc.y >= this.bounds.y && loc.y <= this.bounds.y + this.bounds.height;
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
            return false;
        }
    }

    protected void onMouseExited(MouseEvent m) {
        Timer timer = this.timer;
        if (this.endTime > 0L && timer == null) {
            timer = new Timer((int)Math.max(2000L, this.endTime - Time.systemIndependentCurrentJVMTimeMillis()), this);
            timer.setRepeats(false);
            this.timer = timer;
            timer.start();
        }
    }

    private void onMouseEntered(MouseEvent e) {
        Timer timer = this.timer;
        if (timer != null) {
            timer.stop();
            this.timer = null;
        }
    }

    public void setVisible(boolean b) {
        if (b == this.isVisible()) {
            return;
        }
        try {
            super.setVisible(b);
        }
        finally {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        if (b) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
            this.fader.fadeIn(this.getFadeSpeed());
        } else {
            Timer timer = this.timer;
            if (timer != null) {
                timer.stop();
                this.timer = null;
            }
            this.dispose();
        }
        if (b && this.getTimeout() > 0) {
            int to = this.getTimeout();
            this.startTimeout(to);
        }
    }

    protected void startTimeout(int to) {
        Timer timer = this.timer;
        if (timer != null) {
            timer.stop();
        }
        this.endTime = Time.systemIndependentCurrentJVMTimeMillis() + (long)to;
        if (to <= 0) {
            this.onClose();
        } else {
            timer = new Timer(to, this);
            timer.setRepeats(false);
            this.timer = timer;
            timer.start();
        }
    }

    protected int getFadeSpeed() {
        return (Integer)CFG_BUBBLE.FADE_ANIMATION_DURATION.getValue();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Timer timer = this.timer;
        if (timer != null) {
            timer.stop();
            this.timer = null;
        }
        this.onClose();
    }

    protected int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setHeaderText(final String txt) {
        new EDTRunner(){

            protected void runInEDT() {
                AbstractNotifyWindow.this.headerLbl.setText(txt);
            }
        };
    }

    private Component createHeader(String caption) {
        MigPanel ret = new MigPanel("ins 0", "[grow,fill][][]", "[]");
        this.headerLbl = new JLabel(caption);
        this.headerLbl.setForeground(ColorUtils.getAlphaInstance((Color)this.headerLbl.getForeground(), (int)160));
        this.headerLbl.setHorizontalAlignment(2);
        ret.add((Component)SwingUtils.toBold((JLabel)this.headerLbl));
        SwingUtils.setOpaque((JComponent)ret, (boolean)false);
        SwingUtils.setOpaque((JComponent)this.headerLbl, (boolean)false);
        ExtButton settings = new ExtButton(){
            private final AbstractIcon icon = new AbstractIcon("wrench", 10);
            private static final long serialVersionUID = 1L;
            {
                this.setToolTipText(_GUI.T.Notify_createHeader_settings_tt());
                this.setRolloverEffectEnabled(true);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractNotifyWindow.this.onSettings(e);
                        this.onRollOut();
                    }
                });
            }

            protected void onRollOut() {
                this.setContentAreaFilled(false);
                this.setIcon((Icon)new TransparentIcon((Icon)this.icon, 0.5f));
            }

            protected void onRollOver() {
                this.setIcon(this.icon);
            }
        };
        ret.add((Component)settings, (Object)"width 10!,height 10!");
        ExtButton closeButton = new ExtButton(){
            private final AbstractIcon icon = new AbstractIcon("close", 10);
            private static final long serialVersionUID = 1L;
            {
                this.setToolTipText(_GUI.T.Notify_createHeader_close_tt());
                this.setRolloverEffectEnabled(true);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractNotifyWindow.this.onClose();
                        this.onRollOut();
                    }
                });
            }

            protected void onRollOut() {
                this.setContentAreaFilled(false);
                this.setIcon((Icon)new TransparentIcon((Icon)this.icon, 0.5f));
            }

            protected void onRollOver() {
                this.setIcon(this.icon);
            }
        };
        ret.add((Component)closeButton, (Object)"width 10!,height 10!");
        SwingUtils.setOpaque((JComponent)ret, (boolean)false);
        SwingUtils.setOpaque((JComponent)this.headerLbl, (boolean)false);
        SwingUtils.setOpaque((JComponent)closeButton, (boolean)false);
        return ret;
    }

    protected void onSettings(ActionEvent action) {
        final AbstractBubbleSupport support = this.getBubbleSupport();
        if (support != null) {
            ExtPopupMenu popup = new ExtPopupMenu();
            List<Element> elements = support.getElements();
            if (elements != null) {
                for (final Element e : elements) {
                    ExtRealCheckBoxMenuItem item = new ExtRealCheckBoxMenuItem((AbstractAction)((Object)new AppAction(){
                        {
                            this.setName(e.getLabel());
                            this.setIconKey(e.getIcon());
                            this.setSelected(e.getKeyhandler().isEnabled());
                        }

                        public void actionPerformed(ActionEvent e1) {
                            e.getKeyhandler().toggle();
                        }
                    }));
                    popup.add(item);
                    item.setHideOnClick(false);
                }
            }
            popup.add(new JSeparator());
            popup.add((Action)((Object)new AppAction(){
                {
                    this.setName(_GUI.T.bubble_hide_permanent());
                    this.setIconKey("false");
                }

                public void actionPerformed(ActionEvent e) {
                    try {
                        Dialog.getInstance().showConfirmDialog(0, _GUI.T.lit_are_you_sure(), _GUI.T.bubble_disable_rly_msg(support.getLabel()), NewTheme.I().getIcon("question", 32), null, null);
                        support.getKeyHandler().setValue((Object)false);
                        AbstractNotifyWindow.this.hideBubble(AbstractNotifyWindow.this.getTimeout());
                    }
                    catch (DialogClosedException e1) {
                        e1.printStackTrace();
                    }
                    catch (DialogCanceledException e1) {
                        e1.printStackTrace();
                    }
                }
            }));
            popup.add(new JSeparator());
            popup.add((Action)((Object)new AppAction(){
                {
                    this.setName(_GUI.T.bubblepopup_open_settings());
                    this.setIconKey("settings");
                }

                public void actionPerformed(ActionEvent e) {
                    JDGui.getInstance().setFrameState(WindowManager.FrameState.TO_FRONT_FOCUSED);
                    ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setConfigViewVisible(true);
                    JDGui.getInstance().setContent((View)ConfigurationView.getInstance(), true);
                    ConfigurationView.getInstance().setSelectedSubPanel(BubbleNotifyConfigPanel.class);
                }
            }));
            Component source = (Component)action.getSource();
            popup.show(source, 0, -popup.getPreferredSize().height);
            return;
        }
        JDGui.getInstance().setFrameState(WindowManager.FrameState.TO_FRONT_FOCUSED);
        ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setConfigViewVisible(true);
        JDGui.getInstance().setContent((View)ConfigurationView.getInstance(), true);
        ConfigurationView.getInstance().setSelectedSubPanel(BubbleNotifyConfigPanel.class);
    }

    public void hideBubble(int timeout) {
        this.startTimeout(timeout);
        ((AbstractBubbleContentPanel)((Object)this.getContentComponent())).stop();
    }

    protected void onClose() {
        this.closed = true;
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.fader.fadeOut(this.getFadeSpeed());
        if (this.endLocation != null) {
            this.fader.moveTo(this.endLocation.x, this.endLocation.y, this.getFadeSpeed());
        }
        if (this.controller != null) {
            this.controller.remove(this);
        }
        Timer disposeTimer = new Timer(2000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractNotifyWindow.this.dispose();
            }
        });
        disposeTimer.setRepeats(false);
        disposeTimer.start();
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
        this.repaint();
    }

    protected BufferedImage getSoftClipWorkaroundImage(Graphics2D g2d, int width, int height) {
        GraphicsConfiguration gc = g2d.getDeviceConfiguration();
        BufferedImage img = gc.createCompatibleImage(width, height, 3);
        Graphics2D g2 = img.createGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, width, height);
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.round, this.round);
        g2.setComposite(AlphaComposite.SrcAtop);
        try {
            GradientPaint p = null;
            if (this.highlightColor == null) {
                p = new GradientPaint(0.0f, 0.0f, LAFOptions.getInstance().getColorForPanelHeaderBackground(), 0.0f, 20.0f, LAFOptions.getInstance().getColorForScrollbarsMouseOverState());
                g2.setPaint(p);
            } else {
                p = new GradientPaint(0.0f, 0.0f, this.highlightColor, 0.0f, 20.0f, this.highlightColor.brighter());
                g2.setPaint(p);
            }
            g2.fillRoundRect(0, 0, width, height, this.round, this.round);
            p = new GradientPaint(0.0f, 0.0f, LAFOptions.getInstance().getColorForPanelBackground(), 0.0f, 20.0f, LAFOptions.getInstance().getColorForPanelBackground().brighter());
            g2.setPaint(p);
            g2.fillRect(0, 20, width, height - 20 - 5);
            g2.setColor(LAFOptions.getInstance().getColorForPanelBorders());
            g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.round, this.round);
        }
        catch (NullPointerException e) {
            LogV3.log((Throwable)e);
            LogV3.warning((String)"Colors Missing?");
            DebugMode.debugger();
        }
        g2.dispose();
        return img;
    }

    public void setPreferedLocation(int x, int y) {
        this.fader.moveTo(x, y, this.getFadeSpeed());
    }

    public void setScreenStack(ScreenStack screenStack) {
        this.screenStack = screenStack;
    }

    public ScreenStack getScreenStack() {
        return this.screenStack;
    }

    public void setEndLocation(Point p) {
        this.endLocation = p;
    }

    public void setStartLocation(Point point) {
        if (this.startLocation == null) {
            this.setLocation(point);
            this.startLocation = point;
        }
    }

    public Point getStartLocation() {
        return this.startLocation;
    }

    public void setController(Balloner balloner) {
        this.controller = balloner;
    }

    public float getFinalTransparency() {
        return (float)CFG_BUBBLE.CFG.getTransparency() / 100.0f;
    }

    public void setHighlightColor(Object object) {
    }
}

