/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify.gui;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import jd.gui.swing.jdgui.views.settings.components.Checkbox;
import jd.gui.swing.jdgui.views.settings.components.ComboBox;
import jd.gui.swing.jdgui.views.settings.components.Spinner;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateListener;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.notify.AbstractBubbleSupport;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.notify.gui.BubbleNotifyConfig;
import org.jdownloader.gui.notify.gui.CFG_BUBBLE;
import org.jdownloader.gui.settings.AbstractConfigPanel;
import org.jdownloader.gui.settings.Pair;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;

public class BubbleNotifyConfigPanel
extends AbstractConfigPanel
implements StateUpdateListener,
GenericConfigEventListener<Enum> {
    private static final long serialVersionUID = 1L;
    private ArrayList<Pair<Checkbox>> boxes;
    private DelayedRunnable delayer;

    @Override
    public String getTitle() {
        return _GUI.T.NotifierConfigPanel_getTitle();
    }

    public BubbleNotifyConfigPanel() {
        this.layoutComponents();
        CFG_BUBBLE.BUBBLE_NOTIFY_ENABLED_STATE.getEventSender().addListener((EventListener)((Object)this), true);
        this.onConfigValueModified(null, null);
        this.delayer = new DelayedRunnable(3000L, 5000L){

            public void delayedrun() {
                new EDTRunner(){

                    protected void runInEDT() {
                        BubbleNotifyConfigPanel.this.removeAll();
                        BubbleNotifyConfigPanel.this.layoutComponents();
                        BubbleNotifyConfigPanel.this.revalidate();
                        BubbleNotifyConfigPanel.this.repaint();
                    }
                };
            }
        };
    }

    protected void layoutComponents() {
        this.addHeader(this.getTitle(), NewTheme.I().getIcon("bubble", 32));
        this.addDescription(_GUI.T.plugins_optional_JDLightTray_ballon_desc());
        this.addPair(_GUI.T.BubbleNotifyConfigPanel_BubbleNotifyConfigPanel_enabledstate(), null, new ComboBox(CFG_BUBBLE.SH.getKeyHandler("BubbleNotifyEnabledState", KeyHandler.class), (Object[])new BubbleNotifyConfig.BubbleNotifyEnabledState[]{BubbleNotifyConfig.BubbleNotifyEnabledState.ALWAYS, BubbleNotifyConfig.BubbleNotifyEnabledState.JD_NOT_ACTIVE, BubbleNotifyConfig.BubbleNotifyEnabledState.JD_ACTIVE, BubbleNotifyConfig.BubbleNotifyEnabledState.TRAY_OR_TASKBAR, BubbleNotifyConfig.BubbleNotifyEnabledState.TASKBAR, BubbleNotifyConfig.BubbleNotifyEnabledState.TRAY, BubbleNotifyConfig.BubbleNotifyEnabledState.NEVER}, new String[]{_GUI.T.BubbleNotifyConfigPanel_BubbleNotifyConfigPanel_always(), _GUI.T.BubbleNotifyConfigPanel_BubbleNotifyConfigPanel_jdnotactive(), _GUI.T.BubbleNotifyConfigPanel_BubbleNotifyConfigPanel_jdactive(), _GUI.T.BubbleNotifyConfigPanel_BubbleNotifyConfigPanel_trayortask(), _GUI.T.BubbleNotifyConfigPanel_BubbleNotifyConfigPanel_taskbar(), _GUI.T.BubbleNotifyConfigPanel_BubbleNotifyConfigPanel_tray(), _GUI.T.BubbleNotifyConfigPanel_BubbleNotifyConfigPanel_never()}));
        this.boxes = new ArrayList();
        for (AbstractBubbleSupport pt : BubbleNotify.getInstance().getTypes()) {
            this.boxes.add(this.addPair(_GUI.T.lit_and() + " " + pt.getLabel(), "skip 1,split 2,pushx,growx", null, new Checkbox(pt.getKeyHandler(), new JComponent[0])));
        }
        this.addHeader(_GUI.T.BubbleNotifyConfigPanel_BubbleNotifyConfigPanel_settings_(), new AbstractIcon("settings", 32));
        this.addPair(_GUI.T.BubbleNotifyConfigPanel_BubbleNotifyConfigPanel_silent_(), null, new Checkbox(CFG_BUBBLE.BUBBLE_NOTIFY_ENABLED_DURING_SILENT_MODE, new JComponent[0]));
        this.addPair(_GUI.T.BubbleNotifyConfigPanel_BubbleNotifyConfigPanel_timeout(), null, new Spinner(CFG_BUBBLE.DEFAULT_TIMEOUT));
        this.addPair(_GUI.T.BubbleNotifyConfigPanel_BubbleNotifyConfigPanel_timeout_links_notification(), null, new Spinner(CFG_BUBBLE.BUBBLE_NOTIFY_ON_NEW_LINKGRABBER_LINKS_END_NOTIFY_DELAY));
        this.addPair(_GUI.T.BubbleNotifyConfigPanel_BubbleNotifyConfigPanel_fadetime(), null, new Spinner(CFG_BUBBLE.FADE_ANIMATION_DURATION));
    }

    public void updateTypes(List<AbstractBubbleSupport> types) {
    }

    @Override
    public Icon getIcon() {
        return NewTheme.I().getIcon("bubble", 32);
    }

    @Override
    public void save() {
    }

    @Override
    public void updateContents() {
    }

    public void onStateUpdated() {
        this.delayer.resetAndStart();
    }

    public void onConfigValidatorError(KeyHandler<Enum> keyHandler, Enum invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Enum> keyHandler, Enum newValue) {
        new EDTRunner(){

            protected void runInEDT() {
                for (Pair pc : BubbleNotifyConfigPanel.this.boxes) {
                    pc.setEnabled(CFG_BUBBLE.BUBBLE_NOTIFY_ENABLED_STATE.getValue() != BubbleNotifyConfig.BubbleNotifyEnabledState.NEVER);
                }
            }
        };
    }
}

