/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify.gui;

import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;

public class Fader
implements ActionListener {
    private static final int FPS = 25;
    private AbstractNotifyWindow owner;
    private Timer faderTimer;
    private long start;
    private long end;
    private Point destLocation;
    private float destAlpha;
    private float srcAlpha;
    private Point srcLocation;

    public Fader(AbstractNotifyWindow notify) {
        this.owner = notify;
    }

    public static double getValue(double t) {
        return 6.0 * t * t * t * t * t + -15.0 * t * t * t * t + 10.0 * t * t * t;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        long timedif = System.currentTimeMillis() - this.start;
        if (timedif > this.end - this.start || this.owner.isDisposed() || this.owner.isClosed()) {
            this.stop();
            return;
        }
        double percent = (double)timedif / (double)(this.end - this.start);
        double factor = Fader.getValue(percent);
        float alpha = (float)((double)this.srcAlpha + factor * (double)(this.destAlpha - this.srcAlpha));
        Point loc = new Point();
        loc.x = (int)((double)this.srcLocation.x + factor * (double)(this.destLocation.x - this.srcLocation.x));
        loc.y = (int)((double)this.srcLocation.y + factor * (double)(this.destLocation.y - this.srcLocation.y));
        this.owner.setLocation(loc);
        AbstractNotifyWindow.setWindowOpacity((Window)((Object)this.owner), alpha);
    }

    private void stop() {
        AbstractNotifyWindow.setWindowOpacity((Window)((Object)this.owner), this.destAlpha);
        this.owner.setVisible(this.destAlpha > 0.0f);
        this.srcAlpha = this.destAlpha;
        this.srcLocation = this.destLocation;
        if (this.destLocation != null) {
            this.owner.setLocation(this.destLocation);
        }
        if (this.faderTimer != null) {
            this.faderTimer.stop();
            this.faderTimer = null;
        }
    }

    public void moveTo(int x, int y, int time) {
        Point p = new Point(x, y);
        if (this.destLocation != null && this.destLocation.equals(p)) {
            return;
        }
        this.udpateLocation();
        this.updateAlpha();
        this.destLocation = p;
        if (this.destLocation.equals(this.srcLocation)) {
            return;
        }
        this.updateTimer(time);
        this.ensureFader();
    }

    protected void updateTimer(int time) {
        this.start = System.currentTimeMillis();
        this.end = this.start + (long)time;
    }

    protected void udpateLocation() {
        this.srcLocation = this.owner.getLocation();
    }

    public void fadeIn(int i) {
        if (this.destAlpha == this.owner.getFinalTransparency()) {
            return;
        }
        this.udpateLocation();
        this.updateAlpha();
        this.destAlpha = this.owner.getFinalTransparency();
        if (this.srcAlpha == this.destAlpha) {
            return;
        }
        this.updateTimer(i);
        this.ensureFader();
    }

    protected void updateAlpha() {
        try {
            Float ret = AbstractNotifyWindow.getWindowOpacity((Window)((Object)this.owner));
            if (ret == null) {
                ret = Float.valueOf(this.destAlpha);
            }
            this.srcAlpha = ret.floatValue();
        }
        catch (Throwable e1) {
            this.srcAlpha = this.destAlpha;
        }
    }

    protected void ensureFader() {
        if (this.faderTimer == null) {
            this.faderTimer = new Timer(40, this);
            this.faderTimer.setRepeats(true);
            this.faderTimer.start();
        }
    }

    public void fadeOut(int i) {
        if (this.destAlpha == 0.0f) {
            return;
        }
        this.updateAlpha();
        this.udpateLocation();
        this.destAlpha = 0.0f;
        if (this.srcAlpha == this.destAlpha) {
            return;
        }
        this.updateTimer(i);
        this.ensureFader();
    }
}

