/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify.linkcrawler;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkCollectorCrawler;
import jd.controlling.linkcollector.LinkOrigin;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.gui.swing.jdgui.components.IconedProcessIndicator;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.notify.AbstractBubbleContentPanel;
import org.jdownloader.gui.notify.Element;
import org.jdownloader.gui.notify.gui.BubbleNotifyConfig;
import org.jdownloader.gui.notify.gui.CFG_BUBBLE;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.updatev2.gui.LAFOptions;

public class LinkCrawlerBubbleContent
extends AbstractBubbleContentPanel {
    private AbstractBubbleContentPanel.Pair duration;
    private AbstractBubbleContentPanel.Pair links;
    private AbstractBubbleContentPanel.Pair offline;
    private AbstractBubbleContentPanel.Pair status;
    private AbstractBubbleContentPanel.Pair statusQueue;
    private AbstractBubbleContentPanel.Pair listQueue;
    private AbstractBubbleContentPanel.Pair packages;
    private AbstractBubbleContentPanel.Pair online;
    private final int CLOSETIMEOUT = ((BubbleNotifyConfig)JsonConfig.create(BubbleNotifyConfig.class)).getBubbleNotifyOnNewLinkgrabberLinksEndNotifyDelay();
    private final LinkOrigin origin;
    protected IconedProcessIndicator progressCircle = null;
    private int joblessCount = -1;
    private int offlineCount = -1;
    private int linksCount = -1;
    private int onlineCount = -1;
    private final AtomicLong lastChange = new AtomicLong(-1L);
    private int lastMaxStringLength = -1;

    public LinkCrawlerBubbleContent(LinkCollector.JobLinkCrawler crawler) {
        super("linkgrabber");
        this.origin = crawler.getJob().getOrigin().getOrigin();
        this.layoutComponents();
        if (this.offline != null) {
            this.offline.setVisible(false);
        }
    }

    @Override
    public void stop() {
        this.stopProgressCircle();
        super.stop();
    }

    protected void layoutComponents() {
        if (CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_ANIMATED_ICON_VISIBLE.isEnabled()) {
            this.setLayout((LayoutManager)new MigLayout("ins 3 3 0 3,wrap 3", "[][fill][grow,fill]", "[]"));
            this.progressCircle = this.createProgress("linkgrabber");
            String iconKey = "linkgrabber";
            if (this.origin != null) {
                switch (this.origin) {
                    case CLIPBOARD: {
                        iconKey = "clipboard";
                        break;
                    }
                    case ADD_CONTAINER_ACTION: 
                    case DOWNLOADED_CONTAINER: {
                        iconKey = "addContainer";
                        break;
                    }
                    case CNL: {
                        iconKey = "logo/cnl";
                        break;
                    }
                    case MYJD: {
                        iconKey = "logo/myjdownloader";
                        break;
                    }
                    case ADD_LINKS_DIALOG: 
                    case DRAG_DROP_ACTION: {
                        iconKey = "add";
                        break;
                    }
                    case EXTENSION: {
                        iconKey = "folder_add";
                        break;
                    }
                    default: {
                        iconKey = "linkgrabber";
                    }
                }
            }
            this.progressCircle.updatePainter(NewTheme.I().getIcon(iconKey, 20), Color.WHITE, Color.GRAY, Color.WHITE, Color.GREEN, Color.LIGHT_GRAY, Color.GREEN);
            this.add((Component)this.progressCircle, "width 32!,height 32!,pushx,growx,pushy,growy,spany,aligny top");
        } else {
            this.setLayout((LayoutManager)new MigLayout("ins 3 3 0 3,wrap 2", "[fill][grow,fill]", "[]"));
        }
        if (CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_DURATION_VISIBLE.isEnabled()) {
            this.duration = this.addPair(this.duration, _GUI.T.ReconnectDialog_layoutDialogContent_duration(), "wait");
        }
        if (CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_LINK_COUNT_VISIBLE.isEnabled()) {
            this.links = this.addPair(this.links, _GUI.T.LinkCrawlerBubbleContent_LinkCrawlerBubbleContent_foundlink(), "file");
        }
        if (CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_PACKAGE_COUNT_VISIBLE.isEnabled()) {
            this.packages = this.addPair(this.packages, _GUI.T.LinkCrawlerBubbleContent_LinkCrawlerBubbleContent_foundpackages(), "package_new");
        }
        if (CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_OFFLINE_COUNT_VISIBLE.isEnabled()) {
            this.offline = this.addPair(this.offline, _GUI.T.LinkCrawlerBubbleContent_LinkCrawlerBubbleContent_foundoffline(), "error");
        }
        if (CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_ONLINE_COUNT_VISIBLE.isEnabled()) {
            this.online = this.addPair(this.online, _GUI.T.LinkCrawlerBubbleContent_LinkCrawlerBubbleContent_foundonline(), "ok");
        }
        if (CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_CHECK_QUEUE_VISIBLE.isEnabled()) {
            this.statusQueue = this.addPair(this.statusQueue, _GUI.T.LinkCrawlerBubbleContent_LinkCrawlerBubbleContent_linkcheck_queue() + ":", "question");
        }
        if (CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_LIST_QUEUE_VISIBLE.isEnabled()) {
            this.listQueue = this.addPair(this.listQueue, _GUI.T.LinkCrawlerBubbleContent_LinkCrawlerBubbleContent_list_queue() + ":", "batch");
        }
        if (CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_STATUS_VISIBLE.isEnabled()) {
            this.status = this.addPair(this.status, _GUI.T.LinkCrawlerBubbleContent_LinkCrawlerBubbleContent_status(), "run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(final LinkCollector.JobLinkCrawler jlc) {
        long lastChange;
        List<CrawledLink> linklist = jlc.getCrawledLinks();
        final HashSet<CrawledPackage> dupe = new HashSet<CrawledPackage>();
        int offlineCnt = 0;
        int onlineCnt = 0;
        int jobless = 0;
        List<CrawledLink> list = linklist;
        synchronized (list) {
            for (CrawledLink cl : linklist) {
                CrawledPackage node = cl.getParentNode();
                if (node != null) {
                    dupe.add(node);
                }
                if (cl.getSourceJob() != jlc.getJob()) {
                    ++jobless;
                }
                switch (cl.getLinkState()) {
                    case OFFLINE: {
                        ++offlineCnt;
                        break;
                    }
                    case ONLINE: {
                        ++onlineCnt;
                    }
                }
            }
        }
        boolean changes = false;
        int linksCnt = jlc.getCrawledLinksFoundCounter();
        changes |= this.onlineCount != onlineCnt;
        changes |= this.offlineCount != offlineCnt;
        changes |= this.joblessCount != jobless;
        boolean bl = this.linksCount != linksCnt;
        this.offlineCount = offlineCnt;
        this.onlineCount = onlineCnt;
        this.joblessCount = jobless;
        this.linksCount = linksCnt;
        if (changes |= bl) {
            lastChange = System.currentTimeMillis();
            this.lastChange.set(lastChange);
        } else {
            lastChange = this.lastChange.get();
        }
        new EDTRunner(){

            protected void runInEDT() {
                String string;
                String string2;
                int maxStringLength = -1;
                if (LinkCrawlerBubbleContent.this.online != null) {
                    string2 = String.valueOf(LinkCrawlerBubbleContent.this.onlineCount);
                    LinkCrawlerBubbleContent.this.online.setText(string2);
                    maxStringLength = Math.max(maxStringLength, string2.length());
                }
                if (LinkCrawlerBubbleContent.this.offlineCount > 0) {
                    if (LinkCrawlerBubbleContent.this.offline != null) {
                        string2 = String.valueOf(LinkCrawlerBubbleContent.this.offlineCount);
                        LinkCrawlerBubbleContent.this.offline.setText(string2);
                        LinkCrawlerBubbleContent.this.offline.setVisible(true);
                        maxStringLength = Math.max(maxStringLength, string2.length());
                    }
                    if (LinkCrawlerBubbleContent.this.offlineCount >= LinkCrawlerBubbleContent.this.linksCount) {
                        LinkCrawlerBubbleContent.this.getWindow().setHighlightColor(LAFOptions.getInstance().getColorForErrorForeground());
                    } else {
                        LinkCrawlerBubbleContent.this.getWindow().setHighlightColor(LAFOptions.getInstance().getColorForTableSortedColumnView());
                    }
                } else {
                    LinkCrawlerBubbleContent.this.getWindow().setHighlightColor(null);
                }
                if (LinkCrawlerBubbleContent.this.links != null) {
                    string2 = String.valueOf(LinkCrawlerBubbleContent.this.linksCount);
                    LinkCrawlerBubbleContent.this.links.setText(string2);
                    maxStringLength = Math.max(maxStringLength, string2.length());
                }
                if (LinkCrawlerBubbleContent.this.packages != null) {
                    string2 = String.valueOf(dupe.size());
                    LinkCrawlerBubbleContent.this.packages.setText(string2);
                    maxStringLength = Math.max(maxStringLength, string2.length());
                }
                boolean isCollecting = jlc.isCollecting();
                long createdTime = jlc.getCreated();
                int listQueueSize = jlc.getQueueSize();
                if (LinkCrawlerBubbleContent.this.listQueue != null) {
                    String string3 = String.valueOf(listQueueSize);
                    LinkCrawlerBubbleContent.this.listQueue.setText(string3);
                    maxStringLength = Math.max(maxStringLength, string3.length());
                }
                long statusQueueSize = jlc.getLinkChecker().checksRequested();
                if (LinkCrawlerBubbleContent.this.statusQueue != null) {
                    string = String.valueOf(statusQueueSize);
                    LinkCrawlerBubbleContent.this.statusQueue.setText(string);
                    maxStringLength = Math.max(maxStringLength, string.length());
                }
                if (LinkCrawlerBubbleContent.this.status != null) {
                    string = jlc.isRunning() ? _GUI.T.LinkCrawlerBubbleContent_update_runnning() : (jlc.getLinkChecker().isRunning() ? _GUI.T.LinkCrawlerBubbleContent_update_online() : (listQueueSize > 0 ? _GUI.T.LinkCrawlerBubbleContent_update_processing() : _GUI.T.LinkCrawlerBubbleContent_update_finished()));
                    LinkCrawlerBubbleContent.this.status.setText(string);
                    maxStringLength = Math.max(maxStringLength, string.length());
                }
                if (LinkCrawlerBubbleContent.this.duration != null) {
                    string = isCollecting ? TimeFormatter.formatMilliSeconds((long)(System.currentTimeMillis() - createdTime), (int)0) : (lastChange == -1L ? TimeFormatter.formatMilliSeconds((long)(System.currentTimeMillis() - createdTime), (int)0) : TimeFormatter.formatMilliSeconds((long)(lastChange - createdTime), (int)0));
                    LinkCrawlerBubbleContent.this.duration.setText(string);
                    maxStringLength = Math.max(maxStringLength, string.length());
                }
                if (isCollecting) {
                    LinkCrawlerBubbleContent.this.startProgressCircle();
                } else {
                    LinkCrawlerBubbleContent.this.stopProgressCircle();
                }
                if (LinkCrawlerBubbleContent.this.lastMaxStringLength != maxStringLength) {
                    LinkCrawlerBubbleContent.this.lastMaxStringLength = maxStringLength;
                }
            }
        }.waitForEDT();
    }

    private void stopProgressCircle() {
        IconedProcessIndicator progressCircle = this.progressCircle;
        if (progressCircle != null && progressCircle.isIndeterminate()) {
            progressCircle.setIndeterminate(false);
            progressCircle.setMaximum(100);
            progressCircle.setValue(100);
        }
    }

    private void startProgressCircle() {
        IconedProcessIndicator progressCircle = this.progressCircle;
        if (progressCircle != null && !progressCircle.isIndeterminate()) {
            progressCircle.setValue(1);
            progressCircle.setIndeterminate(true);
        }
    }

    public boolean askForClose(LinkCollectorCrawler caller) {
        if (caller instanceof LinkCollector.JobLinkCrawler) {
            LinkCollector.JobLinkCrawler jobLinkCrawler = (LinkCollector.JobLinkCrawler)caller;
            if (jobLinkCrawler.isCollecting()) {
                return false;
            }
            long lastChange = this.lastChange.get();
            if (lastChange == -1L) {
                return false;
            }
            return System.currentTimeMillis() - lastChange > (long)this.CLOSETIMEOUT;
        }
        return true;
    }

    @Override
    public void updateLayout() {
        this.removeAll();
        this.layoutComponents();
        this.revalidate();
        this.repaint();
    }

    public static void fill(ArrayList<Element> elements) {
        elements.add(new Element(CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_DURATION_VISIBLE, _GUI.T.ReconnectDialog_layoutDialogContent_duration(), "wait"));
        elements.add(new Element(CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_LINK_COUNT_VISIBLE, _GUI.T.LinkCrawlerBubbleContent_LinkCrawlerBubbleContent_foundlink(), "file"));
        elements.add(new Element(CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_PACKAGE_COUNT_VISIBLE, _GUI.T.LinkCrawlerBubbleContent_LinkCrawlerBubbleContent_foundpackages(), "package_new"));
        elements.add(new Element(CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_OFFLINE_COUNT_VISIBLE, _GUI.T.LinkCrawlerBubbleContent_LinkCrawlerBubbleContent_foundoffline(), "error"));
        elements.add(new Element(CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_LIST_QUEUE_VISIBLE, _GUI.T.LinkCrawlerBubbleContent_LinkCrawlerBubbleContent_list_queue(), "batch"));
        elements.add(new Element(CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_CHECK_QUEUE_VISIBLE, _GUI.T.LinkCrawlerBubbleContent_LinkCrawlerBubbleContent_linkcheck_queue(), "question"));
        elements.add(new Element(CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_ONLINE_COUNT_VISIBLE, _GUI.T.LinkCrawlerBubbleContent_LinkCrawlerBubbleContent_foundonline(), "ok"));
        elements.add(new Element(CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_STATUS_VISIBLE, _GUI.T.LinkCrawlerBubbleContent_LinkCrawlerBubbleContent_status(), "run"));
        elements.add(new Element(CFG_BUBBLE.CRAWLER_BUBBLE_CONTENT_ANIMATED_ICON_VISIBLE, _GUI.T.LinkCrawlerBubbleContent_LinkCrawlerBubbleContent_icon(), "find"));
    }
}

