/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify.linkcrawler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Timer;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkCollectorCrawler;
import jd.controlling.linkcollector.LinkCollectorEvent;
import jd.controlling.linkcollector.LinkCollectorListener;
import jd.controlling.linkcollector.event.LinkCollectorCrawlerListener;
import jd.controlling.linkcrawler.CrawledLink;
import org.appwork.storage.config.JsonConfig;
import org.jdownloader.gui.notify.AbstractBubbleSupport;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.notify.Element;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;
import org.jdownloader.gui.notify.gui.BubbleNotifyConfig;
import org.jdownloader.gui.notify.gui.CFG_BUBBLE;
import org.jdownloader.gui.notify.linkcrawler.LinkCrawlerBubble;
import org.jdownloader.gui.notify.linkcrawler.LinkCrawlerBubbleContent;
import org.jdownloader.gui.translate._GUI;

public class LinkCrawlerBubbleSupport
extends AbstractBubbleSupport
implements LinkCollectorListener {
    private final ArrayList<Element> elements = new ArrayList();
    private final BubbleNotifyConfig.LINKGRABBER_BUBBLE_NOTIFY_ON notifyOn = ((BubbleNotifyConfig)JsonConfig.create(BubbleNotifyConfig.class)).getBubbleNotifyOnNewLinkgrabberLinksOn();
    private final boolean registerOnPlugin = BubbleNotifyConfig.LINKGRABBER_BUBBLE_NOTIFY_ON.PLUGIN.equals((Object)this.notifyOn);
    private final WeakHashMap<LinkCollectorCrawler, LinkCrawlerBubbleWrapper> map = new WeakHashMap();

    public LinkCrawlerBubbleSupport() {
        super(_GUI.T.plugins_optional_JDLightTray_ballon_newlinks3(), CFG_BUBBLE.BUBBLE_NOTIFY_ON_NEW_LINKGRABBER_LINKS_ENABLED);
        LinkCrawlerBubbleContent.fill(this.elements);
        LinkCollector.getInstance().getEventsender().addListener(this, true);
    }

    @Override
    public List<Element> getElements() {
        return this.elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLinkCrawlerAdded(LinkCollectorCrawler crawler) {
        if (this.isEnabled() && crawler instanceof LinkCollector.JobLinkCrawler) {
            LinkCrawlerBubbleWrapper wrapper = new LinkCrawlerBubbleWrapper((LinkCollector.JobLinkCrawler)crawler);
            if (BubbleNotifyConfig.LINKGRABBER_BUBBLE_NOTIFY_ON.ALWAYS.equals((Object)this.notifyOn)) {
                wrapper.register();
            } else {
                crawler.getEventSender().addListener(wrapper);
                WeakHashMap<LinkCollectorCrawler, LinkCrawlerBubbleWrapper> weakHashMap = this.map;
                synchronized (weakHashMap) {
                    this.map.put(crawler, wrapper);
                }
            }
        }
    }

    @Override
    public void onLinkCrawlerStarted(LinkCollectorCrawler parameter) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLinkCrawlerStopped(LinkCollectorCrawler crawler) {
        LinkCrawlerBubbleWrapper wrapper;
        WeakHashMap<LinkCollectorCrawler, LinkCrawlerBubbleWrapper> weakHashMap = this.map;
        synchronized (weakHashMap) {
            wrapper = this.map.remove(crawler);
        }
        if (wrapper != null) {
            crawler.getEventSender().removeListener(wrapper);
        }
    }

    @Override
    public void onLinkCollectorAbort(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorFilteredLinksAvailable(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorFilteredLinksEmpty(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorDataRefresh(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorStructureRefresh(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorContentRemoved(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorContentAdded(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorLinkAdded(LinkCollectorEvent event, CrawledLink parameter) {
    }

    @Override
    public void onLinkCollectorDupeAdded(LinkCollectorEvent event, CrawledLink parameter) {
    }

    @Override
    public void onLinkCrawlerNewJob(LinkCollectingJob job) {
    }

    @Override
    public void onLinkCrawlerFinished() {
    }

    private class LinkCrawlerBubbleWrapper
    implements BubbleNotify.AbstractNotifyWindowFactory,
    LinkCollectorCrawlerListener {
        private final WeakReference<LinkCollector.JobLinkCrawler> crawler;
        private volatile LinkCrawlerBubble bubble = null;
        private final AtomicBoolean registered = new AtomicBoolean(false);

        private LinkCrawlerBubbleWrapper(LinkCollector.JobLinkCrawler crawler) {
            this.crawler = new WeakReference<LinkCollector.JobLinkCrawler>(crawler);
        }

        @Override
        public AbstractNotifyWindow<?> buildAbstractNotifyWindow() {
            final LinkCollector.JobLinkCrawler crawler = (LinkCollector.JobLinkCrawler)this.crawler.get();
            if (this.bubble == null && crawler != null) {
                final LinkCrawlerBubble finalBubble = new LinkCrawlerBubble(LinkCrawlerBubbleSupport.this, crawler);
                Timer t = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (finalBubble.isClosed() || finalBubble.isDisposed()) {
                            LinkCrawlerBubbleWrapper.this.crawler.clear();
                            LinkCrawlerBubbleWrapper.this.bubble = null;
                            ((LinkCrawlerBubbleContent)((Object)finalBubble.getContentComponent())).stop();
                            ((Timer)e.getSource()).stop();
                        } else {
                            if (finalBubble.isVisible()) {
                                finalBubble.requestUpdate();
                            }
                            if (((LinkCrawlerBubbleContent)((Object)finalBubble.getContentComponent())).askForClose(crawler)) {
                                LinkCrawlerBubbleWrapper.this.crawler.clear();
                                LinkCrawlerBubbleWrapper.this.bubble = null;
                                ((LinkCrawlerBubbleContent)((Object)finalBubble.getContentComponent())).stop();
                                ((Timer)e.getSource()).stop();
                                finalBubble.hideBubble(finalBubble.getTimeout());
                            }
                        }
                    }
                });
                t.setInitialDelay(0);
                t.setRepeats(true);
                t.start();
                this.bubble = finalBubble;
            }
            return this.bubble;
        }

        private void register() {
            LinkCollector.JobLinkCrawler crawler;
            if (this.registered.compareAndSet(false, true) && (crawler = (LinkCollector.JobLinkCrawler)this.crawler.get()) != null) {
                crawler.getEventSender().removeListener(this);
                LinkCrawlerBubbleSupport.this.show(this);
            }
        }

        @Override
        public void onProcessingCrawlerPlugin(LinkCollectorCrawler caller, CrawledLink parameter) {
            if (LinkCrawlerBubbleSupport.this.registerOnPlugin) {
                this.register();
            }
        }

        @Override
        public void onProcessingHosterPlugin(LinkCollectorCrawler caller, CrawledLink parameter) {
            this.register();
        }

        @Override
        public void onProcessingContainerPlugin(LinkCollectorCrawler caller, CrawledLink parameter) {
            if (LinkCrawlerBubbleSupport.this.registerOnPlugin) {
                this.register();
            }
        }
    }
}

