/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify.reconnect;

import java.awt.Component;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JLabel;
import jd.controlling.reconnect.Reconnecter;
import jd.controlling.reconnect.ipcheck.IPConnectionState;
import jd.controlling.reconnect.ipcheck.IPController;
import jd.gui.swing.jdgui.components.IconedProcessIndicator;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.notify.AbstractBubbleContentPanel;
import org.jdownloader.gui.notify.Element;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;

public class ReconnectBubbleContent
extends AbstractBubbleContentPanel {
    private final JLabel newIP;
    private final JLabel old;
    private final long startTime = System.currentTimeMillis();
    private final JLabel duration;
    protected IconedProcessIndicator progressCircle = null;
    private final AtomicReference<Thread> ipStateThread = new AtomicReference();

    @Override
    public void stop() {
        IconedProcessIndicator progressCircle = this.progressCircle;
        if (progressCircle != null) {
            progressCircle.setIndeterminate(false);
            progressCircle.setMaximum(100);
            progressCircle.setValue(100);
        }
        super.stop();
    }

    public ReconnectBubbleContent() {
        super("auto-reconnect");
        this.progressCircle = this.createProgress("auto-reconnect");
        this.add((Component)this.progressCircle, "width 32!,height 32!,pushx,growx,pushy,growy,spany,aligny top");
        this.add(this.createHeaderLabel(_GUI.T.ReconnectDialog_layoutDialogContent_duration()));
        this.duration = new JLabel("-");
        this.add(this.duration);
        this.add(this.createHeaderLabel(_GUI.T.ReconnectDialog_layoutDialogContent_old()));
        this.old = new JLabel("???.???.???.???");
        this.add(this.old);
        this.add(this.createHeaderLabel(_GUI.T.ReconnectDialog_layoutDialogContent_currentip()));
        this.newIP = new JLabel("???.???.???.???");
        this.add(this.newIP);
        this.progressCircle.setIndeterminate(true);
        this.progressCircle.setValue(0);
        new Thread(((Object)((Object)this)).getClass().getName()){
            {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                final IPConnectionState ip = IPController.getInstance().getIpState();
                new EDTRunner(){

                    protected void runInEDT() {
                        ReconnectBubbleContent.this.old.setText(ip.toString());
                    }
                };
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        AtomicReference<Thread> atomicReference = this.ipStateThread;
        synchronized (atomicReference) {
            new EDTRunner(){

                protected void runInEDT() {
                    ReconnectBubbleContent.this.duration.setText(TimeFormatter.formatMilliSeconds((long)(System.currentTimeMillis() - ReconnectBubbleContent.this.startTime), (int)0));
                }
            };
            Thread ipStateThread = this.ipStateThread.get();
            if (ipStateThread == null || !ipStateThread.isAlive()) {
                ipStateThread = new Thread(((Object)((Object)this)).getClass().getName()){
                    {
                        this.setDaemon(true);
                    }

                    @Override
                    public void run() {
                        final IPConnectionState ip = IPController.getInstance().getIpState();
                        new EDTRunner(){

                            protected void runInEDT() {
                                ReconnectBubbleContent.this.newIP.setText(ip.toString());
                            }
                        };
                    }
                };
                this.ipStateThread.set(ipStateThread);
                ipStateThread.start();
            }
        }
    }

    public void onResult(Reconnecter.ReconnectResult result) {
        switch (result) {
            case SUCCESSFUL: {
                this.add(this.createHeaderLabel(_GUI.T.ReconnectBubbleContent_onResult_result()));
                this.add(new JLabel(_GUI.T.ReconnectDialog_onIPValidated_(), new AbstractIcon("ok", 20), 2));
                break;
            }
            case FAILED: {
                this.add(this.createHeaderLabel(_GUI.T.ReconnectBubbleContent_onResult_result()));
                this.add(new JLabel(_GUI.T.ReconnectDialog_failed(), new AbstractIcon("error", 20), 2));
            }
        }
    }

    @Override
    public void updateLayout() {
    }

    public static void fill(ArrayList<Element> elements) {
    }
}

