/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.packagehistorycontroller;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.ConfigEvent;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.EventSuppressor;
import org.jdownloader.gui.packagehistorycontroller.HistoryManager;
import org.jdownloader.gui.packagehistorycontroller.PackageHistoryEntry;
import org.jdownloader.settings.staticreferences.CFG_LINKGRABBER;

public class PackageHistoryManager
extends HistoryManager<PackageHistoryEntry>
implements GenericConfigEventListener<Object> {
    private static final PackageHistoryManager INSTANCE = new PackageHistoryManager();

    public static PackageHistoryManager getInstance() {
        return INSTANCE;
    }

    private PackageHistoryManager() {
        super(CFG_LINKGRABBER.CFG.getPackageNameHistory());
        CFG_LINKGRABBER.PACKAGE_NAME_HISTORY.getEventSender().addListener((EventListener)((Object)this));
    }

    @Override
    protected int getMaxLength() {
        return CFG_LINKGRABBER.CFG.getPackageNameHistoryLength();
    }

    @Override
    protected boolean isValid(String input) {
        return !StringUtils.isEmpty((String)input) && !input.contains("<jd:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void save(List<PackageHistoryEntry> list) {
        final Thread thread = Thread.currentThread();
        EventSuppressor<ConfigEvent> eventSuppressor = new EventSuppressor<ConfigEvent>(){

            public boolean suppressEvent(ConfigEvent eventType) {
                return Thread.currentThread() == thread;
            }
        };
        CFG_LINKGRABBER.PACKAGE_NAME_HISTORY.getEventSender().addEventSuppressor((EventSuppressor)eventSuppressor);
        try {
            CFG_LINKGRABBER.CFG.setPackageNameHistory(list);
        }
        finally {
            CFG_LINKGRABBER.PACKAGE_NAME_HISTORY.getEventSender().removeEventSuppressor((EventSuppressor)eventSuppressor);
        }
    }

    @Override
    protected PackageHistoryEntry createNew(String name) {
        return new PackageHistoryEntry(name);
    }

    public List<PackageHistoryEntry> list(PackageHistoryEntry packageHistoryEntry) {
        List list = this.list();
        ArrayList<PackageHistoryEntry> ret = new ArrayList<PackageHistoryEntry>();
        ret.add(packageHistoryEntry);
        for (PackageHistoryEntry phe : list) {
            if (phe.getName().equals(packageHistoryEntry.getName())) continue;
            ret.add(phe);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
        if (newValue == null) {
            this.clear();
        } else if (newValue instanceof List) {
            List list = (List)newValue;
            if (list.size() == 0) {
                this.clear();
            } else {
                PackageHistoryManager packageHistoryManager = this;
                synchronized (packageHistoryManager) {
                    this.clear();
                    for (int i = list.size() - 1; i >= 0; --i) {
                        Object item = list.get(i);
                        if (item == null || !(item instanceof PackageHistoryEntry)) continue;
                        this.add(((PackageHistoryEntry)item).getName());
                    }
                }
            }
        }
    }

    public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
    }
}

