/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTML;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.gui.swing.jdgui.views.settings.components.SettingsComponent;
import jd.parser.Regex;
import net.miginfocom.swing.MigLayout;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.swing.components.ExtCheckBox;
import org.appwork.utils.ColorUtils;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.extensions.Header;
import org.jdownloader.gui.settings.Pair;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.translate._JDT;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.SmartRlyExitRequest;
import org.jdownloader.updatev2.gui.LAFOptions;

public abstract class AbstractConfigPanel
extends SwitchPanel {
    private static final String PAIR_CONDITION = "PAIR_CONDITION";
    private static final long serialVersionUID = -8483438886830392777L;
    protected List<Pair<?>> pairs = new ArrayList();
    private HighlightLabel lastLabel;
    protected Pair over;
    private MouseMotionListener ml;

    public AbstractConfigPanel() {
        this(15);
    }

    private String getFieldNameOf(Object input) {
        if (input instanceof Component && ((Component)input).getName() != null) {
            return ((Component)input).getName();
        }
        for (Field f : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            try {
                if (f.getType() != input.getClass()) continue;
                f.setAccessible(true);
                if (f.get((Object)this) != input) continue;
                return f.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getPanelID() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public AbstractConfigPanel(int insets) {
        super((LayoutManager)new MigLayout("ins " + insets + ", wrap 2", "[grow][grow,fill]", "[]"));
        this.setOpaque(false);
        this.ml = new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                boolean found = false;
                Point point = e.getPoint();
                point = SwingUtilities.convertPoint(e.getComponent(), point, (Component)((Object)AbstractConfigPanel.this));
                for (Pair<?> p : AbstractConfigPanel.this.pairs) {
                    if (!(p.getComponent() instanceof Component) || point.y < p.getYMin() - 5 || point.y >= p.getYMax()) continue;
                    found = true;
                    if (AbstractConfigPanel.this.over == p) break;
                    Pair last = AbstractConfigPanel.this.over;
                    AbstractConfigPanel.this.over = p;
                    int yMin = p.getYMin();
                    if (last != null) {
                        yMin = Math.min(yMin, last.getYMin());
                    }
                    int yMax = p.getYMax();
                    if (last != null) {
                        yMax = Math.max(yMax, last.getYMax());
                    }
                    AbstractConfigPanel.this.repaint(0, yMin - 10, AbstractConfigPanel.this.getWidth(), yMax - yMin + 20);
                    break;
                }
                if (!found && AbstractConfigPanel.this.over != null) {
                    Pair last = AbstractConfigPanel.this.over;
                    AbstractConfigPanel.this.over = null;
                    AbstractConfigPanel.this.repaint(0, last.getYMin(), AbstractConfigPanel.this.getWidth(), last.getHeight());
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        };
        this.addMouseMotionListener(this.ml);
    }

    protected void paintComponent(Graphics g) {
        Pair p = this.over;
        if (p != null && !p.getLabel().getText().equals("<html></html>")) {
            Graphics2D g2 = (Graphics2D)((Graphics2D)g).create(0, p.getYMin(), this.getWidth(), p.getHeight());
            g2.setClip(null);
            g2.setColor(ColorUtils.getAlphaInstance((Color)this.getForeground(), (int)15));
            g2.fillRect(p.getLabel().getX() - 5, 0, this.getWidth(), p.getHeight());
        }
        super.paintComponent(g);
    }

    public JLabel addDescription(String description) {
        JLabel txt = this.addDescriptionPlain(description);
        this.add(new JSeparator(), "gapleft " + this.getLeftGap() + ",spanx,growx,pushx,gapbottom 5" + this.getRightGap());
        return txt;
    }

    public JLabel addDescriptionPlain(String description) {
        if (!description.toLowerCase().startsWith("<html>")) {
            description = "<html>" + description.replace("\r\n", "<br>").replace("\r", "<br>").replace("\n", "<br>") + "</html>";
            description = AbstractConfigPanel.escapeUnsupportedTags(description);
        }
        JLabel txt = new JLabel();
        SwingUtils.setOpaque((JComponent)txt, (boolean)false);
        LAFOptions.getInstance().applyConfigDescriptionTextColor(txt);
        txt.setText(description);
        this.add(txt, "gaptop 0,spanx,growx,pushx,gapleft " + this.getLeftGap() + ",gapbottom 5,wmin 10" + this.getRightGap());
        return txt;
    }

    public void addTopHeader(String name, Icon icon) {
        this.add(new Header(name, icon), "spanx,growx,pushx" + this.getRightGap());
    }

    protected void showRestartRequiredMessage() {
        try {
            Dialog.getInstance().showConfirmDialog(0, _JDT.T.dialog_optional_showRestartRequiredMessage_title(), _JDT.T.dialog_optional_showRestartRequiredMessage_msg(), null, _JDT.T.basics_yes(), _JDT.T.basics_no());
            RestartController.getInstance().exitAsynch((ShutdownRequest)new SmartRlyExitRequest(true));
        }
        catch (DialogClosedException dialogClosedException) {
        }
        catch (DialogCanceledException dialogCanceledException) {
            // empty catch block
        }
    }

    @Deprecated
    protected Header addHeader(String name, String iconKey) {
        return this.addHeader(name, NewTheme.I().getIcon(iconKey, 32));
    }

    public abstract Icon getIcon();

    public abstract String getTitle();

    public <T extends SettingsComponent> Pair<T> addPair(String name, BooleanKeyHandler enabled, T comp) {
        String lblConstraints = "gapleft " + this.getLeftGap() + ",aligny " + (comp.isMultiline() ? "top" : "center");
        return this.addPair(name, lblConstraints, enabled, comp);
    }

    public <T extends SettingsComponent> Pair<T> addPair(String name, String lblConstraints, BooleanKeyHandler enabled, T comp) {
        HighlightLabel lbl = this.createLabel(name);
        ExtCheckBox cb = null;
        String con = "pushx,growy";
        this.lastLabel = lbl;
        if (lbl != null) {
            lbl.addMouseMotionListener(this.ml);
        }
        if (enabled != null) {
            this.add(lbl, lblConstraints + ",split 2,growx");
            cb = new ExtCheckBox(enabled, new JComponent[]{lbl, (JComponent)comp});
            SwingUtils.setOpaque((JComponent)cb, (boolean)false);
            this.add((Component)cb, "width " + cb.getPreferredSize().width + "!, aligny " + (comp.isMultiline() ? "top" : "center"));
            cb.setToolTipText(_GUI.T.AbstractConfigPanel_addPair_enabled());
            cb.addMouseMotionListener(this.ml);
        } else {
            this.add(lbl, lblConstraints);
        }
        if (comp instanceof Component) {
            ((Component)comp).addMouseMotionListener(this.ml);
        }
        if (comp.getConstraints() != null) {
            con = con + "," + comp.getConstraints();
        }
        con = con + this.getRightGap();
        this.add((JComponent)comp, con);
        Pair<T> p = new Pair<T>(lbl, comp, cb);
        this.pairs.add(p);
        return p;
    }

    protected void onShow() {
        this.updateContents();
        for (Pair<?> p : this.pairs) {
            p.update();
        }
    }

    public abstract void save();

    public abstract void updateContents();

    protected void onHide() {
        this.save();
    }

    public static String escapeUnsupportedTags(String html) {
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile("(?i)(</?[^>]*>)").matcher(html);
        while (m.find()) {
            String match = html.substring(m.start(), m.end());
            String tag = new Regex(match, "</?([^>]*)").getMatch(0);
            if (HTML.getTag(tag.toLowerCase(Locale.ENGLISH)) != null) {
                m.appendReplacement(sb, Matcher.quoteReplacement(match));
                continue;
            }
            m.appendReplacement(sb, Matcher.quoteReplacement("&lt;" + match.substring(1)));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public HighlightLabel createLabel(String text) {
        if (text != null && !text.toLowerCase().startsWith("<html>")) {
            text = "<html>" + text.replace("\r\n", "<br>").replace("\r", "<br>").replace("\n", "<br>") + "</html>";
            text = AbstractConfigPanel.escapeUnsupportedTags(text);
        }
        HighlightLabel lbl = new HighlightLabel(text);
        return lbl;
    }

    public Component add(Component comp) {
        if (comp instanceof SettingsComponent) {
            String con = "gapleft" + this.getLeftGap() + ",spanx,growx,pushx";
            if (((SettingsComponent)comp).getConstraints() != null) {
                con = con + "," + ((SettingsComponent)comp).getConstraints();
            }
            super.add(comp, (Object)con);
            return comp;
        }
        if (comp instanceof JScrollPane) {
            super.add(comp, (Object)("gapleft" + this.getLeftGap() + ",spanx,growx,pushx,height 60:n:n,pushy,growy"));
            return comp;
        }
        super.add(comp, (Object)"growx, pushx,spanx");
        return comp;
    }

    public String getRightGap() {
        return "";
    }

    public String getLeftGap() {
        return LAFOptions.getInstance().getCfg().getConfigPanelLeftIndent() + "";
    }

    protected Header addHeader(String name, Icon icon) {
        Header header;
        if (this.getComponentCount() == 0) {
            header = new Header(name, icon);
            this.add(header, "spanx,growx,pushx");
        } else {
            header = new Header(name, icon);
            this.add(header, "spanx,newline,growx,pushx");
        }
        return header;
    }

    public static class HighlightLabel
    extends JLabel {
        public HighlightLabel(String text) {
            super(text);
            LAFOptions.getInstance().applyConfigLabelEnabledTextColor((JLabel)this);
        }

        @Override
        public void setEnabled(boolean paramBoolean) {
            if (paramBoolean) {
                if (!LAFOptions.getInstance().applyConfigLabelEnabledTextColor((JLabel)this)) {
                    super.setEnabled(true);
                } else {
                    super.setEnabled(true);
                }
            } else if (!LAFOptions.getInstance().applyConfigLabelDisabledTextColor((JLabel)this)) {
                super.setEnabled(false);
            } else {
                super.setEnabled(true);
            }
        }

        public void setHighlight(boolean b) {
            this.repaint();
        }
    }
}

