/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.settings;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JLabel;
import jd.gui.swing.jdgui.views.settings.components.Checkbox;
import jd.gui.swing.jdgui.views.settings.components.SettingsComponent;
import org.appwork.swing.components.ExtCheckBox;

public class Pair<T extends SettingsComponent> {
    private JLabel label;
    private T component;
    private Pair<Checkbox> conditionPair;
    private ExtCheckBox condition;

    public JLabel getLabel() {
        return this.label;
    }

    public T getComponent() {
        return this.component;
    }

    public ExtCheckBox getCondition() {
        return this.condition;
    }

    public void setEnabled(boolean b) {
        this.label.setEnabled(b);
        this.component.setEnabled(b);
    }

    public Pair(JLabel lbl, T comp, ExtCheckBox condition) {
        this.label = lbl;
        this.component = comp;
        this.condition = condition;
    }

    public void setToolTipText(String text) {
        this.label.setToolTipText(text);
        this.component.setToolTipText(text);
    }

    public void setConditionPair(Pair<Checkbox> toggleCustomizedPath) {
        this.conditionPair = toggleCustomizedPath;
        this.conditionPair.getComponent().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Pair conditionPair = Pair.this.conditionPair;
                if (conditionPair != null) {
                    Pair.this.setEnabled(((Checkbox)conditionPair.getComponent()).isSelected());
                }
            }
        });
        this.setEnabled(this.conditionPair.getComponent().isSelected());
    }

    public void update() {
        Pair<Checkbox> conditionPair = this.conditionPair;
        if (conditionPair != null) {
            this.setEnabled(conditionPair.getComponent().isSelected());
        }
    }

    public int getYMin() {
        int yMin = 0;
        if (this.getLabel() != null) {
            yMin = this.getLabel().getY();
        }
        if (this.getComponent() instanceof Component) {
            yMin = Math.min(yMin, ((Component)this.getComponent()).getY());
        }
        return yMin;
    }

    public int getHeight() {
        int yMin = 0;
        int yMax = 0;
        if (this.getLabel() != null) {
            yMin = this.getLabel().getY();
            yMax = this.getLabel().getY() + this.getLabel().getHeight();
        }
        if (this.getComponent() instanceof Component) {
            yMin = Math.min(yMin, ((Component)this.getComponent()).getY());
            yMax = Math.max(yMax, ((Component)this.getComponent()).getY() + ((Component)this.getComponent()).getHeight());
        }
        return yMax - yMin;
    }

    public int getYMax() {
        int yMax = 0;
        if (this.getLabel() != null) {
            yMax = this.getLabel().getY() + this.getLabel().getHeight();
        }
        if (this.getComponent() instanceof Component) {
            yMax = Math.max(yMax, ((Component)this.getComponent()).getY() + ((Component)this.getComponent()).getHeight());
        }
        return yMax;
    }
}

