/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.shortcuts;

import java.awt.Toolkit;
import javax.swing.KeyStroke;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.AbstractValidator;
import org.appwork.storage.config.annotations.DefaultFactory;
import org.appwork.storage.config.annotations.ValidatorFactory;
import org.appwork.storage.config.defaults.AbstractDefaultFactory;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.Application;

public interface ShortcutSettings
extends ConfigInterface {
    @AboutConfig
    @DefaultFactory(value=DefaultTextFieldCopy.class)
    @ValidatorFactory(value=KeyStrokeValidator.class)
    public String getTextFieldCopy();

    @AboutConfig
    @DefaultFactory(value=DefaultTextFieldCut.class)
    @ValidatorFactory(value=KeyStrokeValidator.class)
    public String getTextFieldCut();

    @AboutConfig
    @DefaultFactory(value=DefaultTextFieldDelete.class)
    @ValidatorFactory(value=KeyStrokeValidator.class)
    public String getTextFieldDelete();

    @AboutConfig
    @DefaultFactory(value=DefaultTextFieldPaste.class)
    @ValidatorFactory(value=KeyStrokeValidator.class)
    public String getTextFieldPaste();

    @AboutConfig
    @DefaultFactory(value=DefaultTextFieldSelect.class)
    @ValidatorFactory(value=KeyStrokeValidator.class)
    public String getTextFieldSelect();

    public void setTextFieldCopy(String var1);

    public void setTextFieldCut(String var1);

    public void setTextFieldDelete(String var1);

    public void setTextFieldPaste(String var1);

    public void setTextFieldSelect(String var1);

    public static class KeyStrokeValidator
    extends AbstractValidator<String> {
        public void validate(KeyHandler<String> keyHandler, String keystroke) throws ValidationException {
            if (KeyStroke.getKeyStroke(keystroke) == null) {
                throw new ValidationException("Invalid KeyStroke: " + keystroke);
            }
        }
    }

    public static class DefaultTextFieldSelect
    extends AbstractDefaultFactory<String> {
        public String getDefaultValue(KeyHandler<String> keyHandler) {
            return Application.isHeadless() ? null : KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()).toString();
        }
    }

    public static class DefaultTextFieldPaste
    extends AbstractDefaultFactory<String> {
        public String getDefaultValue(KeyHandler<String> keyHandler) {
            return Application.isHeadless() ? null : KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()).toString();
        }
    }

    public static class DefaultTextFieldDelete
    extends AbstractDefaultFactory<String> {
        public String getDefaultValue(KeyHandler<String> keyHandler) {
            return Application.isHeadless() ? null : KeyStroke.getKeyStroke(127, 0).toString();
        }
    }

    public static class DefaultTextFieldCut
    extends AbstractDefaultFactory<String> {
        public String getDefaultValue(KeyHandler<String> keyHandler) {
            return Application.isHeadless() ? null : KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()).toString();
        }
    }

    public static class DefaultTextFieldCopy
    extends AbstractDefaultFactory<String> {
        public String getDefaultValue(KeyHandler<String> keyHandler) {
            return Application.isHeadless() ? null : KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()).toString();
        }
    }
}

