/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.sponsor;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import jd.SecondLevelLaunch;
import jd.controlling.AccountController;
import jd.controlling.AccountControllerEvent;
import jd.controlling.AccountControllerListener;
import jd.controlling.AccountFilter;
import jd.controlling.AccountUpOrDowngradeEvent;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.event.DownloadWatchdogListener;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkCollectorCrawler;
import jd.controlling.linkcollector.LinkCollectorEvent;
import jd.controlling.linkcollector.LinkCollectorListener;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractNodeVisitor;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import jd.gui.swing.jdgui.MainTabbedPane;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkProperty;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageProperty;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.components.ExtMergedIcon;
import org.appwork.txtresource.TranslationFactory;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.images.Interpolation;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.DomainInfo;
import org.jdownloader.controlling.download.DownloadControllerListener;
import org.jdownloader.gui.sponsor.Sponsor;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.myjdownloader.client.json.AvailableLinkState;
import org.jdownloader.premium.OpenURLAction;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class BannerRotation
implements Sponsor,
AccountControllerListener {
    private final List<AvailableBanner> allBanners = new CopyOnWriteArrayList<AvailableBanner>();
    private final Queue queue = new Queue("Banner"){

        public void killQueue() {
        }
    };
    private final MainTabbedPane pane;
    private volatile Banner current = null;
    private final AtomicBoolean isBannerEnabled = new AtomicBoolean(false);
    private final int refreshTimeout = 60000;
    private final int bannerMinimumShowtime = 300000;
    private final DelayedRunnable updateDelayer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rotateBanner(List<AvailableBanner> rotateBanners) {
        Banner old = this.current;
        try {
            if (rotateBanners != null && rotateBanners.size() == 0) {
                this.current = null;
            } else {
                if (rotateBanners == null) {
                    rotateBanners = this.getAllBanners();
                }
                if (rotateBanners == null || rotateBanners.size() == 0) {
                    this.current = null;
                } else if (old == null) {
                    this.current = new Banner(rotateBanners.get(0));
                } else if (System.currentTimeMillis() - old.getTimestamp() > 300000L) {
                    int index = rotateBanners.indexOf(old.getBanner());
                    this.current = index == -1 || index + 1 == rotateBanners.size() || rotateBanners.size() == 1 ? new Banner(rotateBanners.get(0)) : new Banner(rotateBanners.get(index + 1));
                }
            }
            if (old == this.current) return;
        }
        catch (Throwable throwable) {
            if (old == this.current) throw throwable;
            new EDTRunner(){

                protected void runInEDT() {
                    BannerRotation.this.pane.repaint();
                }
            };
            throw throwable;
        }
        new /* invalid duplicate definition of identical inner class */;
    }

    private List<AvailableBanner> updateRotation() {
        ArrayList<AvailableBanner> rotation = new ArrayList<AvailableBanner>();
        ArrayList<AvailableBanner> fallback = new ArrayList<AvailableBanner>();
        for (AvailableBanner banner : this.getAllBanners()) {
            if (banner.getIcon() == null) continue;
            if (banner.hasChanges()) {
                // empty if block
            }
            if (banner.hasAccounts) continue;
            if (banner.hasDownloadLinks || banner.hasRunningDownloads()) {
                rotation.add(0, banner);
                continue;
            }
            if (banner.hasLinks) {
                rotation.add(banner);
                continue;
            }
            fallback.add(banner);
        }
        if (rotation.size() > 0) {
            return rotation;
        }
        return fallback;
    }

    private List<AvailableBanner> getAllBanners() {
        return this.allBanners;
    }

    public BannerRotation() {
        this.pane = MainTabbedPane.getInstance();
        this.updateDelayer = new DelayedRunnable(1000L, 15000L){

            public void delayedrun() {
                BannerRotation.this.queue.addWait((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        BannerRotation.this.rotateBanner(BannerRotation.this.updateRotation());
                        return null;
                    }
                });
            }
        };
        final Thread refreshThread = new Thread("BannerRotation"){
            {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    BannerRotation.this.onChange(null);
                }
            }
        };
        SecondLevelLaunch.INIT_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                new Thread(){

                    @Override
                    public void run() {
                        SecondLevelLaunch.ACCOUNTLIST_LOADED.executeWhenReached(new Runnable(){

                            @Override
                            public void run() {
                                AccountController.getInstance().getEventSender().addListener((EventListener)BannerRotation.this, true);
                            }
                        });
                        CFG_GUI.BANNER_ENABLED.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

                            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                                boolean isEnabled = Boolean.TRUE.equals(newValue);
                                if (BannerRotation.this.isBannerEnabled.getAndSet(isEnabled) != isEnabled) {
                                    ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setBannerChangeTimestamp(System.currentTimeMillis());
                                    if (!isEnabled) {
                                        new EDTRunner(){

                                            protected void runInEDT() {
                                                BannerRotation.this.current = null;
                                                BannerRotation.this.pane.repaint();
                                            }
                                        };
                                    } else {
                                        BannerRotation.this.updateDelayer.resetAndStart();
                                    }
                                }
                            }

                            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
                            }
                        });
                        BannerRotation.this.isBannerEnabled.set(CFG_GUI.BANNER_ENABLED.isEnabled());
                        BannerRotation.this.getAllBanners().add(new AvailableBanner("rapidgator.net"));
                        BannerRotation.this.getAllBanners().add(new AvailableBanner("k2s.cc"){

                            @Override
                            protected String getIconHost() {
                                return "keep2share.cc";
                            }
                        });
                        BannerRotation.this.getAllBanners().add(new AvailableBanner("ddownload.com"));
                        BannerRotation.this.getAllBanners().add(new AvailableBanner("filejoker.net"));
                        BannerRotation.this.getAllBanners().add(new AvailableBanner("filer.net"));
                        BannerRotation.this.updateDelayer.resetAndStart();
                        refreshThread.start();
                    }
                }.start();
            }
        });
    }

    private void onChange(AvailableBanner banner) {
        if (this.isEnabled()) {
            this.updateDelayer.resetAndStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAccountControllerEvent(AccountControllerEvent event) {
        block17: {
            try {
                boolean notify;
                if (event == null || !AccountControllerEvent.Types.ACCOUNT_UP_OR_DOWNGRADE.equals(event.getType()) || !CFG_GUI.CFG.isPremiumExpireWarningEnabled()) break block17;
                AccountUpOrDowngradeEvent accountEvent = (AccountUpOrDowngradeEvent)event;
                long DAY = 86400000L;
                Account account = event.getAccount();
                String hoster = account.getHoster();
                long expireTimeStamp = accountEvent.getExpireTimeStamp();
                if (accountEvent.isPremiumAccount() && !accountEvent.isPremiumExpired()) {
                    boolean notify2;
                    if (expireTimeStamp <= 0L || expireTimeStamp - System.currentTimeMillis() >= 86400000L) break block17;
                    BannerRotation bannerRotation = this;
                    synchronized (bannerRotation) {
                        Long lastNotify;
                        String ID2 = "warn_" + hoster;
                        Map<String, Long> expireNotifies = CFG_GUI.CFG.getPremiumExpireWarningMapV2();
                        Long l = lastNotify = expireNotifies != null ? expireNotifies.get(ID2) : null;
                        if (lastNotify == null || System.currentTimeMillis() - lastNotify > 2592000000L) {
                            notify2 = true;
                            if (expireNotifies == null) {
                                expireNotifies = new HashMap<String, Long>();
                            }
                            expireNotifies.put(ID2, System.currentTimeMillis());
                            CFG_GUI.CFG.setPremiumExpireWarningMapV2(expireNotifies);
                        } else {
                            notify2 = false;
                        }
                    }
                    if (notify2) {
                        this.notify(account, _GUI.T.OboomController_onAccountControllerEvent_premiumexpire_warn_still_premium_title(hoster), _GUI.T.OboomController_onAccountControllerEvent_premiumexpire_warn_still_premium_msg(account.getUser(), hoster));
                    }
                    break block17;
                }
                if (!accountEvent.isPremiumDowngraded() || !AccountController.getInstance().listAccounts(new AccountFilter(hoster).setEnabled(true).setValid(true).setAccountTypes(Account.AccountType.PREMIUM, Account.AccountType.LIFETIME).setExpired(false).setMaxResultsNum(1)).isEmpty()) break block17;
                BannerRotation bannerRotation = this;
                synchronized (bannerRotation) {
                    Long lastNotify;
                    String ID3 = "expired_" + hoster;
                    Map<String, Long> expireNotifies = CFG_GUI.CFG.getPremiumExpireWarningMapV2();
                    Long l = lastNotify = expireNotifies != null ? expireNotifies.get(ID3) : null;
                    if (lastNotify == null || System.currentTimeMillis() - lastNotify > 2592000000L) {
                        notify = true;
                        if (expireNotifies == null) {
                            expireNotifies = new HashMap<String, Long>();
                        }
                        expireNotifies.put(ID3, System.currentTimeMillis());
                        CFG_GUI.CFG.setPremiumExpireWarningMapV2(expireNotifies);
                    } else {
                        notify = false;
                    }
                }
                if (notify) {
                    this.notify(account, _GUI.T.OboomController_onAccountControllerEvent_premiumexpire_warn_expired_premium_title(account.getHoster()), _GUI.T.OboomController_onAccountControllerEvent_premiumexpire_warn_expired_premium_msg(account.getUser(), account.getHoster()));
                }
            }
            catch (Throwable e) {
                LogController.CL().log(e);
            }
        }
    }

    private void notify(final Account account, String title, String msg) {
        if (account != null) {
            Icon fav = account.getDomainInfo().getFavIcon(false);
            ExtMergedIcon hosterIcon = new ExtMergedIcon((Icon)new AbstractIcon("refresh", 32)).add(fav, 32 - fav.getIconWidth(), 32 - fav.getIconHeight());
            ConfirmDialog d = new ConfirmDialog(36, title, msg, (Icon)hosterIcon, _GUI.T.lit_continue(), _GUI.T.lit_close()){

                public Dialog.ModalityType getModalityType() {
                    return Dialog.ModalityType.MODELESS;
                }

                public String getDontShowAgainKey() {
                    return "expireRenewNotification_" + account.getHoster();
                }

                public long getCountdown() {
                    return 300000L;
                }
            };
            try {
                Dialog.getInstance().showDialog((AbstractDialog)d);
            }
            catch (DialogNoAnswerException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle paint(Graphics2D g) {
        Icon icon;
        Banner banner = this.current;
        if (this.isVisible() && this.isEnabled() && banner != null && (icon = banner.icon) != null) {
            Rectangle bannerRectangle = new Rectangle(this.pane.getWidth() - icon.getIconWidth() - 2, 25 - icon.getIconHeight(), icon.getIconWidth(), icon.getIconHeight() + 2);
            g = (Graphics2D)g.create(bannerRectangle.x, bannerRectangle.y, bannerRectangle.width, bannerRectangle.height);
            try {
                if (g.getTransform().getScaleX() != 1.0 || g.getTransform().getScaleY() != 1.0) {
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, Interpolation.BILINEAR.getHint());
                }
                icon.paintIcon((Component)this.pane, g, 0, 0);
                Rectangle rectangle = bannerRectangle;
                return rectangle;
            }
            finally {
                g.dispose();
            }
        }
        return null;
    }

    private boolean isEnabled() {
        return this.isBannerEnabled.get();
    }

    public boolean isVisible() {
        return this.current != null;
    }

    public void onMouseOver(MouseEvent e) {
        if (this.isEnabled()) {
            this.pane.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void onMouseOut(MouseEvent e) {
        this.pane.setCursor(null);
    }

    @Override
    public String getPreSelectedInAddAccountDialog() {
        Banner banner = this.current;
        if (banner != null) {
            return banner.getBanner().getPreSelectedInAddAccountDialog();
        }
        return "rapidgator.net";
    }

    public void onClicked(MouseEvent e) {
        Banner banner = this.current;
        if (banner != null && this.isEnabled()) {
            banner.getBanner().onClick(e);
        }
    }

    private static <P extends AbstractPackageNode<C, P>, C extends AbstractPackageChildrenNode<P>> boolean contains(PackageController<P, C> controller, final DomainInfo domainInfo, final Boolean enabledFlag) {
        final AtomicBoolean ret = new AtomicBoolean(false);
        controller.visitNodes(new AbstractNodeVisitor<C, P>(){

            @Override
            public Boolean visitPackageNode(P pkg) {
                if (ret.get()) {
                    return null;
                }
                if (enabledFlag == null || enabledFlag.booleanValue() == pkg.isEnabled()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitChildrenNode(C node) {
                if ((enabledFlag == null || node.isEnabled() == enabledFlag.booleanValue()) && node.getDomainInfo() == domainInfo) {
                    ret.set(true);
                    return null;
                }
                return Boolean.TRUE;
            }
        }, true);
        return ret.get();
    }

    private class Banner {
        private final Icon icon;
        private final AvailableBanner banner;
        private final long timeStamp = System.currentTimeMillis();

        private Banner(AvailableBanner banner) {
            this.icon = banner.getIcon();
            this.banner = banner;
        }

        private final long getTimestamp() {
            return this.timeStamp;
        }

        public int hashCode() {
            return this.getBanner().getHost().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof Banner) {
                return StringUtils.equals((String)this.getBanner().getHost(), (String)((Banner)obj).getBanner().getHost());
            }
            return false;
        }

        private final Icon getIcon() {
            return this.icon;
        }

        private final AvailableBanner getBanner() {
            return this.banner;
        }
    }

    private class AvailableBanner
    implements DownloadControllerListener,
    LinkCollectorListener,
    DownloadWatchdogListener,
    AccountControllerListener {
        private volatile boolean hasDownloadLinks = false;
        private volatile boolean hasCrawledLinks = false;
        private volatile boolean hasLinks = false;
        private volatile boolean hasAccounts = false;
        private volatile long lastFreeDownloadSeen = -1L;
        private volatile long lastPremiumDownloadSeen = -1L;
        private volatile long lastMultiDownloadSeen = -1L;
        private volatile long lastAccountChangeSeen = -1L;
        private final AtomicBoolean hasChanges = new AtomicBoolean(false);
        private long lastUpdateTimestamp = -1L;
        private final DomainInfo domainInfo;
        private volatile long lastDownloadLinkEnabled = -1L;
        private volatile long lastDownloadLinkDisabled = -1L;
        private volatile long lastCrawledLinkEnabled = -1L;
        private volatile long lastCrawledLinkDisabled = -1L;

        protected AvailableBanner(String domain) {
            this.domainInfo = DomainInfo.getInstance(domain);
            DownloadController.getInstance().getEventSender().addListener((EventListener)this, true);
            LinkCollector.getInstance().getEventsender().addListener(this, true);
            DownloadWatchDog.getInstance().getEventSender().addListener(this, true);
            AccountController.getInstance().getEventSender().addListener((EventListener)this, true);
        }

        public boolean hasRunningDownloads() {
            for (SingleDownloadController singleDownloadController : DownloadWatchDog.getInstance().getRunningDownloadLinks()) {
                if (!StringUtils.equalsIgnoreCase((String)this.getHost(), (String)singleDownloadController.getDownloadLink().getHost())) continue;
                return true;
            }
            return false;
        }

        public String getHost() {
            return this.domainInfo.getTld();
        }

        protected String getIconHost() {
            return this.getHost();
        }

        public Icon getIcon() {
            return this.getIcon(TranslationFactory.getDesiredLanguage());
        }

        public Icon getIcon(String lng) {
            if (StringUtils.isEmpty((String)lng)) {
                String iconKey = "banner/" + this.getIconHost() + "_en";
                return this.loadIcon(iconKey);
            }
            String iconKey = "banner/" + this.getIconHost() + "_" + lng;
            Icon ret = this.loadIcon(iconKey);
            if (ret != null) {
                return ret;
            }
            return this.getIcon(null);
        }

        public String getURL() {
            return this.getHost();
        }

        protected Icon loadIcon(String relPath) {
            if (NewTheme.getInstance().hasIcon(relPath)) {
                try {
                    return NewTheme.getInstance().getIcon(relPath, -1, 25);
                }
                catch (Throwable e) {
                    LogController.CL().log(e);
                }
            }
            return null;
        }

        public DomainInfo getDomainInfo() {
            return this.domainInfo;
        }

        public void onClick(final MouseEvent e) {
            new EDTRunner(){

                protected void runInEDT() {
                    new OpenURLAction(AvailableBanner.this.getDomainInfo(), "Banner12072017").actionPerformed(new ActionEvent(e.getSource(), e.getID(), e.paramString()));
                }
            };
        }

        public String getPreSelectedInAddAccountDialog() {
            return this.getHost();
        }

        private boolean updateData() {
            if (System.currentTimeMillis() - this.lastUpdateTimestamp > 60000L) {
                DomainInfo domainInfo = this.getDomainInfo();
                boolean hasDownloadLinks = this.hasDownloadLinks;
                boolean hasCrawledLinks = this.hasCrawledLinks;
                boolean hasLinks = this.hasLinks;
                boolean hasRunningDownloadWithAccount = false;
                if (!hasDownloadLinks || this.lastDownloadLinkEnabled < this.lastUpdateTimestamp) {
                    boolean hasRunningDownload = false;
                    for (SingleDownloadController singleDownloadController : DownloadWatchDog.getInstance().getRunningDownloadLinks()) {
                        DownloadLinkCandidate candidate = singleDownloadController.getDownloadLinkCandidate();
                        if (domainInfo != candidate.getLink().getDomainInfo()) continue;
                        hasRunningDownload = true;
                        block0 : switch (candidate.getCachedAccount().getType()) {
                            case ORIGINAL: {
                                switch (candidate.getCachedAccount().getAccount().getType()) {
                                    case LIFETIME: 
                                    case PREMIUM: {
                                        hasRunningDownloadWithAccount = true;
                                        break block0;
                                    }
                                }
                                break;
                            }
                        }
                    }
                    this.hasDownloadLinks = hasRunningDownload ? true : BannerRotation.contains(DownloadController.getInstance(), domainInfo, Boolean.TRUE);
                }
                if (!hasCrawledLinks || this.lastCrawledLinkEnabled < this.lastUpdateTimestamp) {
                    this.hasCrawledLinks = BannerRotation.contains(LinkCollector.getInstance(), domainInfo, Boolean.TRUE);
                }
                if (this.hasDownloadLinks || this.hasCrawledLinks) {
                    this.hasLinks = true;
                } else if (!hasLinks || this.lastDownloadLinkDisabled < this.lastUpdateTimestamp || this.lastCrawledLinkDisabled < this.lastUpdateTimestamp) {
                    this.hasLinks = BannerRotation.contains(DownloadController.getInstance(), domainInfo, null) || BannerRotation.contains(LinkCollector.getInstance(), domainInfo, null);
                }
                boolean hasAccounts = this.hasAccounts;
                if (hasRunningDownloadWithAccount) {
                    this.hasAccounts = true;
                } else if (!hasAccounts || this.lastAccountChangeSeen < this.lastUpdateTimestamp) {
                    this.hasAccounts = false;
                    ArrayList<Account> accounts = AccountController.getInstance().getValidAccounts(this.getHost());
                    if (accounts != null) {
                        for (Account account : accounts) {
                            switch (account.getType()) {
                                case LIFETIME: 
                                case PREMIUM: {
                                    this.hasAccounts = true;
                                    break;
                                }
                            }
                        }
                    }
                }
                this.lastUpdateTimestamp = System.currentTimeMillis();
                return hasAccounts != this.hasAccounts || hasLinks != this.hasLinks || hasDownloadLinks != this.hasDownloadLinks || hasCrawledLinks != this.hasCrawledLinks;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDownloadControllerAddedPackage(FilePackage pkg) {
            boolean readL = pkg.getModifyLock().readLock();
            try {
                for (final DownloadLink link : pkg.getChildren()) {
                    if (link == null || DownloadLink.AvailableStatus.FALSE.equals((Object)link.getAvailableStatus()) || this.getDomainInfo() != link.getDomainInfo()) continue;
                    BannerRotation.this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                        protected Void run() throws RuntimeException {
                            AvailableBanner.this.hasLinks = true;
                            if (link.isEnabled()) {
                                AvailableBanner.this.hasDownloadLinks = true;
                                AvailableBanner.this.lastDownloadLinkEnabled = System.currentTimeMillis();
                            } else {
                                AvailableBanner.this.lastDownloadLinkDisabled = System.currentTimeMillis();
                            }
                            return null;
                        }
                    });
                    this.onChange();
                    break;
                }
            }
            finally {
                pkg.getModifyLock().readUnlock(readL);
            }
        }

        @Override
        public void onDownloadControllerStructureRefresh(FilePackage pkg) {
        }

        @Override
        public void onDownloadControllerStructureRefresh() {
        }

        @Override
        public void onDownloadControllerStructureRefresh(AbstractNode node, Object param) {
        }

        @Override
        public void onDownloadControllerRemovedPackage(FilePackage pkg) {
        }

        @Override
        public void onDownloadControllerRemovedLinklist(List<DownloadLink> list) {
        }

        @Override
        public void onDownloadControllerUpdatedData(final DownloadLink link, DownloadLinkProperty property) {
            if (link != null && !DownloadLink.AvailableStatus.FALSE.equals((Object)link.getAvailableStatus()) && this.getDomainInfo() == link.getDomainInfo()) {
                BannerRotation.this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        AvailableBanner.this.hasLinks = true;
                        if (link.isEnabled()) {
                            AvailableBanner.this.hasDownloadLinks = true;
                            AvailableBanner.this.lastDownloadLinkEnabled = System.currentTimeMillis();
                        } else {
                            AvailableBanner.this.lastDownloadLinkDisabled = System.currentTimeMillis();
                        }
                        return null;
                    }
                });
                this.onChange();
            }
        }

        @Override
        public void onDownloadControllerUpdatedData(FilePackage pkg, FilePackageProperty property) {
        }

        @Override
        public void onDownloadControllerUpdatedData(DownloadLink downloadlink) {
        }

        @Override
        public void onDownloadControllerUpdatedData(FilePackage pkg) {
        }

        @Override
        public void onLinkCollectorAbort(LinkCollectorEvent event) {
        }

        @Override
        public void onLinkCollectorFilteredLinksAvailable(LinkCollectorEvent event) {
        }

        @Override
        public void onLinkCollectorFilteredLinksEmpty(LinkCollectorEvent event) {
        }

        @Override
        public void onLinkCollectorDataRefresh(LinkCollectorEvent event) {
            CrawledLink link;
            if (event != null && event.getParameter() instanceof CrawledLink && (link = (CrawledLink)event.getParameter()) != null && !AvailableLinkState.OFFLINE.equals((Object)link.getLinkState()) && this.getDomainInfo() == link.getDomainInfo()) {
                BannerRotation.this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        AvailableBanner.this.hasLinks = true;
                        if (link.isEnabled()) {
                            AvailableBanner.this.hasCrawledLinks = true;
                            AvailableBanner.this.lastCrawledLinkEnabled = System.currentTimeMillis();
                        } else {
                            AvailableBanner.this.lastCrawledLinkDisabled = System.currentTimeMillis();
                        }
                        return null;
                    }
                });
                this.onChange();
            }
        }

        @Override
        public void onLinkCollectorStructureRefresh(LinkCollectorEvent event) {
        }

        @Override
        public void onLinkCollectorContentRemoved(LinkCollectorEvent event) {
        }

        @Override
        public void onLinkCollectorContentAdded(LinkCollectorEvent event) {
        }

        @Override
        public void onLinkCollectorLinkAdded(LinkCollectorEvent event, final CrawledLink link) {
            if (link != null && !AvailableLinkState.OFFLINE.equals((Object)link.getLinkState()) && this.getDomainInfo() == link.getDomainInfo()) {
                BannerRotation.this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        AvailableBanner.this.hasLinks = true;
                        if (link.isEnabled()) {
                            AvailableBanner.this.hasCrawledLinks = true;
                            AvailableBanner.this.lastCrawledLinkEnabled = System.currentTimeMillis();
                        } else {
                            AvailableBanner.this.lastCrawledLinkDisabled = System.currentTimeMillis();
                        }
                        return null;
                    }
                });
                this.onChange();
            }
        }

        @Override
        public void onLinkCollectorDupeAdded(LinkCollectorEvent event, final CrawledLink link) {
            if (link != null && !AvailableLinkState.OFFLINE.equals((Object)link.getLinkState()) && this.getDomainInfo() == link.getDomainInfo()) {
                BannerRotation.this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        AvailableBanner.this.hasLinks = true;
                        if (link.isEnabled()) {
                            AvailableBanner.this.hasCrawledLinks = true;
                            AvailableBanner.this.lastCrawledLinkEnabled = System.currentTimeMillis();
                        } else {
                            AvailableBanner.this.lastCrawledLinkDisabled = System.currentTimeMillis();
                        }
                        return null;
                    }
                });
                this.onChange();
            }
        }

        @Override
        public void onLinkCrawlerAdded(LinkCollectorCrawler crawler) {
        }

        @Override
        public void onLinkCrawlerStarted(LinkCollectorCrawler crawler) {
        }

        @Override
        public void onLinkCrawlerStopped(LinkCollectorCrawler crawler) {
        }

        @Override
        public void onLinkCrawlerFinished() {
        }

        @Override
        public void onLinkCrawlerNewJob(LinkCollectingJob job) {
        }

        @Override
        public void onDownloadWatchdogDataUpdate() {
        }

        @Override
        public void onDownloadWatchdogStateIsIdle() {
        }

        @Override
        public void onDownloadWatchdogStateIsPause() {
        }

        @Override
        public void onDownloadWatchdogStateIsRunning() {
        }

        @Override
        public void onDownloadWatchdogStateIsStopped() {
        }

        @Override
        public void onDownloadWatchdogStateIsStopping() {
        }

        @Override
        public void onDownloadControllerStart(SingleDownloadController downloadController, final DownloadLinkCandidate candidate) {
            if (this.getDomainInfo() == candidate.getLink().getDomainInfo()) {
                BannerRotation.this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        AvailableBanner.this.hasDownloadLinks = true;
                        AvailableBanner.this.hasLinks = true;
                        block0 : switch (candidate.getCachedAccount().getType()) {
                            case NONE: {
                                AvailableBanner.this.lastFreeDownloadSeen = System.currentTimeMillis();
                                break;
                            }
                            case ORIGINAL: {
                                switch (candidate.getCachedAccount().getAccount().getType()) {
                                    case FREE: 
                                    case UNKNOWN: {
                                        AvailableBanner.this.lastFreeDownloadSeen = System.currentTimeMillis();
                                        break block0;
                                    }
                                }
                                AvailableBanner.this.lastPremiumDownloadSeen = System.currentTimeMillis();
                                break;
                            }
                            case MULTI: {
                                AvailableBanner.this.lastMultiDownloadSeen = System.currentTimeMillis();
                                break;
                            }
                        }
                        return null;
                    }
                });
                this.onChange();
            }
        }

        @Override
        public void onDownloadControllerStopped(SingleDownloadController downloadController, DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
        }

        @Override
        public void onDownloadWatchDogPropertyChange(DownloadWatchDogProperty propertyChange) {
        }

        @Override
        public void onAccountControllerEvent(AccountControllerEvent event) {
            Account acc = event.getAccount();
            if (acc != null && StringUtils.equalsIgnoreCase((String)this.getDomainInfo().getTld(), (String)acc.getHoster())) {
                block0 : switch ((AccountControllerEvent.Types)((Object)event.getType())) {
                    case ADDED: 
                    case ACCOUNT_UP_OR_DOWNGRADE: 
                    case ACCOUNT_CHECKED: {
                        switch (acc.getType()) {
                            case LIFETIME: 
                            case PREMIUM: {
                                if (!acc.isEnabled() || !acc.isValid()) break block0;
                                BannerRotation.this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                                    protected Void run() throws RuntimeException {
                                        AvailableBanner.this.hasAccounts = true;
                                        AvailableBanner.this.lastAccountChangeSeen = System.currentTimeMillis();
                                        return null;
                                    }
                                });
                                this.onChange();
                                break block0;
                            }
                        }
                        break;
                    }
                }
            }
        }

        public boolean hasChanges() {
            return (Boolean)BannerRotation.this.queue.addWait((QueueAction)new QueueAction<Boolean, RuntimeException>(){

                protected Boolean run() throws RuntimeException {
                    return AvailableBanner.this.updateData() || AvailableBanner.this.hasChanges.compareAndSet(true, false);
                }
            });
        }

        protected void onChange() {
            this.hasChanges.set(true);
            BannerRotation.this.onChange(this);
        }
    }
}

